##
# Copyright 2019 ETSI
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
##

charms=`cat bundles/osm/bundle.yaml  | grep cs | grep -v k8s | awk '{print $2}' | tr -d \"`
for charm_uri in $charms; do
    charm_without_rev=`echo $charm_uri| rev | cut -d "-" -f 2-5 | rev`
    latest_revision=`charm show --channel edge $charm_without_rev | grep Revision | awk '{print $2}'`
    new_charm_uri=$charm_without_rev-$latest_revision
    old_uri=`echo $charm_uri | sed 's/\//\\\\\//g'`
    new_uri=`echo $new_charm_uri | sed 's/\//\\\\\//g'`
    sed -i "s/"$old_uri"/"$new_uri"/g" bundles/osm/bundle.yaml
done

charms=`cat bundles/osm-ha/bundle.yaml  | grep cs | grep -v k8s | awk '{print $2}' | tr -d \"`
for charm_uri in $charms; do
    charm_without_rev=`echo $charm_uri| rev | cut -d "-" -f 2-5 | rev`
    latest_revision=`charm show --channel edge $charm_without_rev | grep Revision | awk '{print $2}'`
    new_charm_uri=$charm_without_rev-$latest_revision
    old_uri=`echo $charm_uri | sed 's/\//\\\\\//g'`
    new_uri=`echo $new_charm_uri | sed 's/\//\\\\\//g'`
    sed -i "s/"$old_uri"/"$new_uri"/g" bundles/osm-ha/bundle.yaml
done