# Copyright 2021 Canonical Ltd.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.
#

# Keystone Operator

[![code style](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black/tree/main)

[![Keystone](https://charmhub.io/osm-keystone/badge.svg)](https://charmhub.io/osm-keystone)

## Description

This charm deploys Keystone in K8s. It is mainly developed to be used as part of the OSM deployment.

## Usage

The Keystone Operator may be deployed using the Juju command line as in

```shell
$ juju add-model keystone
$ juju deploy charmed-osm-mariadb-k8s db
$ juju deploy osm-keystone --trust
$ juju relate osm-keystone db
```

## OCI Images

- [keystone](https://hub.docker.com/r/opensourcemano/keystone)

## Contributing

Please see the [Juju SDK docs](https://juju.is/docs/sdk) for guidelines
on enhancements to this charm following best practice guidelines, and
`CONTRIBUTING.md` for developer guidance.
