#!/bin/sh
#   Copyright 2021 Canonical Ltd.
#   Copyright ETSI
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

set -eu

if [ $(git diff --name-only origin/$GERRIT_BRANCH -- installers/charm/ |wc -l) -eq 0 ]; then
    exit 0
fi

CURRENT_DIR=`pwd`

# Execute tests for charms
CHARM_PATH="./installers/charm"
CHARM_NAMES="keystone lcm mon nbi ng-ui pla pol prometheus ro grafana mongodb-exporter mysqld-exporter kafka-exporter"
for charm in $CHARM_NAMES; do
    cd $CHARM_PATH/$charm
    TOX_PARALLEL_NO_SPINNER=1 tox --parallel=auto
    cd $CURRENT_DIR
done
