#!/bin/bash
#
# Script to generate documentation and upload it to ETSI site
#

source ./env

FOLDER=${1-${FOLDER}}
echo "Destination folder in the FTP: $FOLDER"

#
# Get credentias (file or interactive)
#
if [ -f local/.credentials ]; then
	source local/.credentials
	echo SERVER=${SERVER}
	echo USERNAME=${USERNAME}
else
	echo "Enter credentials for ${SERVER} (ETSI On Line account)"
	read -p  "Username: " USERNAME
	read -sp "Password: " PASSWORD
fi

lftp ${FTP_OPTS} -u ${USERNAME},${PASSWORD} ${SERVER} << !
   set ftp:ssl-allow no
   set ftp:use-allo false
   set ftp:prefer-epsv false
   set ftp:sync-mode no
   set ftp:use-mdtm no
   lcd _build
   cd Documentation

   mirror -R html ${FOLDER}-new
   rm -r ${FOLDER}-old
   mv ${FOLDER} ${FOLDER}-old
   mv ${FOLDER}-new ${FOLDER}
   bye
!
