# Annex 10: Tutorial - Charmed OSM installation and deployment of a CNF

## Introduction

In this tutorial you will install OSM that will be used to deploy and configure a CNF in a K8s cluster. Along the way you will attach a VIM and a K8s cluster to OSM in order to be able to deploy workloads, and also upload VNF packages, so they can be used later on.

## Prerequisites

To complete this tutorial you need a fresh [Ubuntu 20.04](https://cloud-images.ubuntu.com/focal/current/focal-server-cloudimg-amd64-disk-kvm.img) VM with the following requirements:

* 16 GB of RAM
* 4 CPUs
* 80GB disk
* Single network interface with Internet access

## Install OSM

We are going to download the installation script, and give it executable permissions. Then, we will install OSM with `--small-profile` option. That will install an OSM version prepared to deploy CNFs only.

```bash
wget https://osm-download.etsi.org/ftp/osm-12.0-twelve/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh --charmed --small-profile
```

The installation process takes around 10/15 minutes depending on your connection. When it finishes you will see something similar to this output:

```bash
Your installation is now complete, follow these steps for configuring the osmclient:

1. Create the OSM_HOSTNAME environment variable with the NBI IP

export OSM_HOSTNAME=nbi.172.21.248.37.nip.io:443
export OSM_PASSWORD=674cea0bd2c43265c2f4c5de32dd98c3

2. Add the previous commands to your .bashrc for other Shell sessions

echo "export OSM_HOSTNAME=nbi.172.21.248.37.nip.io:443" >> ~/.bashrc
echo "export OSM_PASSWORD=674cea0bd2c43265c2f4c5de32dd98c3" >> ~/.bashrc

3. Login OSM GUI by using admin password: 674cea0bd2c43265c2f4c5de32dd98c3

DONE
Track end end: https://osm.etsi.org/InstallLog.php?&installation_id=1664351299-NLbpOIt3Vf4iNE8H&local_ts=1664351722&event=end&operation=end&value=&comment=&tags=
Track end installation_type: https://osm.etsi.org/InstallLog.php?&installation_id=1664351299-NLbpOIt3Vf4iNE8H&local_ts=1664351722&event=end&operation=installation_type&value=Charmed&comment=&tags=

DONE
```

Now, to complete the installation, we will follow the instructions in points 1 and 2 of the installer output. We can copy and paste the commands directly:

```bash
export OSM_HOSTNAME=nbi.172.21.248.37.nip.io:443
export OSM_PASSWORD=674cea0bd2c43265c2f4c5de32dd98c3

echo "export OSM_HOSTNAME=nbi.172.21.248.37.nip.io:443" >> ~/.bashrc
echo "export OSM_PASSWORD=674cea0bd2c43265c2f4c5de32dd98c3" >> ~/.bashrc
```

OSM is ready to be used!

## Deployment of a CNF
### Add a K8s cluster to OSM

OSM needs a VIM (Virtual Infrastracture Manager) to be linked to a Kubernetes cluster, so the first thing we will do, will be to add a fake VIM to it:

```bash
osm vim-create --name dummyvim --user u --password p --tenant p --account_type dummy --auth_url http://localhost/dummy
```

Now, we need the credentials of the Kubernetes cluster. The standard installation of Charmed OSM uses microk8s, so in order to get the credentials of the microk8s cluster we execute:

```bash
microk8s.config > microk8s-kubeconfig.yaml
```

---
**NOTE**

If you have just installed Charmed OSM, could be the case that you need to logout and login again in the console in order to use the `microk8s` command.

---

And then to attach our microk8s to deploy CNFs:

```bash
osm k8scluster-add microk8s --creds microk8s-kubeconfig.yaml --vim dummyvim --k8s-nets '{k8s_net1: null}' --version "v1.23" --description="Isolated K8s cluster"
```

You can check the status of the K8scluster with the following command:

```bash
$ osm k8scluster-list
+----------+--------------------------------------+----------+-------------------+-------------------+
| Name     | Id                                   | VIM      | Operational State | Op. state details |
+----------+--------------------------------------+----------+-------------------+-------------------+
| microk8s | 877c696e-bc36-4499-a15b-36f3a4b0574d | dummyvim | ENABLED           | Helm: ENABLED     |
|          |                                      |          |                   | Juju: ENABLED     |
+----------+--------------------------------------+----------+-------------------+-------------------+
```

If you see that the general `operational state` is `ENABLED` and the `operational state` of Helm and Juju are also `ENABLED` then your K8s cluster is ready to be used.

### Upload the CNF packages to Charmed OSM

First we will clone the `osm-packages` repo. In this repo, we can find different examples of VNFs and CNFs that can be deployed with OSM.

```bash
git clone --recursive https://osm.etsi.org/gitlab/vnf-onboarding/osm-packages
```

We are going to upload the `squid proxy` package. Squid is a web server application which provides proxy and cache services for protocols like HTTP or FTP. These are the commands to upload `squid proxy` packages to OSM:

```bash
cd osm-packages

osm nfpkg-create squid_metrics_cnf
osm nspkg-create squid_metrics_cnf_ns

```

You can see that the packages have been successfully uploaded if the `squid_cnf` vnf package and the `squid_cnf_ns` network service package are listed when you type the following commands:

```bash
$ osm vnfd-list
+--------------+--------------------------------------+-----------+
| nfpkg name   | id                                   | desc type |
+--------------+--------------------------------------+-----------+
| squid_cnf    | c1763aa7-209b-45df-9403-63f34eb9ebde | sol006    |
+--------------+--------------------------------------+-----------+


$ osm nsd-list
+--------------+--------------------------------------+
| nsd name     | id                                   |
+--------------+--------------------------------------+
| squid_cnf_ns | d99eb544-0415-46cc-a6ef-b78d9c83778d |
+--------------+--------------------------------------+

```

### Deploy the CNF

Now that we have all the packages uploaded to OSM, we are going to instantiate the squid proxy using this command:

```bash
osm ns-create --ns_name squid --nsd_name squid_cnf_ns --vim_account dummyvim
```

After a few minutes the CNF should be already instantiated:

```bash
$ osm ns-list
+------------------+--------------------------------------+---------------------+----------+-------------------+---------------+
| ns instance name | id                                   | date                | ns state | current operation | error details |
+------------------+--------------------------------------+---------------------+----------+-------------------+---------------+
| squid            | ed9e8e52-f96f-4a33-ae2c-198ce944d1fd | 2022-02-07T12:51:07 | READY    | IDLE (None)       | N/A           |
+------------------+--------------------------------------+---------------------+----------+-------------------+---------------+
To get the history of all operations over a NS, run "osm ns-op-list NS_ID"
For more details on the current operation, run "osm ns-op-show OPERATION_ID"
```

You can see that the `ns state` has changed from `BUILDING` to `READY`, and the `current operation` has changed from `INSTANTIATING` to `IDLE`.

## Testing the CNF and day-2 actions

### Test the squid proxy

The squid proxy is configured by default to deny the access to any web page we want to browse. First, we are going to test this behavior.

We need the IP address of our squid that we will use to go through the proxy to Internet. We can get the IP executing the following commands:

```bash
# Get squid VNF ID
$ VNF_ID=`osm vnf-list --ns squid | grep squid_cnf | awk '{print $2}'`

# Get squid ClusterIP
$ sudo snap install yq
$ SQUID_IP=`osm vnf-show $VNF_ID --literal | yq e '.kdur[0].services[] | select(.name == "squid") | .cluster_ip'`
$ echo $SQUID_IP
10.152.183.94
```

Then, we will use this IP as a proxy to browse a web page:

```bash
$ HTTPS_PROXY=$SQUID_IP:3128 curl https://google.com
curl: (56) Received HTTP code 403 from proxy after CONNECT
```

We will receive an `HTTP 403 - FORBIDDEN` response.

### Allow a url to pass through the proxy

So, we saw that our squid proxy will forbid us to navigate to Internet. Now, we want to change its configuration in order to be able to go to `google.com`. For that we will use the following OSM's day-2 action:

```bash
$ osm ns-action squid --vnf_name squid_cnf \
                      --kdu_name squid-metrics-kdu \
                      --action_name add-url \
                      --params '{application-name: squid, url: google.com}' \
                      --wait
```

So then, if we try again (the squid can take a couple of minutes until it is updated with the new configuration) we will see that we can navigate to `google.com`:

```bash
$ HTTPS_PROXY=$SQUID_IP:3128 curl https://google.com
<HTML><HEAD><meta http-equiv="content-type" content="text/html;charset=utf-8">
<TITLE>301 Moved</TITLE></HEAD><BODY>
<H1>301 Moved</H1>
The document has moved
<A HREF="https://www.google.com/">here</A>.
</BODY></HTML>
```

OSM allowed us to manage the squid proxy CNF and change its settings to be able to browse `google.com`.
