# ANNEX 3: Reference of OSM Information Model

## YANG model in OSM repos

YANG models can be found in the IM repo under the models folder: <https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree>

OSM uses [pyang](https://github.com/mbj4668/pyang) and [pyangbind](https://github.com/robshakir/pyangbind) to generate Python classes used by the different OSM components.

Since Release NINE, OSM IM is fully aligned with [ETSI NFV SOL006](https://www.etsi.org/deliver/etsi_gs/NFV-SOL/001_099/006/02.06.01_60/gs_NFV-SOL006v020601p.pdf). OSM Information Model augments [ETSI NFV SOL006 YANG models](https://forge.etsi.org/rep/nfv/SOL006/tree/v2.6.1) by adding the support of Network Slices, day-1 and day-2 primitives at VNF and NS level, and Enhanced Platform Awareness for dataplane workloads. Augments can be found in this folder: <https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree;f=models/augments>

## OSM IM tree representation

Below you can find tree representations of the VNFD (VNF Descriptor), NSD (Network Service Descriptor), NST (Network Slice Template), VNFR (VNF Record), NSR (Network Service Record), NSI (Network Slice Instance), both in navigable and plain text formats.

### VNFD tree

* [Navigable Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/etsi-nfv-vnfd.html)

* [Plain Text Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/etsi-nfv-vnfd.tree.txt)

### NSD tree

* [Navigable Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/etsi-nfv-nsd.html)

* [Plain Text Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/etsi-nfv-nsd.tree.txt)

### NST tree

* [Navigable Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/nst.html)

* [Plain Text Version](http://osm-download.etsi.org/repository/osm/debian/ReleaseSEVENTEEN/docs/osm-im/osm_im_trees/nst.tree.txt)

## OSM URN Namespace

### Introduction

OSM is maintaining a namespace registry as a sub tree of the ETSI root `urn:etsi` namespace. A description of the top level ETSI URN namespace can be found on the [ETSI PNNS page](https://portal.etsi.org/PNNS/GenericAllocation/ETSIURNNamespace.aspx)

The OSM URN namespace has the following structure:

```text
urn:etsi:osm:<OSM sub-tree>
```

The following sections describe the basic structure of the sub-tree and how a entry in the registry can be requested.

### OSM sub-tree

| OSM sub-tree |    Full Namespace    |  Type  |                         Description                          |
| :----------: | :------------------: | :----: | :----------------------------------------------------------: |
|     yang     | `urn:etsi:osm:yang`  | string | Namespace for YANG modules specified in OSM.[OSM/IM.git](https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree;f=models/yang) |
|    yang:augments    | `urn:etsi:osm:yang:augments`  | string | Namespace for YANG modules specified in OSM augmenting SOL006.[OSM/IM.git](https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree;f=models/yang/augments) |

#### Type definitions

```python
string = (ALPHA)0*(ALPHANUMERIC/-/_)
## a string starts with an upper- or lower-case letter followed by zero or more upper- or lower-case letters, integer numbers, hyphens or underscores

ALPHA = {a-zA-Z}
ALPHANUMERIC = {a-zA-Z0-9}
```

### Requesting an entry

The procedure to request an entry is described as follows.

- **Step #1:** Send an e-mail to the <OSM_TSC@list.etsi.org> mailing list indicating the name of the sub-tree, the contact person and the purpose of that subtree.
- **Step #2:** The TSC will review the proposal.
  - If the application is accepted, a new entry in the "OSM URN Namespace" will be enabled.
  - If the application cannot be accepted, it will be communicated to the contact person together with any additional information to be considered for resolving the "non-acceptance".

## Release EIGHT DESCRIPTOR Documentation (OLD)

The link below contains a detailed description of the OSM Release EIGHT Information Model, previous to the alignment to ETSI NFV SOL006. It can still be used as a reference to compare the previous IM and the current IM.

[OSM Release EIGHT Information Model](http://osm-download.etsi.org/repository/osm/debian/ReleaseEIGHT/docs/osm-im/osm_im_trees/)

## Release TWO Descriptor Documentation (OLD)

The document below contains a detailed description of the OSM Release TWO Models. Although a bit outdated, it can still be used as a reference to understand some of the fields in the VNFD and NSD.

[OSM Release TWO Information Model](https://osm.etsi.org/wikipub/images/2/26/OSM_R2_Information_Model.pdf)

