# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))


# -- Project information -----------------------------------------------------

project = 'Open Source MANO'
copyright = '2020, ETSI OSM'
author = 'ETSI OSM'

# The full version, including alpha/beta/rc tags
release = ''

# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = ['sphinx.ext.autodoc',
    'sphinx.ext.doctest',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinx.ext.githubpages',
    'recommonmark',
    'sphinx_markdown_tables',
    'sphinx_multiversion',
]

source_suffix = {
    '.rst': 'restructuredtext',
    '.txt': 'markdown',
    '.md': 'markdown',
}

# The master toctree document.
master_doc = 'index'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store', 'README.md',
                    'navigation.md', 'index.md', 'requirements.txt']


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
#html_theme = 'alabaster'
#html_theme = 'pyramid'
#html_theme = 'bizstyle'
html_theme = 'sphinx_rtd_theme'
#html_theme = 'neo_rtd_theme'
#import sphinx_theme
#html_theme_path = [sphinx_theme.get_html_theme_path()]

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_theme_options = {
    'canonical_url': 'https://osm.etsi.org/docs',
    'logo_only': True,
    'display_version': True,
    'prev_next_buttons_location': 'bottom',
    'style_external_links': False,
    #'style_nav_header_background': 'white',
    # Toc options
    'collapse_navigation': True,
    'sticky_navigation': True,
    'navigation_depth': 3,
    'includehidden': True,
    'titles_only': False
}

#html_logo = 'assets/osm_logo.png'
html_logo = 'assets/osm_logo.svg'

smv_current_version = 'latest'
#smv_tag_whitelist = None
#smv_tag_whitelist = r'^v\d+\.\d+$'
smv_tag_whitelist = r'(latest|develop)'
#smv_branch_whitelist = None
#smv_branch_whitelist = r'^v\d+\.\d+$'
smv_branch_whitelist = r'(v15|v14|v13|v12|v11|v10)'
#smv_remote_whitelist = 'None'
smv_remote_whitelist = r'(origin)'
smv_released_pattern = r'(latest|v15|v14|v13|v12|v11|v10|develop)'
#smv_outputdir_format = 'versions/{config.release}'    # Use "versions" as parent directory and the "release" variable from conf.py
#smv_outputdir_format = 'versions/{ref.name}'

