# OSM User Guide

## Scope of the document

This document collects Open Source MANO User Guide.

It is published at [https://osm.etsi.org/docs/user-guide/](https://osm.etsi.org/docs/user-guide/) 

## Guidelines for contributors

- OSM [Workflow for documentation production](https://osm.etsi.org/gitlab/osm-doc/documentation-how-to/blob/master/Workflow%20for%20documentation%20production%20in%20OSM.md#guide-for-contributors) must be used.
- Every section of this document, under a "H1" tag (single #), must be contained in a single file and formatted according to the following [sample document](#)

## Exporting the document to HTML

This markdown format can be easily exported by installing and using [Sphinx](http://www.sphinx-doc.org/en/master/) in your local machine.

Before proceeding, **make sure that there are no uncommitted changes in your workdir or your staging area** (in case of doubt, do all the corresponding `add`'s and `commit`'s).

Then run:

```bash
tox -e build
```

The generated HTML output is stored in `_build/html` with separate folders for each version.

## Local publication

You can go to that folder and publish the content locally with a Simple HTTP Server in Python:

```bash
python3 -m http.server <PORT>
```

Then you can check the generated HTML output with a local web browser pointing to <http://localhost:PORT>

## Publication in ETSI OSM site

For regular publication in ETSI site, you can run this to upload the HTML documents to the FTP (it also performs a backup for safety):

```bash
tox -e publish
```

This script uses `upload_doc.sh` behind the scenes. It searchs for authorized EOL credentials in `local/.credentials`. In case the file does not exist, the user is prompted for valid EOL username and password.

