# Annex 8: TACACS Based Authentication Support In OSM

## Introduction 

Terminal Access Controller Access-Control System (TACACS) refers to a family of related protocols handling remote authentication and related services for networked access control through a centralized server.

OSM NB has a plugin which can interact with TACACS server to authenticate users.

## Integration

### Prerequisite for Integration

- TACACS host ip address reachable from OSM.
- TACACS server secret(or password).

### Integration Steps

Configure NBI to use TACACS plugin, by modiifying `nbi.cfg`:

- Set `authentication.backend` as `tacacs`
- Set `authentication.tacacs_host` as TACACS host ip
- Set `authentication.tacacs_secret` as TACACS server secret

## Testing Steps

### Prerequisite for Testing

- Ensure users are present in TACACS server, which can be used for authentication.
- Configure OSM as mentioned above.

### Testing

- Login with credentials present in TACACS server.
- OSM User with `system_admin` role or similar can assign project role mapping.
- TACACS users can log in using their credentials.

## Limitations

Since TACACS is used as read-only service, username update and password update shall not be allowed via OSM. User credentials need to be updated by TACACS admin in TACACS to reflect. However, OSM admin can handle project role assignment as required.
     
If user profile is removed from TACACS server, OSM still maintains the profile and will not be removed until next login. As the profile is not available in TACACS, the authentication shall fail and user profile will be removed from OSM.

