# ANNEX 2: Reference of OSM Client commands and library

The **OSM Client** is a client library and a command-line tool (based on Python) to operate OSM, which accesses OSM's Northbound Interface (NBI) and lets you manage descriptors, VIMs, Network Services, Slices, etc. along with their whole lifecycle. In other words, the OSM Client is a sort of Swiss knife that provides a convenient access to all the functionality that OSM's NBI offers.

**Usage:**

```bash
osm [GLOBAL_OPTIONS] COMMAND [COMMAND_OPTIONS] [ARGS]...
```

**Options:**

```bash
  --hostname TEXT             hostname of server.  Also can set OSM_HOSTNAME in environment
  --user TEXT                 user (defaults to admin). Also can set OSM_USER in environment
  --password TEXT             password (defaults to admin). Also can set OSM_PASSWORD in environment
  --project TEXT              project (defaults to admin). Also can set OSM_PROJECT in environment
  -v, --verbose               increase verbosity (-v INFO, -vv VERBOSE, -vvv DEBUG)
  --all-projects              include all projects
  --public / --no-public      flag for public items (packages, instances, VIM accounts, etc.)
  --project-domain-name TEXT  project domain name for keystone authentication (default to None). Also can set OSM_PROJECT_DOMAIN_NAME in environment
  --user-domain-name TEXT     user domain name for keystone authentication (default to None). Also can set OSM_USER_DOMAIN_NAME in environment
  -h, --help                  Show this message and exit.

Commands:
  k8scluster-add             adds a K8s cluster to OSM NAME: name of the K8s cluster
  k8scluster-delete          deletes a K8s cluster NAME: name or ID of the K8s cluster to be deleted
  k8scluster-list            list all K8s clusters
  k8scluster-show            shows the details of a K8s cluster NAME: name or ID of the K8s cluster
  k8scluster-update          updates a K8s cluster
  netslice-instance-create   creates a new Network Slice Instance
  netslice-instance-delete   deletes a Network Slice Instance (NSI)
  netslice-instance-list     list all Network Slice Instances (NSI)
  netslice-instance-op-list  shows the history of operations over a Network Slice Instance (NSI)
  netslice-instance-op-show  shows the info of an operation over a Network Slice Instance(NSI)
  netslice-instance-show     shows the content of a Network Slice Instance (NSI)
  netslice-template-create   creates a new Network Slice Template (NST)
  netslice-template-delete   deletes a Network Slice Template (NST)
  netslice-template-list     list all Network Slice Templates (NST)
  netslice-template-show     shows the content of a Network Slice Template (NST)
  netslice-template-update   updates a Network Slice Template (NST)
  nf-list                    list all NF instances
  nfpkg-create               creates a new NFpkg
  nfpkg-delete               deletes a NFpkg
  nfpkg-list                 list all xNF packages (VNF, HNF, PNF)
  nfpkg-repo-list            list all xNF from OSM repositories
  nfpkg-repo-show            shows the details of a NF package in an OSM repository
  nfpkg-show                 shows the details of a NF package
  nfpkg-update               updates a NFpkg
  ns-action                  executes an action/primitive over a NS instance
  ns-alarm-create            creates a new alarm for a NS instance
  ns-create                  creates a new Network Service instance
  ns-delete                  deletes a NS instance
  ns-list                    list all NS instances
  ns-metric-export           exports a metric to the internal OSM bus, which can be read by other apps
  ns-op-cancel               cancels an ongoing NS operation
  ns-op-list                 shows the history of operations over a NS instance
  ns-op-show                 shows the info of a NS operation
  ns-show                    shows the info of a NS instance
  nsd-create                 creates a new NSD/NSpkg
  nsd-delete                 deletes a NSD/NSpkg
  nsd-list                   list all NS packages
  nsd-repo-list              list all NS from OSM repositories
  nsd-repo-show              shows the details of a NS package in an OSM repository
  nsd-show                   shows the details of a NS package
  nsd-update                 updates a NSD/NSpkg
  nsi-create                 creates a new Network Slice Instance
  nsi-delete                 deletes a Network Slice Instance (NSI)
  nsi-list                   list all Network Slice Instances (NSI)
  nsi-op-list                shows the history of operations over a Network Slice Instance (NSI)
  nsi-op-show                shows the info of an operation over a Network Slice Instance(NSI)
  nsi-show                   shows the content of a Network Slice Instance (NSI)
  nspkg-create               creates a new NSD/NSpkg
  nspkg-delete               deletes a NSD/NSpkg
  nspkg-list                 list all NS packages
  nspkg-repo-list            list all NS from OSM repositories
  nspkg-repo-show            shows the details of a NS package in an OSM repository
  nspkg-show                 shows the details of a NS package
  nspkg-update               updates a NSD/NSpkg
  nst-create                 creates a new Network Slice Template (NST)
  nst-delete                 deletes a Network Slice Template (NST)
  nst-list                   list all Network Slice Templates (NST)
  nst-show                   shows the content of a Network Slice Template (NST)
  nst-update                 updates a Network Slice Template (NST)
  package-build              Build the tar.gz of the package
  package-create             Create a package descriptor
  package-validate           Validate a package descriptor
  pdu-create                 adds a new Physical Deployment Unit to the catalog
  pdu-delete                 deletes a Physical Deployment Unit (PDU)
  pdu-list                   list all Physical Deployment Units (PDU)
  pdu-show                   shows the content of a Physical Deployment Unit (PDU)
  project-create             creates a new project
  project-delete             deletes a project
  project-list               list all projects
  project-show               shows the details of a project
  project-update             updates a project (only the name can be updated)
  repo-add                   adds a repo to OSM NAME: name of the repo URI: URI of the repo
  repo-delete                deletes a repo NAME: name or ID of the repo to be deleted
  repo-list                  list all repos
  repo-show                  shows the details of a repo NAME: name or ID of the repo
  repo-update                updates a repo in OSM NAME: name of the repo
  role-create                creates a new role
  role-delete                deletes a role
  role-list                  list all roles
  role-show                  show specific role
  role-update                updates a role
  sdnc-create                creates a new SDN controller
  sdnc-delete                deletes an SDN controller
  sdnc-list                  list all SDN controllers
  sdnc-show                  shows the details of an SDN controller
  sdnc-update                updates an SDN controller
  upload-package             uploads a VNF package or NS package
  user-create                creates a new user
  user-delete                deletes a user
  user-list                  list all users
  user-show                  shows the details of a user
  user-update                updates user information
  version
  vim-create                 creates a new VIM account
  vim-delete                 deletes a VIM account
  vim-list                   list all VIM accounts
  vim-show                   shows the details of a VIM account
  vim-update                 updates a VIM account
  vnf-list                   list all NF instances
  vnf-scale                  executes a VNF scale (adding/removing VDUs)
  vnf-show                   shows the info of a VNF instance
  vnfd-create                creates a new VNFD/VNFpkg
  vnfd-delete                deletes a VNFD/VNFpkg
  vnfd-list                  list all xNF packages (VNF, HNF, PNF)
  vnfd-show                  shows the details of a NF package
  vnfd-update                updates a new VNFD/VNFpkg
  vnfpkg-create              creates a new VNFD/VNFpkg
  vnfpkg-delete              deletes a VNFD/VNFpkg
  vnfpkg-list                list all xNF packages (VNF, HNF, PNF)
  vnfpkg-repo-list           list all xNF from OSM repositories
  vnfpkg-repo-show           shows the details of a NF package in an OSM repository
  vnfpkg-show                shows the details of a NF package
  vnfpkg-update              updates a VNFD/VNFpkg
  wim-create                 creates a new WIM account
  wim-delete                 deletes a WIM account
  wim-list                   list all WIM accounts
  wim-show                   shows the details of a WIM account
  wim-update                 updates a WIM account
```

## How to install standalone OSM client

### How to install OSM Client in Ubuntu 22.04 (RECOMMENDED)

OSM client is installed by default in the host where OSM is installed, but it can be also installed as a standalone client in an Ubuntu 22.04 system, following the procedure below:

```bash
# Clean the previous repos that might exist
sudo sed -i "/osm-download.etsi.org/d" /etc/apt/sources.list

# Install dependencies
sudo apt-get update
sudo apt-get install -y python3 python3-dev python3-pip

# Add OSM debian repo
curl -q -o OSM-ETSI-Release-key.gpg https://osm-download.etsi.org/repository/osm/debian/ReleaseSIXTEEN/OSM%20ETSI%20Release%20Key.gpg
sudo apt-key add OSM-ETSI-Release-key.gpg
sudo add-apt-repository -y "deb [arch=amd64] https://osm-download.etsi.org/repository/osm/debian/ReleaseSIXTEEN stable devops IM osmclient"
sudo apt-get update

# Install OSM IM and osmclient packages from deb repo
sudo apt-get install python3-osm-im python3-osmclient

# Install osmclient and osm_im dependencies via pip
sudo -H python3 -m pip install -r /usr/lib/python3/dist-packages/osm_im/requirements.txt -r /usr/lib/python3/dist-packages/osmclient/requirements.txt

# Install charm to be able to build OSM packages with charms
sudo snap install charm --classic
```

### How to install OSM Client in Ubuntu 22.04 via pip (ALTERNATIVE)

```bash
# Install dependencies
sudo apt-get update
sudo apt-get install -y git wget make
sudo apt-get install -y python3 python3-dev python3-pip

# Upgrade pip to the latest version (with sudo, to install it globally for all users)
sudo -H python3 -m pip install -U pip

# Decide which version to use
export OSM_CLIENT_VERSION=v16.0

# Install OSM IM and its dependencies via pip (installed with sudo, to install it globally for all users)
sudo -H python3 -m pip install -r "https://osm.etsi.org/gitweb/?p=osm/IM.git;a=blob_plain;f=requirements.txt;hb=${OSM_CLIENT_VERSION}"
sudo -H python3 -m pip install "git+https://osm.etsi.org/gerrit/osm/IM.git@${OSM_CLIENT_VERSION}#egg=osm-im" --upgrade

# Clone osmclient repo and checkut the desired version
git clone https://osm.etsi.org/gerrit/osm/osmclient
git -C osmclient checkout ${OSM_CLIENT_VERSION}

# Install osmclient using pip
sudo -H python3 -m pip install -r osmclient/requirements.txt
sudo -H python3 -m pip install ./osmclient

# Install charm to be able to build OSM packages with charms
sudo snap install charm --classic
```

### How to install OSM Client in RHEL

```bash
# Install dependencies
sudo dnf upgrade -y
sudo dnf install -y libcurl-devel openssl-devel
sudo dnf install -y git wget make patch gcc
sudo dnf install -y python310 python310-devel

# Upgrade pip to the latest version (with sudo, to install it globally for all users)
sudo -H python3 -m pip install -U pip

# Decide which version to use
export OSM_CLIENT_VERSION=v16.0

# Install OSM IM and its dependencies via pip (installed with sudo, to install it globally for all users)
sudo -H python3 -m pip install -r "https://osm.etsi.org/gitweb/?p=osm/IM.git;a=blob_plain;f=requirements.txt;hb=${OSM_CLIENT_VERSION}"
sudo -H bash -c "PATH=$PATH:/usr/local/bin python3 -m pip install \"git+https://osm.etsi.org/gerrit/osm/IM.git@${OSM_CLIENT_VERSION}#egg=osm-im\" --upgrade"

# Clone osmclient repo and checkut the desired version
git clone https://osm.etsi.org/gerrit/osm/osmclient
git -C osmclient checkout ${OSM_CLIENT_VERSION}

# Install osmclient using pip
sudo -H python3 -m pip install -r osmclient/requirements.txt
sudo -H python3 -m pip install ./osmclient

# Install charm to be able to build OSM packages with charms
wget -O charm.sh "https://osm.etsi.org/gitweb/?p=osm/tests.git;a=blob;f=charm.sh;hb=${OSM_CLIENT_VERSION}"
sudo cp charm.sh /usr/sbin/charm
sudo chmod 755 /usr/sbin/charm

```

### How to install OSM Client for developers in Ubuntu 22.04

```bash
# Install dependencies
sudo apt-get update
sudo apt-get install -y git wget make
sudo apt-get install -y python3 python3-setuptools python3-dev python3-pip

# Upgrade pip to the latest version (with sudo, to install it globally for all users)
sudo -H python3 -m pip install -U pip

# Decide which version to use
export OSM_CLIENT_VERSION=v16.0

# Install OSM IM and its dependencies via pip (installed with sudo, to install it globally for all users)
sudo -H python3 -m pip install -r "https://osm.etsi.org/gitweb/?p=osm/IM.git;a=blob_plain;f=requirements.txt;hb=${OSM_CLIENT_VERSION}"
sudo -H python3 -m pip install "git+https://osm.etsi.org/gerrit/osm/IM.git@${OSM_CLIENT_VERSION}#egg=osm-im" --upgrade

# Clone osmclient repo and checkut the desired version
git clone https://osm.etsi.org/gerrit/osm/osmclient
cd osmclient
git checkout ${OSM_CLIENT_VERSION}

# Install osmclient directly from the repo for development purposes
python3 -m pip install --user -e osmclient -r osmclient/requirements.txt -r osmclient/requirements-dev.txt

# Install charm to be able to build OSM packages with charm
sudo snap install charm --classic

# Logout and login so that PATH can be updated. Executable osm will be found in /home/ubuntu/.local/bin
which osm
```

### How to install OSM Client in Windows with WSL

OSM client can be easily installed in Windows by installing an Ubuntu distro on Linux with [Windows Subsystem for Linux (WSL)](https://docs.microsoft.com/en-us/windows/wsl/install).

Once WSL is installed with an Ubuntu 22.04 distro, you can install OSM following the instruccions in (#how-to-install-osm-client-in-ubuntu-2204)

### How to install OSM Client directly in Windows with Conda and Git

OSM can also be installed in Windows with [Miniconda](https://docs.conda.io/en/latest/miniconda.html) and [Git](https://git-scm.com/)

You can install both programs with [Chocolatey](https://chocolatey.org/), the package manager for Windows. Open a CMD window and run the following commands:

```cmd
choco install -y git make wget
choco install -y miniconda3
```

Then, open Windows environment variables > User environment variables, and add the following entries to the `Path` user environment variable in order to make Conda executables reachable from all terminals:

- `C:\tools\miniconda3`
- `C:\tools\miniconda3\Scripts`
- `C:\tools\miniconda3\Library\bin`

Make sure that aliases for Python are disabled in Windows Configuration. Go to Settings > Apps > Apps & features, and click on "Manage app execution aliases". Then disable aliases for Python.

Open Git Bash and run the following commands to create a Conda environment with Python 3.8 and initialize all shells to work with Conda:

```bash
conda create -n osm-env python=3.10
conda init --all
# Logout
```

Then install OSM client as follows:

```bash
# Install conda and install some packages via conda (which will install dependent libraries)
conda activate osm-env

# Upgrade pip to the latest version (with sudo, to install it globally for all users)
python -m pip install -U pip

# Decide which version to use
export OSM_CLIENT_VERSION=v16.0

# Clone IM repo and checkut the desired version
git clone https://osm.etsi.org/gerrit/osm/IM
git -C IM checkout ${OSM_CLIENT_VERSION}

# Install OSM IM using pip
python -m pip install -r IM/requirements.txt
# make -C IM clean
python -m pip install ./IM

# Clone osmclient repo and checkut the desired version
git clone https://osm.etsi.org/gerrit/osm/osmclient
git -C osmclient checkout ${OSM_CLIENT_VERSION}

# Install osmclient using pip
python -m pip install -r osmclient/requirements.txt
# Required DLLs for python-magic
python -m pip install python-magic-bin
python -m pip install ./osmclient

# Try OSM client
python -m osmclient.scripts.osm
# Logout from Git Bash
```

Open Git Bash again and edit `.bash_profile` to activate the Conda environment persistently. If desired, add an alias to osm executable:

```bash
conda activate osm-env
alias 'osm=python -m osmclient.scripts.osm'
```

That will complete OSM client installation for Windows.

## Getting help

Options `-h` or `--help`can be used globally to know the global options and commands, or after a command to know the specific options and args of a command

```bash
$ osm -h
Usage: osm [OPTIONS] COMMAND [ARGS]...

Options:
  --hostname TEXT             hostname of server.  Also can set OSM_HOSTNAME in environment
  --user TEXT                 user (defaults to admin). Also can set OSM_USER in environment
  --password TEXT             password (defaults to admin). Also can set OSM_PASSWORD in environment
  --project TEXT              project (defaults to admin). Also can set OSM_PROJECT in environment
  -v, --verbose               increase verbosity (-v INFO, -vv VERBOSE, -vvv DEBUG)
  --all-projects              include all projects
  --public / --no-public      flag for public items (packages, instances, VIM accounts, etc.)
  --project-domain-name TEXT  project domain name for keystone authentication (default to None). Also can set OSM_PROJECT_DOMAIN_NAME in environment
  --user-domain-name TEXT     user domain name for keystone authentication (default to None). Also can set OSM_USER_DOMAIN_NAME in environment
  -h, --help                  Show this message and exit.

Commands:
  k8scluster-add             adds a K8s cluster to OSM
  ...

$osm vim-create -h
Usage: osm vim-create [OPTIONS]

  creates a new VIM account

Options:
  --name TEXT              Name to create datacenter
  --user TEXT              VIM username
  --password TEXT          VIM password
  --auth_url TEXT          VIM url
  --tenant TEXT            VIM tenant name
  --config TEXT            VIM specific config parameters
  --account_type TEXT      VIM type
  --description TEXT       human readable description
  --sdn_controller TEXT    Name or id of the SDN controller associated to this VIM account
  --sdn_port_mapping TEXT  File describing the port mapping between compute nodes' ports and switch ports
  --wait                   do not return the control immediately, but keep it until the operation is completed, or timeout
  -h, --help               Show this message and exit.

```

The following video illustrates how it works.

<script id="asciicast-336554" src="https://asciinema.org/a/336554.js" async></script>

## Interaction from the OSM client to an OSM in a different location

When using the OSM Client from a host different from OSM's, at a minimum you will need to specify the OSM host, either via an environment variable or via the option `--hostname`. For instance, you can set your client to access an OSM host running at `10.80.80.5` by using:

```bash
export OSM_HOSTNAME="10.80.80.5"
```

The following video shows how it works.

<script id="asciicast-336559" src="https://asciinema.org/a/336559.js" async></script>

## Getting OSM version

You can obtain server and client versions, by using the command `osm version`. Server version corresponds to OSM NBI module.

```bash
$ osm version
Server version: 7.0.1.post23 2020-04-17
Client version: 7.0.1rc1.post52+gbcb7833
```

The following video shows how it works.

<script id="asciicast-336553" src="https://asciinema.org/a/336553.js" async></script>

## RBAC

### Configuring RBAC

OSM supports Role-Based Access Control, so that it's possible to use users and projects, and each user will have a role in a project. OSM provides CRUD operations (`*-create`, `*-list`, `*-show`, `*-update`, `*-delete`) over users, roles and projects

The following video demonstrates how it works.

<script id="asciicast-336563" src="https://asciinema.org/a/336563.js" async></script>

### Using RBAC

When using users and projects, the following environment variables can be used to authenticate against the system:

- `OSM_USER`
- `OSM_PASSWORD`
- `OSM_PROJECT`
- `OSM_PROJECT_DOMAIN_NAME`
- `OSM_USER_DOMAIN_NAME`

Or instead the command line options `--user`, `--password`, `--project`, `--project-domain-name` and `--user-domain-name` can be used:

```bash
  --user TEXT                 user (defaults to admin). Also can set OSM_USER in environment
  --password TEXT             password (defaults to admin). Also can set OSM_PASSWORD in environment
  --project TEXT              project (defaults to admin). Also can set OSM_PROJECT in environment
  --project-domain-name TEXT  project domain name for keystone authentication (default to None). Also can set OSM_PROJECT_DOMAIN_NAME in environment
  --user-domain-name TEXT     user domain name for keystone authentication (default to None). Also can set OSM_USER_DOMAIN_NAME in environment
```

In addition, the option `--all-projects` allow users to perform operations in all the projects they belong to (e.g. `osm --all-projects nfpkg-list` will show all the NF packages in all projects the user belongs to). Finally, the option `--public` allows to create public items, making them available in all projects; visibility from the client of those public items in `*-list` and `*-show` operations requires the use of the option `--public`.

```bash
  --all-projects              include all projects
  --public / --no-public      flag for public items (packages, instances, VIM accounts, etc.)
```

The following video shows a complete demo using different users and projects, and some of these options, illustrating the different project visibility.

<script id="asciicast-336564" src="https://asciinema.org/a/336564.js" async></script>

## OSM repositories

OSM support repositories where NF and NS packages can be retrieved. The following commands can be used to add a repo, list the packages in a repo, show their details or onboard them in OSM:

- `osm repo-add NAME URI`: adds a VNF/NS catalog repo
- `osm nfpkg-repo-list`and `osm nspkg-repo-list`: lists NF/NS packages from OSM repositories
- `osm nfpkg-repo-show|nspkg-repo-show --repo <REPO_NAME>`: shows a specific NF/NS package in a repo
- `osm nfpkg-create|nspkg-create --repo <REPO_NAME> <OSM_PKG>`: onboards a package from a repo into OSM

```bash
osm repo-add --description "OSM VNF and NS repository" vnfrepo https://osm.etsi.org/vnf-catalog/Stable
osm nfpkg-repo-list
osm nfpkg-repo-show --repo vnfrepo fb_magma_knf
osm nfpkg-create --repo vnfrepo fb_magma_knf
osm nspkg-repo-list
osm nspkg-repo-show --repo vnfrepo fb_magma_ns
osm nspkg-create --repo vnfrepo fb_magma_ns
```

The following video demonstrates how these commands work.

<script id="asciicast-336577" src="https://asciinema.org/a/336577.js" async></script>

## Package creation tools

There are several utilities in the OSM client to simplify VNF and NS package creation:

- `osm package-create PACKAGE_TYPE PACKAGE_NAME`: creates an OSM VNF, NS or NST package
- `osm package-validate PKG_FOLDER`: validates descriptors given a base directory
- `osm package-build PKG_FOLDER`: builds the package NS, VNF given the package_folder (descriptor validation, charm build, checksum generation, tar.gz creation)
- `osm nfpkg-create|nspkg-create PKG_FOLDER`: validates the package, builds it and onboards it into OSM

The following video illustrates the previous commands.

<script id="asciicast-HqjI0CNdNJVCg1jKozrAo1Lgx" src="https://asciinema.org/a/HqjI0CNdNJVCg1jKozrAo1Lgx.js" async></script>

## Advanced onboarding

Commands for onboarding NF, NS and NST (`nfpkg-create`, `nspkg-create` and `nst-create`) have the option `--override` to override the fields in the descriptor whem uploading the package to OSM. The format of the option is the following:

```bash
  --override TEXT      overrides fields in descriptor, format: "key1.key2...=value[;key3...=value;...]"
```

In addition, VNF onboarding allows these additional options:

- `--override-epa`: adds guest-epa parameters to all VDU. Useful to onboard packages to be deployed in an EPA-only VIM
- `--override-nonepa`: removes all guest-epa parameters from all VDU. Useful to onboard EPA-based VNF packages to be deployed in a non-EPA VIM
- `--override-paravirt`: overrides all VDU interfaces to PARAVIRT. Useful if packages are going to be deployed in a VIM that does not support SR-IOV or PCI-PASSTHROUGH interfaces.

The following video demonstrates how these options work.

<script id="asciicast-336727" src="https://asciinema.org/a/336727.js" async></script>

## Filtering requests

Some commands have the option `--filter` that allows to filter Read operations (`*-list`, `*-show`) to restric the output to the items matching de filter. Below an example for `osm ns-list`:

```bash
$ osm ns-list -h
Usage: osm ns-list [OPTIONS]

  list all NS instances

  Options:
    --filter filterExpr    Restricts the list to the NS instances matching the filter

  filterExpr consists of one or more strings formatted according to "simpleFilterExpr",
  concatenated using the "&" character:

      filterExpr := <simpleFilterExpr>["&"<simpleFilterExpr>]*
      simpleFilterExpr := <attrName>["."<attrName>]*["."<op>]"="<value>[","<value>]*
      op := "eq" | "neq" | "gt" | "lt" | "gte" | "lte" | "cont" | "ncont"
      attrName := string
      value := scalar value

  where:
    * zero or more occurrences
    ? zero or one occurrence
    [] grouping of expressions to be used with ? and *
    "" quotation marks for marking string constants
    <> name separator

  "AttrName" is the name of one attribute in the data type that defines the representation
  of the resource. The dot (".") character in "simpleFilterExpr" allows concatenation of
  <attrName> entries to filter by attributes deeper in the hierarchy of a structured document.
  "Op" stands for the comparison operator. If the expression has concatenated <attrName>
  entries, it means that the operator "op" is applied to the attribute addressed by the last
  <attrName> entry included in the concatenation. All simple filter expressions are combined
  by the "AND" logical operator. In a concatenation of <attrName> entries in a <simpleFilterExpr>,
  the rightmost "attrName" entry in a "simpleFilterExpr" is called "leaf attribute". The
  concatenation of all "attrName" entries except the leaf attribute is called the "attribute
  prefix". If an attribute referenced in an expression is an array, an object that contains a
  corresponding array shall be considered to match the expression if any of the elements in the
  array matches all expressions that have the same attribute prefix.

  Filter examples:
     --filter  admin-status=ENABLED
     --filter  nsd-ref=<NSD_NAME>
     --filter  nsd.vendor=<VENDOR>
     --filter  nsd.vendor=<VENDOR>&nsd-ref=<NSD_NAME>
     --filter  nsd.constituent-vnfd.vnfd-id-ref=<VNFD_NAME>
```

## Debugging

Option `-v` can be used to debug OSM client. There are different verbosity levels:

- `-v`: log level INFO, shows API calls
- `-vv`: log level VERBOSE, shows API calls and content response
- `-vvv`: log level DEBUG, shows the different methods the client is going through

The following video illustrates the log detail for each verbosity level.

<script id="asciicast-336575" src="https://asciinema.org/a/336575.js" async></script>

## Other useful options

Some commands present useful options:

- `--literal`: shows output in YAML format. It might be deprecated in the future in favour of a new option `-o OUTPUT_FORMAT`.
- `--wait`: makes the command synchronous
- `--long`: shows more info

## Aliases

The following are command aliases with identical behaviour:

- For CRUD operations over NF packages, there are different command aliases. The preferred commands is `nfpkg-*`. The command `vnfd-*`might be deprecated in the future.
  - `nfpkg-create|vnfpkg-create|vnfd-create`: creates a new NFpkg
  - `nfpkg-delete|vnfpkg-delete|vnfd-delete`: deletes a NFpkg
  - `nfpkg-list|vnfpkg-list|vnfd-list`: list all xNF packages (VNF, HNF, PNF)
  - `nfpkg-show|vnfpkg-show|vnfd-show`: shows the details of a NF package
  - `nfpkg-update|vnfpkg-update|vnfd-update`: updates a NFpkg
- For CRUD operations over NS packages, there are different command aliases. The preferred commands is `nspkg-*`. The command `nsd-*`might be deprecated in the future.
  - `nsd-create|nspkg-create`: creates a new NSD/NSpkg
  - `nsd-delete|nspkg-delete`: deletes a NSD/NSpkg
  - `nsd-list|nspkg-list`: list all NS packages
  - `nsd-show|nspkg-show`: shows the details of a NS package
  - `nsd-update|nspkg-update`: updates a NSD/NSpkg
- For CRUD operations over Network Slice Templates, the following command aliases exist:
  - `netslice-template-create|nst-create`: creates a new Network Slice Template (NST)
  - `netslice-template-delete|nst-delete`: deletes a Network Slice Template (NST)
  - `netslice-template-list|nst-list`: list all Network Slice Templates (NST)
  - `netslice-template-show|nst-show`: shows the content of a Network Slice Template (NST)
  - `netslice-template-update|nst-update`: updates a Network Slice Template (NST)
- For CRUD operations over Network Slice Instances, the following command aliases exist:
  - `netslice-instance-create|nsi-create`: creates a new Network Slice Instance
  - `netslice-instance-delete|nsi-delete`: deletes a Network Slice Instance (NSI)
  - `netslice-instance-list|nsi-list`: list all Network Slice Instances (NSI)
  - `netslice-instance-op-list|nsi-op-list`: shows the history of operations over a Network Slice Instance (NSI)
  - `netslice-instance-op-show|nsi-op-show`: shows the info of an operation over a Network Slice Instance(NSI)
  - `netslice-instance-show|nsi-show`: shows the content of a Network Slice Instance (NSI)
- For Read operations over OSM repositories, the following command aliases exist:
  - `nfpkg-repo-list|vnfpkg-repo-list`: list all xNF from OSM repositories
  - `nfpkg-repo-show|vnfpkg-repo-show`: shows the details of a NF package in an OSM repository
  - `nsd-repo-list|nspkg-list`: list all NS from OSM repositories
  - `nsd-repo-show|nspkg-show`: shows the details of a NS package in an OSM repository

## Enable autocompletion

You can enable autocompletion in OSM client by creating a file osm-complete.sh in the following way:

```bash
mkdir -p $HOME/.bash_completion.d
_OSM_COMPLETE=bash_source osm > $HOME/.bash_completion.d/osm-complete.sh
```

Then you can add the following to your $HOME/.bashrc file:

```bash
. .bash_completion.d/osm-complete.sh
```

## Using osmclient as a library to interact with OSM

Assuming that you have installed python-osmclient package, it's pretty simple to write some Python code to interact with OSM.

### Simple Python code to get the list of NS packages

```python
from osmclient import client
from osmclient.common.exceptions import ClientException
hostname = "127.0.0.1"
myclient = client.Client(host=hostname)
resp = myclient.nsd.list()
print yaml.safe_dump(resp)
```

### Simple Python code to get the list of VNF packages from a specific user and project

The code will print for each package a pretty table, then the full details in yaml

```python
from osmclient import client
from osmclient.common.exceptions import ClientException
import yaml
from prettytable import PrettyTable
hostname = "127.0.0.1"
user = admin
password = admin
project = admin
kwargs = {}
if user is not None:
    kwargs['user']=user
if password is not None:
    kwargs['password']=password
if project is not None:
   kwargs['project']=project
myclient = client.Client(host=hostname, sol005=True, **kwargs)
resp = myclient.vnfd.list()
print yaml.safe_dump(resp)
```
