# OSM Architecture and Functions

[OSM-IM-PAGE]: 12-osm-im.md
[OSM-NBI-PAGE]: 13-osm-nbi.md

The goal of ETSI OSM (Open Source MANO) is the development of a community-driven production-quality **E2E Network Service Orchestrator (E2E NSO)** for telco services, capable of modelling and automating real telco-grade services, with all the intrinsic complexity of production environments. OSM provides a way to accelerate maturation of NFV technologies and standards, enable a broad ecosystem of VNF vendors, and test and validate the joint interaction of the orchestrator with the other components it has to interact with: commercial NFV infrastructures (NFVI+VIM) and Network Functions (either VNFs, PNFs or Hybrid ones).

OSM's approach aims to minimize integration efforts thanks to four key aspects:

1. **A well-known [Information Model (IM)][OSM-IM-PAGE]**, aligned with ETSI NFV SOL006, that is capable of modelling and automating the full lifecycle of Network Functions (virtual, physical or hybrid), Network Services (NS), and Network Slices (NST/NSI), from their initial deployment (instantiation, Day-0, and Day-1) to their daily operation and monitoring (Day-2). OSM IM augments ETSI NFV SOL006 by adding the support of Network Slices, day-1 and day-2 primitives at VNF and NS level, and Enhanced Platform Awareness for dataplane workloads.

   - Actually, OSM's IM is completely infrastructure-agnostic, so that the same model can be used to instantiate a given element (e.g. VNF) in a large variety of VIM types and transport technologies, enabling an ecosystem of VNF models ready for their deployment everywhere.

2. OSM provides a **unified [northbound interface (NBI)][OSM-NBI-PAGE]**, based on NFV SOL005, which enables the full operation of system and the Network Services and Network Slices under its control. In fact, OSM's NBI offers the service of managing the lifecycle of Network Services (NS) and Network Slices Instances (NSI), providing as a service all the necessary abstractions to allow the complete control, operation and supervision of the NS/NSI lifecycle by client systems, avoiding the exposure of unnecessary details of its constituent elements.

3. The **extended concept of "Network Service" in OSM**, so that an NS can span across the different domains identified —virtual, physical and transport—, and therefore control the full lifecycle of an NS interacting with VNFs, PNFs and HNFs in an undistinguishable manner along with on demand transport connections among different sites.

4. In addition, **OSM can also manage the lifecycle of Network Slices**, assuming when required the role of Slice Manager, extending it also to support an integrated operation.

## Service Platform view

OSM provides the capability of realising one of the main promises derived from NFV and the dynamic capabilities that it brings: creating networks on demand (“Network as a Service” or NaaS) for either their direct exploitation by the service provider or for their potential commercialization to third parties.

In that sense, OSM works as a **Network Service Orchestrator** intended to provide the capability of creating network services on demand and returning a _service object_ ID that can be used later as a handler to control the whole lifecycle and operations of the network service via subsequent calls to OSM's northbound API and monitor its global state in a convenient fashion.

In the case of OSM, there are two types of _NaaS service objects_ that OSM is able to provide on demand to support the NaaS capability: the **Network Service (NS)** and the **Network Slice Instance (NSI)**, being the latter a composition of several Network Services that can be treated as a single entity (particularities of both types of _NaaS service objects_ will be described in the next sections).

OSM, as _manager function_ of a _service platform_, consumes services from other _service platforms_ and controls a number of _managed functions_ in order to create its own composite higher-level _service objects_. Thus, OSM consumes services provided by the platform(s) in charge of the Virtual Infrastructure (to obtain VMs, etc.) and the platform(s) in charge of the SW-Defined Network (to obtain all the required kinds of inter-DC connections), and, once assembled, configures and monitors the constituent network functions (VNFs, PNFs, HNFs) in order to control the LCM of the entire NS/NSI to be offered on demand.

To learn more about OSM scope, functionality and operation, your can refer to [this white paper](https://osm-download.etsi.org/ftp/Documentation/201902-osm-scope-white-paper), which describes those subjects in detail.
