# OSM Quickstart

Open Source MANO (OSM) is an ETSI-hosted open source community delivering a production-quality MANO stack for NFV, capable of consuming openly published information models, available to everyone, suitable for all VNFs, operationally significant and VIM-independent. OSM is aligned to NFV ISG information models while providing first-hand feedback based on its implementation experience.

OSM follows a regular cadence of two releases per year, alternating between Long Term Support (LTS) releases such as Release SIXTEEN or Release FOURTEEN (2 years support) and Standard releases (6 months support).

This release, **Release SIXTEEN**, brings a revolution in OSM’s functionality, positioning OSM as a generalized cloud-native orchestrator for infrastructure, platforms and services, which extends significantly its former scope. Full cloud-native management of Kubernetes clusters in public clouds, together with the applications or software units running on them, is now possible with Release SIXTEEN. Every operation related to the cluster management (creation, upgrading, scaling, deletion) or the applications running on them is reflected in Git repositories, following the GitOps model. This has been possible thanks to a major change in the internal architecture of OSM.

OSM Release SIXTEEN includes significant improvements in the following key areas:

- __Cloud-native operations in OSM__. Release SIXTEEN incorporates the provision of a management cluster for remote cloud-native management of infrastructure and applications. In addition, ad-hoc Git repositories are automatically created during OSM installation to support Continuous Deployment operations. Release SIXTEEN has added the logic to define and execute workflows in a declarative way for all the new operations. These workflows are responsible for committing the appropriate intents into the Git repositories, and the OSM management cluster is in charge of synchronizing this state into different target clouds, thanks to new capabilities added to VIM/Cloud account registration.
- __Management of Kubernetes clusters__. This release includes the full life-cycle management of Kubernetes clusters from OSM. Azure, AWS and GCP PaaS-based clusters can be created, upgraded, scaled and deleted from OSM. In addition, applications can be deployed and fully managed (upgraded, deleted) in those clusters. Finally, Rel SIXTEEN incorporates the concept of “profiles” as a way of grouping sets of software units to be deployed to a distributed fleet of Kubernetes clusters, such as Edge scenarios.
- __Enhanced operational capabilities__. Release SIXTEEN incorporates a whole new set of operational capabilities for Network Services (NS), including the following: NS config templates as first-class citizens in OSM, support for deletion of multiple NS instances, new options to reset or reuse values when upgrading CNFs, the addition of labels to Kubernetes objects created by OSM, and improved integration of the vertical scaling and KPI-based scaling of VNFs introduced in previous releases.
- __Security enhancements__. Release SIXTEEN incorporates important enhancements such as the password recovery based on One-Time Password (OTP) and improved audit logs for password-related and NS life-cycle operations.
- __OSM installation__. This release introduces relevant changes in the Kubernetes cluster where OSM is installed, such as the support of K3s as default Kubernetes distro for OSM installation, and the inclusion of an ingress controller to expose more conveniently all web services in OSM, including the Graphical User Interface and the North-Bound Interface. In addition, the OSM helm chart introduced in previous releases continues evolving in Release SIXTEEN to include upstream helm charts for Prometheus and Grafana. By using upstream helm charts, those components become much easier to maintain and upgrade, while benefiting from upstream built-in features such as replication and persistent storage. In addition, OSM helm chart has been adapted to be able to work with pre-existing Mongo DB deployments, instead of using the default one coming with OSM, which enables alternative deployments in production. Finally, other dependencies such as Zookeeper have been removed, making use of the built-in replication mechanism in Kafka.

![Release SIXTEEN - Feature summary](assets/rel16-features.png)

For a comprehensive overview of OSM functionalities, you can also refer to the [OSM White Papers and Release Notes of previous releases](https://osm.etsi.org/wikipub/index.php/Release_notes_and_whitepapers).

<!--
For the full list of new features, please refer to the [Release Notes](https://osm-download.etsi.org/ftp/osm-15.0-fifteen/OSM_Release_SIXTEEN_Release_Notes.pdf).
-->

**OSM in Practice**:

<iframe src="https://www.youtube.com/embed/kCFxPV67Adw?" width="640" height="360" frameborder="0" allowfullscreen="true" style="box-sizing: border-box;"></iframe>

## Assumptions about interaction with VIMs and VNFs

The following figure illustrates OSM interaction with VIMs and VNFs:

- OSM talks to the VIM for the deployment of VNFs and VLs connecting them
- OSM talks to the VNFs deployed in a VIM to run day-0, day-1 and day-2 configuration primitives.

![OSM](assets/600px-Osmtopology.png)

In order for OSM to work, it is assumed that:

- Each VIM has an API endpoint reachable from OSM
- Each VIM has a so called management network which provides IP address to VNFs
- That management network is reachable from OSM

## Installing OSM

### Default installation procedure

All you need to run OSM is a single server or VM with the following requirements:

- RECOMMENDED: 4 CPUs, 16 GB RAM, 80GB disk and a single interface with Internet access
- Base image: Ubuntu22.04
  - [Ubuntu22.04 cloud image (64-bit variant required)](https://cloud-images.ubuntu.com/jammy/current/jammy-server-cloudimg-amd64-disk-kvm.img)
  - [Ubuntu22.04 server image (64-bit variant required)](http://releases.ubuntu.com/22.04/)

Once you have prepared the host with the previous requirements, all you need to do is:

```bash
wget https://osm-download.etsi.org/ftp/osm-16.0-sixteen/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh
```

This will install a standalone Kubernetes on a single host, and OSM on top of it.

**TIP:** In order to facilitate potential trobleshooting later, it is recommended to save the full log of your installation process:

```bash
wget https://osm-download.etsi.org/ftp/osm-16.0-sixteen/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh 2>&1 | tee osm_install_log.txt
```

You will be asked if you want to proceed with the installation and configuration of LXD, juju, docker CE and the initialization of a local docker swarm, as pre-requirements. Please answer "y".

For other special installation options, please refer to the [specific chapter on installation options](03-installing-osm.md).

### Checking your installation

After some time, you will get a fresh OSM installation with its latest, pre-built docker images which are built daily. You can access to the UI in the following URL (user:`admin`, password: `admin`): [http://<YOUR_IP>.nip.io](http://<YOUR_IP>.nip.io/), replacing <YOUR_IP> by the IP address of your host.

You can check the ingress endpoint of the UI with the following command:

```bash
export OSM_GUI_URL=$(kubectl get -n osm -o jsonpath="{.spec.rules[0].host}" ingress ngui-ingress)
echo "OSM UI: $OSM_GUI_URL"
```

![OSM home](assets/600px-Osm_ng_ui_login.png)

![OSM installation result](assets/600px-Osm_ng_ui.png)

As a result of the installation, different K8s objects (deployments, statefulsets, etc.) created in the host. You can check the status by running the following commands:

```bash
kubectl get all -n osm
kubectl get ingress -n osm
```

To check the logs of any container:

```bash
kubectl logs -n osm deployments/lcm           # for LCM
kubectl logs -n osm deployments/ng-ui         # for NG-UI
kubectl logs -n osm deployments/mon           # for MON
kubectl logs -n osm deployments/nbi           # for NBI
kubectl logs -n osm deployments/pol           # for POL
kubectl logs -n osm deployments/ro            # for RO
kubectl logs -n osm deployments/keystone      # for Keystone
kubectl logs -n osm deployments/grafana       # for Grafana
kubectl logs -n osm statefulset/kafka         # for Kafka
kubectl logs -n osm statefulset/mongodb-k8s   # for MongoDB
kubectl logs -n osm statefulset/mysql         # for Mysql
kubectl logs -n osm statefulset/prometheus    # for Prometheus
kubectl logs -n osm statefulset/zookeeper     # for Zookeeper
```

Finally, if you used the option `--k8s_monitor` to install an add-on to monitor the K8s cluster and OSM, you can check the status in this way.

```bash
kubectl get all -n monitoring
```

OSM client, a python-based CLI for OSM, will be available as well in the host machine. Via the OSM client, you can manage descriptors, NS and VIM complete lifecycle. Make sure that the environment variable `OSM_HOSTNAME` is properly set pointing to the ingress endpoint of OSM NBI.


```bash
export OSM_HOSTNAME=$(kubectl get -n osm -o jsonpath="{.spec.rules[0].host}" ingress nbi-ingress)
echo "OSM_HOSTNAME (for osm client): $OSM_HOSTNAME"
osm --help
```

## Adding VIM accounts

Before proceeding, make sure that you have a site with a VIM configured to run with OSM. Different kinds of VIMs are currently supported by OSM:

- **OpenStack.** Check the following link to learn how to configure OpenStack to be used by OSM: [Openstack configuration](04-vim-setup.md#openstack)
- **Microsoft Azure** Check the following link to learn how to configure Microsoft Azure to be used by OSM: [Configuring Microsoft Azure for OSM](04-vim-setup.md#microsoft-azure)
- **Google Cloud Platform (GCP)** Check the following link to learn how to configure Google Cloud Platform to be used by OSM: [Configuring Google Cloud Platform for OSM](04-vim-setup.md#google-cloud-platform)
- **Amazon Web Services (AWS).** Check the following link to learn how to configure AWS (EC2 and Virtual Private Cloud) to be used by OSM: [Configuring AWS for OSM](04-vim-setup.md#amazon-web-services-aws)
- **VMware vCloud Director.** Check the following link to learn how to configure VMware VCD to be used by OSM: [Configuring VMware vCloud Director](04-vim-setup.md#vmwares-vcloud-director)
- **OpenVIM.** Check the following link to know how to install and use openvim for OSM: [OpenVIM installation](14-openvim-installation.md). OpenVIM must run in 'normal' mode (not test or fake) to have real virtual machines reachable from OSM.

OSM can manage external SDN controllers to perform the dataplane underlay network connectivity on behalf of the VIM. See [EPA and SDN assist](04-vim-setup.md#advanced-setups-for-high-io-performance-epa-and-sdn-assist)

### Adding VIMs through OSM client

#### Openstack site

Execute the following command, using the appropriate parameters (e.g. site name: "openstack-site", IP address: 10.10.10.11, VIM tenant: "admin", user: "admin", password: "userpwd")

```bash
osm vim-create --name openstack-site --user admin --password userpwd \
    --auth_url http://10.10.10.11:5000/v2.0 --tenant admin --account_type openstack
```

For advanced options, please refer to the [OpenStack Setup Guide](04-vim-setup.md#openstack).

#### VMware Integrated Openstack (VIO) site

Execute the following command, using the appropriate parameters (e.g. site name: "openstack-site-vio4", IP address: 10.10.10.12, VIM tenant: `admin`, user: `admin`, password: `passwd`)

```bash
osm vim-create --name VIO --user admin --password passwd --auth_url https://10.10.10.12:5000/v3 --tenant admin \
    --account_type openstack --config '{use_floating_ip: True, insecure: true, vim_type: VIO, APIversion: v3.3,
    dataplane_physical_net: dvs-46, "use_internal_endpoint":true,"dataplane_net_vlan_range":["31-35","37-39"]}'
```

With respect to Openstack, the additional configuration for VIO is the following:

- **vim_type**: Set to "VIO" to use VMware Integrated openstack as VIM
- **use_internal_endpoint**: When true it allows use of private API endpoints
- **dataplane_physical_net**: The configured network_vlan_ranges at neutron for the SRIOV (binding direct) and passthrough (binding direct-physical) networks, e.g. 'physnet_sriov' in the above configuration. In case of VMware Integrated Openstack (VIO) provide moref ID of distributed virtual switch, e.g 'dvs-46' in above configuration.
- **dataplane_net_vlan_range**: In case of VMware Integrated Openstack (VIO) provide vlan ranges for the SRIOV (binding direct) networks in format ['start_ID - end_ID']

For common options, you may refer to the general [OpenStack Setup Guide](04-vim-setup.md#openstack).

#### Amazon Web Services (AWS) site

- Execute the following command, using the appropriate parameters (e.g. site name: "aws-site", VIM tenant: "admin", user: "XXX", password: "YYY")

```bash
osm vim-create --name aws-site --user XXX --password YYY --auth_url https://aws.amazon.com --tenant admin \
    --account_type aws --config '{region_name: eu-central-1, flavor_info: {t2.nano: {cpus: 1, disk: 100, ram: 512},
    t2.micro: {cpus: 1, disk: 100, ram: 1024}, t2.small: {cpus: 1, disk: 100, ram: 2048},
    m1.small: {cpus: 1, disk: 160, ram: 1741}}}'
```

For advanced options, please refer to the [Configuring AWS for OSM](04-vim-setup.md#amazon-web-services-aws).

#### Microsoft Azure

- Execute the following command, using the appropiate parameters (e.g `azure_client_id`: 'XXX', `azure_secret`: 'YYY', `azure_tenant`: 'tenantid', `azure_subscription_id`: 'ZZZ', regular expression of the flavors that will be used: `flavors_pattern`:'^Basic')

```bash
osm vim-create --name azure --account_type azure --auth_url http://www.azure.com --tenant "tenantid"
    --user "XXX" --password "azurepwd" --description "AZURE site"
    --config "{region_name: westeurope, resource_group: 'osmRG', subscription_id: 'azuresubs',
     vnet_name: 'osm_vnet', flavors_pattern: 'flavors_regex'}"
```

For advanced options, please refer to the [Microsoft Azure setup guide](04-vim-setup.md#microsoft-azure).

#### OpenVIM site

Execute the following command, using the appropriate parameters (e.g. site name: "openvim-site", IP address: 10.10.10.10, VIM tenant: "osm")

```bash
osm vim-create --name openvim-site --auth_url http://10.10.10.10:9080/openvim --account_type openvim \
   --description "Openvim site" --tenant osm --user dummy --password dummy
```


#### VMware vCloud Director site

- Execute the following command, using the appropriate parameters (e.g. site name: "vmware-site", IP address: 10.10.10.12, VIM tenant: "vmware-tenant", user: "osm", password: "osm4u", admin user: "admin", admin password: "adminpwd", organization: "orgVDC")

```bash
osm vim-create --name vmware-site --user osm --password osm4u --auth_url https://10.10.10.12 \
    --tenant vmware-tenant  --account_type vmware \
    --config '{admin_username: user, admin_password: passwd, orgname: organization, nsx_manager: "http://10.10.10.12",
    nsx_user: user, nsx_password: userpwd,"vcenter_port": port, "vcenter_user":user, "vcenter_password":password,
    "vcenter_ip": 10.10.10.14}'
```

For advanced options, please refer to the [Configuring VMware vCloud Director](04-vim-setup.md#vmwares-vcloud-director).

### Adding VIMs through GUI

Just access the *VIM Accounts* tab, click the *New VIM* button and fill the parameters accordingly.

![AddingVIMUI](assets/600px-Osmvim_r9.png)

## Deploying your first Network Service

Before going on, get the required NF and NS packages from [Gitlab osm-packages repository](https://osm.etsi.org/gitlab/vnf-onboarding/osm-packages).

### Onboarding a VNF

The onboarding of a VNF in OSM involves preparing and adding the corresponding VNF package to the system. This process also assumes, as a pre-condition, that the corresponding VM images are available in the VIM(s) where it will be instantiated.

#### Uploading VM image(s) to the VIM(s)

In this example, only a vanilla Ubuntu20.04 image is needed. It can be obtained from the following link: <https://cloud-images.ubuntu.com/focal/current/focal-server-cloudimg-amd64.img>

It will be required to upload the image into the VIM. Instructions differ from one VIM to another (please check the reference of your type of VIM).

For instance, this is the OpenStack command for uploading images:

```bash
openstack image create --file="./focal-server-cloudimg-amd64.img" --container-format=bare --disk-format=qcow2 ubuntu20.04
```

#### Onboarding a VNF Package

- From the UI:
  - Go to 'VNF Packages' on the 'Packages' menu to the left
  - Drag and drop the VNF package file `hackfest_basic_vnf.tar.gz` in the importing area.

![Onboarding a VNF](assets/600px-Vnfd_onboard_r9.png)

- From OSM client:

```bash
osm nfpkg-create hackfest_basic_vnf.tar.gz
osm nfpkg-list
```

### Onboarding a NS Package

- From the UI:
  - Go to 'NS Packages' on the 'Packages' menu to the left
  - Drag and drop the NS package file `hackfest_basic_ns.tar.gz` in the importing area.

![Onboarding a NS](assets/600px-Nsd_onboard_r9.png)

- From OSM client:

```bash
osm nspkg-create hackfest_basic_ns.tar.gz
osm nspkg-list
```

### Instantiating the NS

#### Instantiating a NS from the UI

- Go to 'NS Packages' on the 'Packages' menu to the left
- Next the NS descriptor to be instantiated, click on the 'Instantiate NS' button.

![Instantiating a NS (assets/600px-Nsd_list_r9.png)](assets/600px-Nsd_list_r9.png)

- Fill in the form, adding at least a name, description and selecting the VIM:

![Instantiating a NS (assets/600px-New_ns_r9.png)](assets/600px-New_ns_r9.png)

**Instantiation parameters can be specified using both CLI and UI. You can find a thorough explanation with examples in this page: [OSM instantiation parameters](05-osm-usage.md#advanced-instantiation-using-instantiation-parameters).**

#### Instantiating a NS from the OSM client

```bash
osm ns-create --ns_name <ns-instance-name> --nsd_name hackfest_basic-ns --vim_account <vim-target-name>
osm ns-list
```

## What's next?

If you want to learn more, you can refer to the rest of **[OSM documentation](index.md)**.
