# ANNEX 4: NBI API Description

![link=https%3A%2F%2Fosm.etsi.org%2Fgitweb%2F%3Fp%3Dosm%2FSOL005.git%3Ba%3Dblob_plain%3Bf%3Dosm-openapi.yaml%3Bhb%3DHEAD](assets/750px-NBI.png)

**[Open OSM NBI in Swagger-UI](https://forge.etsi.org/swagger/ui/?url=https%3A%2F%2Fosm.etsi.org%2Fgitweb%2F%3Fp%3Dosm%2FSOL005.git%3Ba%3Dblob_plain%3Bf%3Dosm-openapi.yaml%3Bhb%3DHEAD)**

## Introduction

OSM North Bound Interface is RESTful, following ETSI SOL005 standard. It admits both YAML/JSON formats.

By default, it serves https (auto-signed certificate) on port 9999. Bearer authentication (with token) is used. Basic authentication or no authentication is also possible changing `nbi.cfg` file.

For development purposes it admits web browser navigation using a basic http format.

## Request headers

`Accept: 'application/json','application/yaml'` in most of the cases. Use 'text/html' for web navigation. Use `'text/plain','application/zip'` for descriptor artifacts showing. This header field shall be present if the response is expected to have a non-empty message body.

`Content-Type: 'application/json','application/yaml'` for most of the cases. For packages uploading use `'application/gzip','application/zip','application/x-gzip','application/binary'`. For descriptor artifacts it can be used `'text/plain'`. This header field shall be present if the request has a non-empty message body.

`Authorization: 'Bearer <token_id>'`. The authorization token for the request. It is mandatory except when a token is requested.

`Content-Range: '<first byte>-<last byte>0/<total>'`. It allows uploading a descriptor by chunks.

`Transaction-Id: '<id>'`. When uploaded by chunk, the id returned by first chunk

`Content-File-MD5: '<md5>'`. MD5 of uploaded package.

`Content-Filename: '<filename>'`. Filename of the uploaded package.

`Query-String-Format: '<yaml>'`. Parses query string values using yaml format.

## Response headers

`Content-Type: 'application/json','application/yaml'` is the more normal. `'text/html'` when web navigation. `'application/gzip','text/plain'` for descriptor artifacts

`Location: '/<main_topic>/v1/<topic>/<id>'`. Always that something is created, this header is present containing URL to this element.

`WWW-Authenticate: 'Bearer realm="{}"'`. When Authentication error is obtained.

`**Retry-After**: ''`. (Future releases)

## RBAC

From Release SIX, operations are authorized via RBAC (Role Base Access Control). Each user and project is assigned with a set of roles, and some of them must grant the intended operation. If administrative query string is used (see next section), role must grant the use of it in addition to the operation.

Role permissions are organized in a hierarchical tree, separated by colon, optionally ending with the http operation. The value of False means not granted, meanwhile with True it is granted. If this permission is missing, the immediate hierarchical permission applies. When there is not hierarchical at all, the defined "default" permission applies, and if "default" is missing, not granted is assumed. See these examples [initial roles](https://osm.etsi.org/gitweb/?p=osm/NBI.git;a=blob;f=osm_nbi/roles_to_operations.yml); and [role permissions](https://osm.etsi.org/gitweb/?p=osm/NBI.git;a=blob;f=osm_nbi/resources_to_operations.yml) for the list of RBAC permission with their operation. In following sections the RBAC permission granting this operation is indicated in brackets.

## Query String

Query string has the format: `'?key=value&key2=value2&...'`.

For GET method it allows filtering with this format, follows SOL005 section 4.3.2:

```text
query string := ?<simpleFilterExpr>["&"<simpleFilterExpr>]*
simpleFilterExpr := <attrName>["."<attrName>]*["."<op>]"="<value>[","<value>]*
op := "eq" | "neq" (or "ne") | "gt" | "lt" | "gte" | "lte" | "cont" | "ncont"
   equal (by default), not equal, greater than, less than, greater than or equal, less than or equal, contains, not contains
attrName := string. For filtering inside array, use the index element of the array, or add ANYINDEX to apply the filtering over the same array element
```

For PUT/POST/PATCH It allows override e.g. package content, with the values of this query string

### Administrative Query String

Some special keys used for administration are:

- `FORCE(=True)` (rbac: `force`). Forces and operation. It disables descriptor checking, dependency checking. For delete, it allows deleting things that cannot done in normal operation because dependency. But beware that forcing deletion will not deletes created things at VIM level.

- `PUBLIC(=True)` (rbac: `public`). Allows getting public descriptor or instances (apart from those belonging to the project used login). For write/update operations, it used for set or unset a descriptor as public

- `ADMIN` (rbac: `admin`). Allows making operations on behalf of different project(s) than the one used for login (`=projectA,projectB,...`). Also to show all descriptor or instances (just `ADMIN`). For update operations..

- `SET_PROJECT=ProjectA,ProjectB,...` (rbac: `set_project`). Allows adding an existing descriptor or instance to a project portfolio with an update operation.

## URL and Methods summary

North Bound Interface (O: OSM specific; X,5: SOL005 not OSM implemented yet; O5: OSM and SOL005)

```text
URL: /osm                                                       GET     POST    PUT     DELETE  PATCH
        /nsd/v1
            /ns_descriptors_content                             O       O
                /<nsdInfoId>                                    O       O       O       O
            /ns_descriptors                                     O5      O5
                /<nsdInfoId>                                    O5                      O5      5
                    /nsd_content                                O5              O5
                    /nsd                                        O
                    /artifacts[/<artifactPath>]                 O
            /pnf_descriptors                                    5       5
                /<pnfdInfoId>                                   5                       5       5
                    /pnfd_content                               5               5
            /subscriptions                                      5       5
                /<subscriptionId>                               5                       X

        /vnfpkgm/v1
            /vnf_packages_content                               O       O
                /<vnfPkgId>                                     O                       O
            /vnf_packages                                       O5      O5
                /<vnfPkgId>                                     O5                      O5      5
                    /package_content                            O5               O5
                        /upload_from_uri                                X
                    /vnfd                                       O5
                    /artifacts[/<artifactPath>]                 O5
            /subscriptions                                      X       X
                /<subscriptionId>                               X                       X

        /nslcm/v1
            /ns_instances_content                               O       O
                /<nsInstanceId>                                 O                       O
            /ns_instances                                       5       5
                /<nsInstanceId>                                 O5                      O5
                    instantiate                                         O5
                    terminate                                           O5
                    action                                              O
                    scale                                               O5
                    heal                                                5
            /ns_lcm_op_occs                                     5       5
                /<nsLcmOpOccId>                                 5                       5       5
                    TO BE COMPLETED                             5               5
            /vnf_instances  (also vnfrs for compatibility)      O
                /<vnfInstanceId>                                O
            /subscriptions                                      5       5
                /<subscriptionId>                               5                       X

        /pdu/v1
            /pdu_descriptors                                    O       O
                /<id>                                           O               O       O       O

        /admin/v1
            /tokens                                             O       O
                /<id>                                           O                       O
            /users                                              O       O
                /<id>                                           O               O       O       O
            /projects                                           O       O
                /<id>                                           O                       O
            /vim_accounts  (also vims for compatibility)        O       O
                /<id>                                           O                       O       O
            /wim_accounts                                       O       O
                /<id>                                           O                       O       O
            /sdns                                               O       O
                /<id>                                           O                       O       O
            /k8sclusters                                        O       O
                /<id>                                           O                       O       O
            /k8srepos                                           O       O
                /<id>                                           O                               O

        /nst/v1                                                 O       O
            /netslice_templates_content                         O       O
                /<nstInfoId>                                    O       O       O       O
            /netslice_templates                                 O       O
                /<nstInfoId>                                    O                       O       O
                    /nst_content                                O               O
                    /nst                                        O
                    /artifacts[/<artifactPath>]                 O
            /subscriptions                                      X       X
                /<subscriptionId>                               X                       X

        /nsilcm/v1
            /netslice_instances_content                         O       O
                /<SliceInstanceId>                              O                       O
            /netslice_instances                                 O       O
                /<SliceInstanceId>                              O                       O
                    instantiate                                         O
                    terminate                                           O
                    action                                              O
            /nsi_lcm_op_occs                                    O       O
                /<nsiLcmOpOccId>                                O                       O       O
            /subscriptions                                      X       X
                /<subscriptionId>                               X                       X

query string:
    Follows SOL005 section 4.3.2 It contains extra METHOD to override http method, FORCE to force.
        simpleFilterExpr := <attrName>["."<attrName>]*["."<op>]"="<value>[","<value>]*
        filterExpr := <simpleFilterExpr>["&"<simpleFilterExpr>]*
        op := "eq" | "neq" (or "ne") | "gt" | "lt" | "gte" | "lte" | "cont" | "ncont"
        attrName := string
    For filtering inside array, it must select the element of the array, or add ANYINDEX to apply the filtering over any
    item of the array, that is, pass if any item of the array pass the filter.
    It allows both ne and neq for not equal
    TODO: 4.3.3 Attribute selectors
        all_fields, fields=x,y,.., exclude_default, exclude_fields=x,y,...
        (none)... same as “exclude_default”
        all_fields... all attributes.
        fields=<list>... all attributes except all complex attributes with minimum cardinality of zero that are not
        conditionally mandatory, and that are not provided in <list>.
        exclude_fields=<list>... all attributes except those complex attributes with a minimum cardinality of zero that
        are not conditionally mandatory, and that are provided in <list>.
        exclude_default... all attributes except those complex attributes with a minimum cardinality of zero that are not
        conditionally mandatory, and that are part of the "default exclude set" defined in the present specification for
        the particular resource
        exclude_default and include=<list>... all attributes except those complex attributes with a minimum cardinality
        of zero that are not conditionally mandatory and that are part of the "default exclude set" defined in the
        present specification for the particular resource, but that are not part of <list>
    Additionally it admits some administrator values:
        FORCE: To force operations skipping dependency checkings
        ADMIN: To act as an administrator or a different project
        PUBLIC: To get public descriptors or set a descriptor as public
        SET_PROJECT: To make a descriptor available for other project

Header field name Reference Example Descriptions
    Accept IETF RFC 7231 [19] application/json Content-Types that are acceptable for the response.
    This header field shall be present if the response is expected to have a non-empty message body.
    Content-Type IETF RFC 7231 [19] application/json The MIME type of the body of the request.
    This header field shall be present if the request has a non-empty message body.
    Authorization IETF RFC 7235 [22] Bearer mF_9.B5f-4.1JqM  The authorization token for the request.
    Details are specified in clause 4.5.3.
    Range IETF RFC 7233 [21] 1000-2000 Requested range of bytes from a file
Header field name Reference Example Descriptions
    Content-Type IETF RFC 7231 [19] application/json The MIME type of the body of the response.
    This header field shall be present if the response has a non-empty message body.
    Location IETF RFC 7231 [19] http://www.example.com/vnflcm/v1/vnf_instances/123 Used in redirection, or when a
    new resource has been created.
    This header field shall be present if the response status code is 201 or 3xx.
    In the present document this header field is also used if the response status code is 202 and a new resource was
    created.
    WWW-Authenticate IETF RFC 7235 [22] Bearer realm="example" Challenge if the corresponding HTTP request has not
    provided authorization, or error details if the corresponding HTTP request has provided an invalid authorization
    token.
    Accept-Ranges IETF RFC 7233 [21] bytes Used by the Server to signal whether or not it supports ranges for
    certain resources.
    Content-Range IETF RFC 7233 [21] bytes 21010-47021/ 47022 Signals the byte range that is contained in the
    response, and the total length of the file.
    Retry-After IETF RFC 7231 [19] Fri, 31 Dec 1999 23:59:59 GMT```
```

## Administrative Content Details

`/admin/v1/tokens`. Token is a temporal authorization for a user in a concrete project. Each request must contain it in the http header Authorization

- GET: List the valid granted tokens obtained by this user
- POST: Obtain a token. The 'username' and 'password' is mandatory only if http header does not contain Authorization. 'project' can be provided, if not, first project of available for this user is assigned. For changing project, a new token must be obtained.
  - Example of request content: `'{username: <user>, password: <pass>, project_id: <project>}'`

`/admin/v1/tokens/`

- GET: show token details
- DELETE: revoque token. Logout

`/admin/v1/users`. (rbac: `users`). Users may operate in several projects

- GET: Get users
- POST: Add a new user.
  - Example of request content: `'{username: <user>, password: <pass>, projects: [P1, P2, ...]}'`

`/admin/v1/users/`. (rbac: `users:id`).

- GET: Get user details
- PUT/PATCH: Edit user.
  - Example of user edition:
    - Change password: `'{password: <new_pass>}'`
    - Change the list of available projects to a new one: `'{projects: [P1, P2, ...]}'`
    - Remove a project 'P' from user if exist: `{projects: {"$'P'": null}}'`
    - Add a project 'P' to user if not already exist: `'{projects: {"$+'P'": "P"}}'`
    - Set 'P' to be project by default, (adding it if not exist): `'{projects: {"$'P'": null, "$+[0]": "P"}}'`
- DELETE: Removes user.

`/admin/v1/projects`. (rbac: `projects`). A project contains its own separate space

- GET: Get projects
- POST: Add a new project.
  - Example of request content: `'{name: <P-name>, admin: <True/False>}'`

`/admin/v1/projects/`. (rbac: `projects:id`)

- GET: Get project details
- PUT/PATCH: Edit project.
  - Example of project edition to change admin status: `'{admin: <True/False>}'`
- DELETE: Removes project.

`/admin/v1/vim_accounts`. (rbac: `vims`). Vim account is the deployment target

- GET: Get vim_accounts
- POST: Add a new vim_accounts.
  - Example of request content: TODO

`/admin/v1/vim_accounts/`. (rbac: `vims:id`)

- GET: Get vim_account details
- PUT/PATCH: Edit vim_account.
  - Example of vim_account edition: TODO
- DELETE: Removes vim_account.

`/admin/v1/wim_accounts`. (rbac: `wims`). WIM are WAN Infrastructure Managers, that is in charge of inter VIM connectivity management

- GET: Get wim_accounts
- POST: Add a new wim_account.
  - Example of request content: TODO

`/admin/v1/wim_accounts/`. (rbac: `wims:id`)

- GET: Get wim_account details
- PUT/PATCH: Edit wim_account.
  - Example of wim_account edition: TODO
- DELETE: Removes wim_account.

`/admin/v1/sdns`. (rbac: `sdn_controllers`). SDN controllers in charge of VIM's underlay connectivity in SDN Assist

- GET: Gets sdns
- POST: Add a new sdn.
  - Example of request content: TODO

`/admin/v1/k8sclusters`. (rbac: `k8sclusters`). K8S Clusters to deploy juju bundles or helm packages

- GET: Gets k8s clusters
- POST: Add a new k8s cluster.
  - Example of request content: TODO

`/admin/v1/k8srepos`. (rbac: `k8srepos`). K8S repository that contains the juju bundles or helm packages

- GET: Gets k8s repositories
- POST: Add a new k8s repository.
  - Example of request content: TODO

`/admin/v1/sdns/`. (rbac: `sdn_controllers:id`)

- GET: Get sdn details
- PUT/PATCH: Edit sdn.
  - Example of sdn edition: TODO
- DELETE: Removes sdn.

`/admin/v1/k8sclusters/`. (rbac: `k8sclusters:id`)

- GET: Get k8sclusters details
- PUT/PATCH: Edit k8sclusters.
- DELETE: Removes k8sclusters.

`/admin/v1/k8srepos/`. (rbac: `k8srepos:id`)

- GET: Get k8srepos details
- PUT/PATCH: Edit k8srepos.
- DELETE: Removes k8srepos.

## PDU Details

Physical Data Unit. This is catalogue of physical elements present at some vim_account/s. Deployment of a PNFD/HNFD implies using one of this pdu from the catalogue. Matching from PNFD/HNFD to PDU is done by 'pdu.type'

`/pdu/v1/pdu_descriptor`. (rbac: `pduds`)

- GET: List PDUs. Use query string for filtering.
- POST: Create a new PDU.
  - Example of request content:

```yaml
name: descriptive name              # mandatory
type: str                           # mandatory. maps VNFD.vdu.pdu-type
description: str
vim_accounts: [vim-account-id, ...] # mandatory
interfaces:                         # mandatory
-   name: str                       # mandatory. Maps VNFD.vdu.interfaces.name
    mgmt: boolean                   # mandatory. Indicates if is the management one
    ip-address: ip                  # mandatory
    vim-network-id: xxx
    vim-network-name: xxx
```

`/pdu/v1/pdu_descriptor/`. (rbac: `pduds:id`)

- GET: show PDU details
- PUT: overwrite this PDU
- PATCH: edit this PDU
- DELETE: remove the PDU

## VNFD Details

Virtual Network Function Descriptor. This includes also Physical and Hybrid Network Funcitons Descriptors (PNFD/HNFD). (At VDU level, it is indicated if it is physical with the `'pdu-type'` information element).

TBC

## NSD Details

Network Services Descriptor

TBC

## NSLCM Details

Network Services Lifecycle Management

`/nslcm/v1/ns_instances_content`.

- GET: (rbac: `ns_instances:get`) Obtains a list of NS
- POST: (rbac: `ns_instances:content:post`) (Asynchronous). Creates and Instantiate a NS. It returns the nsInstanceId in the response header `'Location'`. Example of request content:

```yaml
nsName: name            # mandatory
nsdId: nsd-internal-id  # mandatory
vimAccountId: internal-id   # mandatory
wimAccountId: False/True/internal-id
additionalParamsForNs:  {param1: value1, param2: value2}
additionalParamsForVnf: [member-vnf-index: "1", additionalParams: {param1: value1, param2: value2}]
ssh_keys: [ssh-key-pub1, ssh-key-pub2, ]
vnf: [ {member-vnf-index: "1", vimAccountId: vim-uuid, internal-vld: [], vdu: [] } ]
vld: [ {name: vld-name, ip-profile: {}, vnfd-connection-point-ref: [{}] }]
```

`/nslcm/v1/ns_instances_content/`. (rbac: `ns_instances:id`)

- GET: Obtains details of a NS
- DELETE: (Asynchronous) Terminates (or undeploy) and deletes (if termination is done successfully) a NS

`/nslcm/v1/ns_instances`. (rbac: `ns_instances`)

- GET: Obtains a list of NS
- POST: Creates a NS, but do not instantiate it. It returns the nsInstanceId in the response header `'Location'`. Example of request content:

```yaml
nsName: name            # mandatory
nsdId: nsd-internal-id  # mandatory
vimAccountId: internal-id   # mandatory
wimAccountId: False/True/internal-id
additionalParamsForNs:  {param1: value1, param2: value2}
additionalParamsForVnf: [member-vnf-index: "1", additionalParams: {param1: value1, param2: value2}]
```

`/nslcm/v1/ns_instances/`. (rbac: `ns_instances:id`)

- GET: Obtains details of a NS
- DELETE: Deletes a NS. It fails if NS is in 'INSTANTIATED' state

`/nslcm/v1/ns_instances//instantiate`. (rbac: `ns_instances:id:instantiate:post`)

- POST: (Asynchronous). Deploys a NS that it is in NOT_INSTANTIATED state. It returns the nsLcmOpOccId (Operations Occurrence Id) in the response header `'Location'`. Example of request content:

```yaml
vimAccountId: internal-id   # mandatory
wimAccountId: False/True/internal-id
ssh_keys: [ssh-key-pub1, ssh-key-pub2, ]
vnf: [ {member-vnf-index: "1", vimAccountId: vim-uuid, internal-vld: [], vdu: [] } ]
vld: [ {name: vld-name, ip-profile: {}, vnfd-connection-point-ref: [{}] }]
```

`/nslcm/v1/ns_instances//terminate`. (rbac: `ns_instances:id:terminate:post`)

- POST: (Asynchronous). Undeploys a NS that it is in INSTANTIATED state. It returns the nsLcmOpOccId (Operations Occurrence Id) in the response header `'Location'`

`/nslcm/v1/ns_instances//action`. (rbac: `ns_instances:id:action:post`)

- POST: (Asynchronous). Performs a Day-2 operation over the NS. It returns the nsLcmOpOccId (Operationts Occurence Id) in the response header `'Location'`
  - Example of content to executing a primitive:

```yaml
member_vnf_index: str    # Needed for VNFD mapping NSD.constituent-vnfd.member-vnf-index. If missing a NSD is targeting
vdu_id: str              # Needed if target is a VDU. Maps VNFD.vdu-id
vdu_count_index: int     # Needed if the VDU has several replicas (count>1)
primitive: str           # Mandatory. Maps [NSD.ns-configuration or VNFD.vnf-configuration or VNFD.vdu.vdu-configuration].config-primitive.name
primitive_params: dict   # Optional. Maps [NSD.ns-configuration or VNFD.vnf-configuration or VNFD.vdu.vdu-configuration].config-primitive.parameter
   param: value
   ...
```

`/nslcm/v1/ns_instances//scale`. (rbac: `ns_instances:id:scale:post`)

- POST: (Asynchronous). Performs a manual scale OUT/IN over one of the VNFs of the NS. It returns the nsLcmOpOccId (Operationts Occurence Id) in the response header `'Location'`
  - Example of content:

```json
'{scaleType: SCALE_VNF, scaleVnfData: {scaleVnfType: SCALE_OUT, scaleByStepData: {member-vnf-index: <nsd:constituent-vnfd:member-vnf-index>, scaling-group-descriptor: <vnfd:scaling-group-descriptor:name>} } }' # Use SCALE_IN instead of SCALE OUT depending of desired type.
```

`/nslcm/v1/ns_instances/nsi_lcm_op_occs`. (rbac: `ns_instances:opps`)

- GET: Obtains the list of Operations occurrences. It may be useful filtering by a concrete NS with `'?nsInstanceId=<nsInstaceId>'`

`/nslcm/v1/ns_instances/nsi_lcm_op_occs/`. (rbac: `ns_instances:opps:id`)

- GET: Show details of an Operations occurrences.

`/nslcm/v1/vnf_instances`. (rbac: `vnf_instances`). (also vnfrs for compatibility):

- GET: Obtains the list of VNF. It may be useful filtering by a concrete NS with `'?nsr-id-ref=<nsInstaceId>'`

`/nslcm/v1//vnf_instances/`. (rbac: `vnf_instances:id`)

- GET: Show details of a concrete VNF

## NST Details

NetSlice Template descriptor

`/nst/v1/netslice_templates_content`

- GET: (rbac: `slice_templates:get`). Obtain list of Network Slice Templates
- POST (rbac: `slice_templates:content:post`). Create a Network Slice Template and upload the content

`/nst/v1/netslice_templates_content/`. (rbac: `slice_templates:id`)

- GET: Show the detail of Network Slice Template
- PUT: Update the whole Network Slice Template
- DELETE: Remove a Network Slice template. The Network Slice template is removed only if state is `NOT_IN_USE`.

`/nst/v1/netslice_templates`. (rbac: `slice_templates`)

- GET: Obtain list of Network Slice Templates
- POST: Create an empty Network Slice Template. A PUT should be done afterwards to upload the package

`/nst/v1/netslice_templates/`. (rbac: `slice_templates:id`)

- GET: Show the detail of Network Slice Template descriptor used by OSM
- DELETE: Remove a Network Slice Template. The Network Slice template is removed only if state is `NOT_IN_USE`.
- PATCH: Update a Network Slice Template field

`/nst/v1/netslice_templates//nst_content`. (rbac: `slice_templates:content`)

- GET: Show the detail of the source Network Slice Template package
- PUT: Update a Network Slice Template

`/nst/v1/netslice_templates//nst`. (rbac: `slice_templates:id:nst`)

- GET: Show the detail of the source Network Slice Template descriptor

`/nst/v1/netslice_templates//artifacts[/]`. (rbac: `slice_templates:id:nst_artifact`)

- GET: Obtain Network Slice Templates Artifacts. This is useful for download the Network Slice Templates

## NSILCM Details

NetSlice Instance Lifecycle Management

`/nsilcm/v1/netslice_instances_content`

- GET: (rbac: `slice_instances:get`). Obtain the list of Network Slice Instances
- POST: (rbac: `slice_instances:content:post`) (Asynchronous). Creates and Instantiate a Network Slice Instance. It returns the `netsliceInstanceId` in the response header `'Location'`. Example of request content:

```yaml
    nstId: name of the Network Slice Template   #mandatory
    nsiName: name of the Network Slice Instance # mandatory
    vimAccountId: internal-id   # mandatory
    ssh_keys: comma separated list of keys to inject to vnfs
    nsiDescription: description of the Network Slice Instance
    additionalParamsForNsi: {param: value, ...}
    netslice-subnet: [ Same content as section #NSLCM_Details /nslcm/v1/ns_instances_content
    ],
    netslice-vld: [
                   name: TEXT,
                   vim-network-name: TEXT or DICT with the name for each vim account: {vimAccountId: network-name, ...},
                   vim-network-id: TEXT or DICT with the id for each vim account {vimAccountId: network-id},
                   ip-profile: Profile of the vld
    ]
```

`/nsilcm/v1/netslice_instances_content/`. (rbac: `slice_instances:id`)

- GET: Show details of a concrete Network Slice Instance
- DELETE: (Asynchronous) Terminates (or _`undeploy`_) and deletes (if termination is done successfully) a Network Slice Instance Record

`/nsilcm/v1/netslice_instances`. (rbac: `slice_instances`)

- GET: Obtain the list of Network Slice Instances
- POST: Create the Network Slice Instance but do not instantiate it. It returns the netsliceInstanceId in the response header `'Location'`. Example of request content: Same content as section [NSILCM Details /nsilcm/v1/netslice_instances_content](#nsilcm-details)

`/nsilcm/v1/netslice_instances/`. (rbac: `slice_instances:id`)

- GET: Show details of a concrete Network Slice Instance
- DELETE: Delete the Network Slice Instance Record, if it is not instantiated

`/nsilcm/v1/netslice_instances//instantiate`. (rbac: `slice_instances:id:instantiate:post`)

- POST: (Asynchronous). Deploys a Network Slice Instance that it is in `NOT_INSTANTIATED` state. It returns the `nsiLcmOpOccId` (Operations Occurrence Id) in the response header 'Location'. Example of request content: Same content as section [NSILCM Details /nsilcm/v1/netslice_instances_content](#nsilcm-details)

`/nsilcm/v1/netslice_instances//terminate`. (rbac: `slice_instances:id:terminate:post`)

- POST: (Asynchronous). Undeploys a Network Slice Instance that it is in `INSTANTIATED` state. It returns the `nsLcmOpOccId` (Operations Occurrence Id) in the response header `'Location'`

`/nsilcm/v1/netslice_instances/nsi_lcm_op_occ`. (rbac: `slice_instances:opps`)

- GET: Obtain the list of Network Slice Instances operations. It may be useful filtering by a concrete NSI with `'?netsliceInstanceId=<netsliceInstanceId>'`

`/nsilcm/v1/netslice_instances/nsi_lcm_op_occ/`. (rbac: `slice_instances:opps:id`)

- GET: Show details of a concrete Network Slice Instance operation
