# ANNEX 2: Reference of OSM Client commands and library

**Usage:**

```bash
osm [OPTIONS] COMMAND [ARGS]...
```

**Options:**

```bash
  --hostname TEXT  hostname of server.  Also can set OSM_HOSTNAME in environment
  --user TEXT      user (defaults to admin). Also can set OSM_USER in environment
  --password TEXT  password (defaults to admin). Also can set OSM_PASSWORD in environment
  --project TEXT   project (defaults to admin). Also can set OSM_PROJECT in environment
  -h, --help       Show this message and exit.

Commands:
  k8scluster-add             adds a K8s cluster to OSM NAME: name of the K8s cluster
  k8scluster-delete          deletes a K8s cluster NAME: name or ID of the K8s cluster to be deleted
  k8scluster-list            list all K8s clusters
  k8scluster-show            shows the details of a K8s cluster NAME: name or ID of the K8s cluster
  k8scluster-update          updates a K8s cluster
  netslice-instance-create   creates a new Network Slice Instance
  netslice-instance-delete   deletes a Network Slice Instance (NSI)
  netslice-instance-list     list all Network Slice Instances (NSI)
  netslice-instance-op-list  shows the history of operations over a Network Slice Instance (NSI)
  netslice-instance-op-show  shows the info of an operation over a Network Slice Instance(NSI)
  netslice-instance-show     shows the content of a Network Slice Instance (NSI)
  netslice-template-create   creates a new Network Slice Template (NST)
  netslice-template-delete   deletes a Network Slice Template (NST)
  netslice-template-list     list all Network Slice Templates (NST)
  netslice-template-show     shows the content of a Network Slice Template (NST)
  netslice-template-update   updates a Network Slice Template (NST)
  nf-list                    list all NF instances
  nfpkg-create               creates a new NFpkg
  nfpkg-delete               deletes a NFpkg
  nfpkg-list                 list all xNF packages (VNF, HNF, PNF)
  nfpkg-show                 shows the content of a NF Descriptor
  nfpkg-update               updates a NFpkg
  ns-action                  executes an action/primitive over a NS instance
  ns-alarm-create            creates a new alarm for a NS instance
  ns-create                  creates a new Network Service instance
  ns-delete                  deletes a NS instance
  ns-list                    list all NS instances
  ns-metric-export           exports a metric to the internal OSM bus, which can be read by other apps
  ns-op-list                 shows the history of operations over a NS instance
  ns-op-show                 shows the info of a NS operation
  ns-show                    shows the info of a NS instance
  nsd-create                 creates a new NSD/NSpkg
  nsd-delete                 deletes a NSD/NSpkg
  nsd-list                   list all NS packages
  nsd-show                   shows the content of a NSD
  nsd-update                 updates a NSD/NSpkg
  nsi-create                 creates a new Network Slice Instance
  nsi-delete                 deletes a Network Slice Instance (NSI)
  nsi-list                   list all Network Slice Instances (NSI)
  nsi-op-list                shows the history of operations over a Network Slice Instance (NSI)
  nsi-op-show                shows the info of an operation over a Network Slice Instance(NSI)
  nsi-show                   shows the content of a Network Slice Instance (NSI)
  nspkg-create               creates a new NSD/NSpkg
  nspkg-delete               deletes a NSD/NSpkg
  nspkg-list                 list all NS packages
  nspkg-show                 shows the content of a NSD
  nspkg-update               updates a NSD/NSpkg
  nst-create                 creates a new Network Slice Template (NST)
  nst-delete                 deletes a Network Slice Template (NST)
  nst-list                   list all Network Slice Templates (NST)
  nst-show                   shows the content of a Network Slice Template (NST)
  nst-update                 updates a Network Slice Template (NST)
  package-build              Build the tar.gz of the package
  package-create             Create a package descriptor
  package-validate           Validate a package descriptor
  pdu-create                 adds a new Physical Deployment Unit to the catalog
  pdu-delete                 deletes a Physical Deployment Unit (PDU)
  pdu-list                   list all Physical Deployment Units (PDU)
  pdu-show                   shows the content of a Physical Deployment Unit (PDU)
  project-create             creates a new project
  project-delete             deletes a project
  project-list               list all projects
  project-show               shows the details of a project
  project-update             updates a project (only the name can be updated)
  repo-add                   adds a repo to OSM NAME: name of the repo URI: URI of the repo
  repo-delete                deletes a repo NAME: name or ID of the repo to be deleted
  repo-list                  list all repos
  repo-show                  shows the details of a repo NAME: name or ID of the repo
  repo-update                updates a repo in OSM NAME: name of the repo
  role-create                creates a new role
  role-delete                deletes a role
  role-list                  list all roles
  role-show                  show specific role
  role-update                updates a role
  sdnc-create                creates a new SDN controller
  sdnc-delete                deletes an SDN controller
  sdnc-list                  list all SDN controllers
  sdnc-show                  shows the details of an SDN controller
  sdnc-update                updates an SDN controller
  upload-package             uploads a VNF package or NS package
  user-create                creates a new user
  user-delete                deletes a user
  user-list                  list all users
  user-show                  shows the details of a user
  user-update                updates user information
  version
  vim-create                 creates a new VIM account
  vim-delete                 deletes a VIM account
  vim-list                   list all VIM accounts
  vim-show                   shows the details of a VIM account
  vim-update                 updates a VIM account
  vnf-list                   list all NF instances
  vnf-scale                  executes a VNF scale (adding/removing VDUs)
  vnf-show                   shows the info of a VNF instance
  vnfd-create                creates a new VNFD/VNFpkg
  vnfd-delete                deletes a VNFD/VNFpkg
  vnfd-list                  list all xNF packages (VNF, HNF, PNF)
  vnfd-show                  shows the content of a VNFD
  vnfd-update                updates a new VNFD/VNFpkg
  vnfpkg-create              creates a new VNFD/VNFpkg
  vnfpkg-delete              deletes a VNFD/VNFpkg
  vnfpkg-list                list all xNF packages (VNF, HNF, PNF)
  vnfpkg-show                shows the content of a VNFD
  vnfpkg-update              updates a VNFD/VNFpkg
  wim-create                 creates a new WIM account
  wim-delete                 deletes a WIM account
  wim-list                   list all WIM accounts
  wim-show                   shows the details of a WIM account
  wim-update                 updates a WIM account
```

TODO:: To be updated to add newest options. Meanwhile you can run `osm --help` to obtain the latest command reference.

## Enable autocompletion

You can enable autocompletion in OSM client by creating a file osm-complete.sh in the following way:

```bash
mkdir -p $HOME/.bash_completion.d
_OSM_COMPLETE=source osm > $HOME/.bash_completion.d/osm-complete.sh
```

Then you can add the following to your $HOME/.bashrc file:

```bash
. .bash_completion.d/osm-complete.sh
```

## Other installation methods

### Installing from git repo

```bash
# Ubuntu pre-requirements
sudo apt install python3-pip libcurl4-gnutls-dev libgnutls-dev
# CentOS pre-requirements
# sudo yum install python3-pip libcurl-devel gnutls-devel
sudo -H pip install python3-magic
# Install OSM Information model
sudo -H pip3 install git+https://osm.etsi.org/gerrit/osm/IM --upgrade
# Install OSM client from the git repo.
# You can install the latest client from master branch in this way:
sudo -H pip3 install git+https://osm.etsi.org/gerrit/osm/osmclient
# You could also install a specific tag/version in this way
sudo -H pip3 install git+https://osm.etsi.org/gerrit/osm/osmclient@v7.0.0rc1
```

### Installing from cloned repo (for developers)

```bash
# Ubuntu pre-requirements
sudo apt install python3-pip libcurl4-gnutls-dev libgnutls-dev
# Make sure that
# sudo yum install python-pip libcurl-devel gnutls-devel
sudo -H pip install python3-magic
# Install OSM Information model
sudo -H pip3 install git+https://osm.etsi.org/gerrit/osm/IM --upgrade
# Clone the osmclient repo and install OSM client from the git repo.
git clone https://osm.etsi.org/gerrit/osm/osmclient
sudo -H pip3 install osmclient
```

## Using osmclient as a library to interact with OSM

Assuming that you have installed python-osmclient package, it's pretty simple to write some Python code to interact with OSM.

### Simple Python code to get the list of NS packages

```python
from osmclient import client
from osmclient.common.exceptions import ClientException
hostname = "127.0.0.1"
myclient = client.Client(host=hostname, sol005=True)
resp = myclient.nsd.list()
print yaml.safe_dump(resp)
```

### Simple Python code to get the list of VNF packages from a specific user and project

The code will print for each package a pretty table, then the full details in yaml

```python
from osmclient import client
from osmclient.common.exceptions import ClientException
import yaml
from prettytable import PrettyTable
hostname = "127.0.0.1"
user = admin
password = admin
project = admin
kwargs = {}
if user is not None:
    kwargs['user']=user
if password is not None:
    kwargs['password']=password
if project is not None:
   kwargs['project']=project
myclient = client.Client(host=hostname, sol005=True, **kwargs)
resp = myclient.vnfd.list()
print yaml.safe_dump(resp)
```
