# OSM platform configuration

## Role-based Access Control (RBAC)

Role-Based Access Control (RBAC) is available in OSM to bring different users and projects a controlled access to resources. Authorization is granted if a user has the necessary role to perform an action.
For achieving this, two backends are available:

- Internal (default): handles identity and assignment resources locally by NBI.
- Keystone: external component to handle identity and assignment resources, together with out-of-the-box integrations (i.e. LDAP) and more advanced use RBAC cases.

![OSM RBAC Options](assets/800px-OSM_rbac.png)

Similar to other platforms like OpenStack, in OSM there are default policies (that can be modified) that apply to a combination of user-project-role.
That means that, in order to obtain privileges to do something in OSM, you should have a user, belonging to a project, with a specific role over the project.

By default, OSM starts with the following credentials:

- User: admin
- Project assigned to user: admin
- Role assigned to user: system-admin (system-wide privileges)

The configuration can be extended to cover more users, projects and role combinations, following the next sections.

## User management

Users can be managed through the UI, by selecting Admin --> Users on the menu to the left, or using the OSM CLI:

```bash
  osm-user-create                creates a new user
  osm-user-delete                deletes a user
  osm-user-list                  list all users
  osm-user-show                  shows the details of a user
  osm-user-update                updates user information
```

Most of the commands are intuitive, but options can be checked by using '--help'. For example:

```bash
osm user-update --help
Usage: osm user-update [OPTIONS] USERNAME

  Update a user information

  USERNAME: name of the user
  PASSWORD: new password
  SET_USERNAME: new username
  SET_PROJECT: creating mappings for project/role(s)
  REMOVE_PROJECT: deleting mappings for project/role(s)
  ADD_PROJECT_ROLE: adding mappings for project/role(s)
  REMOVE_PROJECT_ROLE: removing mappings for project/role(s)

Options:
  --password TEXT             user password
  --set-username TEXT         change username
  --set-project TEXT          create/replace the project,role(s) mapping for this project: 'project,role1,role2,...'
  --remove-project TEXT       removes project from user: 'project'
  --add-project-role TEXT     adds project,role(s) mapping: 'project,role1,role2,...'
  --remove-project-role TEXT  removes project,role(s) mapping: 'project,role1,role2,...'
  -h, --help                  Show this message and exit.
```

## Project management

Projects can be managed through the UI, by selecting Admin --> Projects on the menu to the left, or using the OSM CLI:

```bash
  osm-project-create             creates a new project
  osm-project-delete             deletes a project
  osm-project-list               list all projects
  osm-project-show               shows the details of a project
  osm-project-update             updates a project (only the name can be updated)
```

Most of the commands are intuitive, but options can be checked by using `--help`. For example:

```bash
osm project-update --help
Usage: osm project-update [OPTIONS] PROJECT

  Update a project name

  :param ctx: :param project: id or name of the project to modify :param name:  new name for the project :return:

Options:
  --name TEXT  new name for the project
  -h, --help   Show this message and exit.
```

## VIM management

TODO: Page in elaboration.

```text
Some planned contents:
- Uses of availability zones
- Host aggregates
```

## Physical Deployment Units

OSM can handle Physical Network Functions through managing the lifecycle, in particular Day-1/2 configurations, for the Physical Deployments Units (PDUs) that are part of a given PNF.

Some relevant concepts are:

- PNF: Physical network function. It refers to a HW box that provides a networking function. For example: Routers, firewalls and load balancers.
- PDU: Physical deployment unit. It refers to the instance of the PNF that will be managed.
- HNF: Hybrid network function: Network function composed of both physical and virtual elements.

In OSM, there are no fundamental differences between modelling a VNF, a PNF or a Hybrid Network Function (HNF). In those cases where we want to define NS packages consisting of PNF packages or HNF packages, OSM needs to be instructed about the available PDUs.

Before including a PDU as part of a HNF Descriptor file, which would be similar to a VNFD, the PDU needs to be register.

A PDU can be registered through the UI (Instances --> PDU Instances), for example:

![Creating a PDU through the UI](assets/800px-OSM_pdu.png)

It can also be created through a YAML file which looks like this:

```yaml
name:           router01
description:    router
type:           gateway
vim_accounts:   [ 0a3a0a79-a86c-4812-9409-7509ff78d778 ]
shared:         false
interfaces:
 -  name:       eth0
    ip-address: [external IP address with no brackets]
    vim-network-name: PUBLIC
    mgmt:       true
 -  name:       eth1
    ip-address: [internal IP address with no brackets]
    mgmt:       false
```

Then, using the OSM CLI, the yaml file is used to register the PDU.

```bash
osm pdu-create --descriptor_file PDU_router.yaml
```

Finally, the PDU is included in the descriptor as it was any VDU (with the applicable parameters), and Day1/2 configurations can be applied to it. For example, a PDU could be modeled like this:

```yaml
    vdu:
        -   description: gateway_pdu
            id: gateway_pdu
            interface:
            -   external-connection-point-ref: gateway_public
                name: eth1
                type: EXTERNAL
            pdu-type: gateway
            vdu-configuration:
              ...
```

## Intra-VIM SDN management (for SDN Assist)

TODO: Page in elaboration.

## WIM (Inter-VIM SDN) management

### Introduction to the use of a WIM in OSM

WIM is the acronym for _WAN Infrastructure Manager_, which is a specialized system that allows to establish connectivity between different network endpoints at different NFVI-PoPs in the context of a multi-site service Wide Area Network (WAN).

For the establishment of the network connectivity, the WIM may rely on network controllers that handle the fulfilment of the connectivity at a lower level, potentially making use of different network technologies and protocols. The WIM offers to the consumers an abstraction of such network connectivity to ease the provisioning and monitoring of it.

### WIM setup through OSM client

The following is the command needed to perform to setup the WIM in OSM. It must be filled with the appropriate parameters (e.g. site name: `wim-demo`, IP address: `10.10.10.10:8080`, user: `username`, password: `userpwd`, wim_type: `type` port mapping: `sample_port_mapping.yml`)

```bash
osm wim-create --name wim-demo --url http://10.10.10.10:8080 --user username --password userpwd --wim_type type --description "Demo WIM"   --wim_port_mapping sample_port_mapping.yml
```

#### WIM port mapping

The port mapping file indicated above should be adapted to the desired WIM configuration. It should be a `.yml` file that contains the information of the OpenStack where the WIM is going to be configured, following one of these schemas [\[1\]](https://osm.etsi.org/gitweb/?p=osm/RO.git;a=blob;f=osm_ro/wim/schemas.py)

#### WIM types

- `ietfl2vpn`: this type allows to manage L2VPN services from OSM using a WIM that exposes a Restconf Interface with the Yang L2SM model defined in [RFC 8466](https://tools.ietf.org/html/rfc8466).
- `DynPaC`: the DynPaC (Dynamic Path Computation Framework) WIM connector allows the creation (and deletion) of layer two services between two VNFs with given bandwidth requirements.

### Network Service creation

In order to create a NS utilizing a WIM, the `osm ns-create` command is executed the following way:

```bash
osm ns-create --ns_name <ns_name> --nsd_name <nsd_name> --vim_account <vim-1-name> --config ' { vnf: [ {member-vnf-index: "1", vim_account: <vim-1-name>}, {member-vnf-index: "2", vim_account: <vim-2-name>} ] }'
```

Then, an available WIM capable of connecting those two datacenters will be used.

### L2SM Plugin

The L2SM WIM Plugin is included in the RO component of the OSM version six that allows the management of WIM Services. Those WIMs should be created to support connectivity between VNFs running in different VIMs.

The L2SM WIM plugin allows connecting the OSM to handle the lifecycle of a layer 2 VPN service, request creation, modification and deletion, by utilizing the service delivery model defined in [RFC 8466](https://tools.ietf.org/html/rfc8466).

#### L2SM Plugin port mapping

As it was indicated, the port mapping should be adapted to the WIM configuration. In this case, to configure the WIM, the port mapping file `.yml` should be created following the wim_port_mapping_desc schema, as in the following example:

```yaml
- datacenter_name:  "name1"
  pop_wan_mappings:
    - pop_switch_dpid: "openflow:1"
      pop_switch_port: 1
      wan_service_endpoint_id: "1"
      wan_service_mapping_info:
          mapping_type: direct-connect1
          site-id: '1'
          bearer:
               bearer-reference:'1a'
```

For each port of each site wanted to be added to the Network Service, it's needed a port mapping like previous one. The parameters needed for each port mapping are:

- `datacenter_name`: name of the desired site.
- `wan_service_endpoint_id`: UUID of the desired WAN endpoint.
- `site-id`: UUID of the desried site.
- `bearer-reference`: UUID of the desired port of the site to be added to the Network Service.

### DynPaC

DynPaC needs to first be installed as an application in the ONOS controller managing the WIM infraestructure. The `--url` parameter of wim-create will then be typically `http://<onos-ip>:8181/controller/wim`.

When adding OpenStack VIMs to be used with the DynPaC OSM WIM, the following needs to be passed to the `--config` parameter of the `osm vim-create` command:

```yaml
--config '{"user_domain_name": "<Openstack domain>", "project_domain_name": "<Openstack project>", "dataplane_physical_net": "<physical net>", "external_connections": [{"condition": {"provider:physical_network": "<physical net>", "provider:network_type": "vlan"}, "vim_external_port": {"switch": "<datacenter switch dpid>", "port": "<datacenter switch port>"}}]}'
```

`<datacenter switch dpid>` and `<datacenter switch port>` here are the same ones as `pop_switch_dpid` and `pop_switch_port` as will be seen later in the WIM port mapping example.

In order to add a DynPaC WIM to OSM that connects two datacenters (VIMs) with the wim-create command, the file passed to the `--wim_port_mapping` parameter should have the following structure. For example:

```yaml
- datacenter_name: "VIM 1"
  pop_wan_mappings:
  - pop_switch_dpid: "DC 1"
    pop_switch_port: "P1A"
    wan_service_mapping_info:
     mapping_type: 'dpid-port'
     wan_switch_dpid: "WAN 1"
     wan_switch_port: "P1B"
- datacenter_name: "VIM 2"
  pop_wan_mappings:
  - pop_switch_dpid: "DC 2"
    pop_switch_port: "P2B"
    wan_service_mapping_info:
     mapping_type: 'dpid-port'
     wan_switch_dpid: "WAN 2"
     wan_switch_port: "P2A"
```

![Wim schema.png](https://osm.etsi.org/wikipub/images/thumb/8/8a/Wim_schema.png/750px-Wim_schema.png)

Where:

- `datacenter_name` are the names of the two VIMs (as displayed by osm vim-list)
- `pop_switch_dpid` is the datapath ID of the datacenter switch that provides the VIM connectivity
- `pop_switch_port` is the port of the datacenter switch that connects to the immediate WAN switch
- `wan_switch_dpid` is the datapath ID of the immediate WAN switch
- `wan_switch_port` is the port of the immediate WAN switch that connects to the datacenter switch

DPIDs are in `of:xxxxxxxxxxxxxxxx` format.

## Platform configuration for Kubernetes

### Management of K8s clusters

As previously discussed, OSM supports the deployment of CNFs/KNFs over existing K8s clusters. This case implies that:

1. The K8s cluster is created upfront by an external entity. This process will happen out-of-band and no interaction with OSM is actually expected.
   - **NOTE:** This also includes the case where OSM creates a K8s cluster using a specific VNF package for that purpose.
2. OSM is informed (administratively) that the cluster is available for use in a given location (actually, referring to a VIM target). **This is the step covered in this section**.
   - Later on, NS instantiation processes that require the use of a K8s cluster in that location (i.e. VIM target) will deploy their KDUs over that cluster.
   - In case more than one K8s cluster is made available in that location, OSM will choose one based on the labels specified in the descriptor and in the registration of the cluster or. In case of more than one cluster in the same VIM meet the VNF requirements, OSM will follow a default order of preference or, if aplicable, the preference indicated in the instantiation parameters (similarly to the cases covered in VIMs).

Hence, in other to support this case, OSM's NBI provides a mechanism to be informed about existing K8s clusters. The corresponding CLI client command is the following:

```bash
osm k8scluster-add --creds <credentials_file.yaml> --vim <VIM_target> --version <ver=version> [--namespace "namespace_name"] [--cni "cni_plugin"] --k8s_nets '{(k8s_net1:vim_network1) [,(k8s_net2:vim_network2) ...]}' <name>
```

Where:

- `name` is the internal name that OSM will use to refer to the cluster.
- `credentials_file.yaml`: Credentials to access a given K8s cluster, i.e. a valid `.kube/config` information, including:
  - Reference to the K8s cluster
    - server's URL (`server`)
    - CA data (`certificate-authority-data`)
  - User with sufficient privileges
    - User name
    - Secret
    - At least one context. In case more than one context is selected, an explicit `current-context` must be defined.
- `namespace`. By default, it will use `kube-system` for this operation.
- `VIM_target`: The VIM where the cluster would reside or be attached (the case of bare metal clusters is simply considered a particular case here).
- `ver`: K8s version
- `k8s_nets`: list of VIM networks where the cluster is accessible via L3 routing, in (key,value) format, where:
  - The _key_ will be used to refer to a given cluster's network (e.g. "mgmt", "external", etc.)
  - The _value_ will be used to refer to a VIM network that provides L3 access to that cluster network.
- Optionally:
  - `cni`: list of CNIs used in the cluster.

This call triggers several actions in OSM:

1. Save this information in the common database.
2. Trigger the `init_env` call in the cluster.
3. If applicable, make the corresponding `repo_add` operations to add repositories known globally by OSM.

It is also possible removing a K8s cluster from the list of clusters known by OSM. In that case, the corresponding NBI call can be triggered by this command:

```bash
osm k8scluster-delete <name>
```

In case no CNFs/KNFs are running in the cluster, this call will trigger a `reset` operation and the entry will be removed from the common database. Otherwise, it will report an error.

### Management of K8s repos

OSM may be aware of a list of repos for K8s applications, so that they can be referenced from OSM packages. This prevents from the need of embedding them in the VNF package and makes the use more convenient in most of the cases.

In order to add a repo, the user should invoke the following command:

```bash
osm repo-add <name> <URI> type:<chart|bundle>
```

Where the type of repo should be either `chart` for applications based on Helm Charts, or `bundle` for applications based in Juju bundles for K8s.

This call will trigger the following actions in OSM:

1. Save this information in the common database.
2. Invoke the `repo_add` operation with the known K8s clusters.

Conversely, a repo can be removed with:

```bash
osm repo-delete <name>
```

Likewise, this operation would:

1. Update the common database accordingly.
2. Invoke the `repo_remove` operation with the known K8s clusters

At any moment, it is also possible to get the list of repos known by OSM:

```bash
osm repo-list
```

### Docker swarm build

### Kubernetes build
