# ANNEX 3: OSM Information Model

## YANG model in OSM repos

YANG models can be found in the IM repo under the models folder: https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree

OSM uses [pyang](https://github.com/mbj4668/pyang) and [pyangbind](https://github.com/robshakir/pyangbind) to generate Python classes used by the different OSM components.

## OSM IM tree representation

Below you can find tree representations of the VNFD (VNF Descriptor), NSD (Network Service Descriptor), NST (Network Slice Template), VNFR (VNF Record), NSR (Network Service Record), NSI (Network Slice Instance), both in navigable and plain text formats.

### VNFD tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/vnfd.html>**

**Plain text version:**

```text
module: vnfd
  +--rw vnfd-catalog
     +--rw schema-version?   string
     +--rw vnfd* [id]
        +--rw id                          string
        +--rw name                        string
        +--rw short-name?                 string
        +--rw vendor?                     string
        +--rw logo?                       string
        +--rw description?                string
        +--rw version?                    string
        +--rw vnf-configuration
        |  +--rw (config-method)?
        |  |  +--:(script)
        |  |  |  +--rw script
        |  |  |     +--rw script-type?   enumeration
        |  |  +--:(juju)
        |  |     +--rw juju
        |  |        +--rw charm?               string
        |  |        +--rw proxy?               boolean
        |  |        +--rw vca-relationships
        |  |           +--rw relation* [requires provides]
        |  |              +--rw requires    string
        |  |              +--rw provides    string
        |  +--rw config-primitive* [name]
        |  |  +--rw name                   string
        |  |  +--rw parameter* [name]
        |  |  |  +--rw name              string
        |  |  |  +--rw data-type?        manotypes:parameter-data-type
        |  |  |  +--rw mandatory?        boolean
        |  |  |  +--rw default-value?    string
        |  |  |  +--rw parameter-pool?   string
        |  |  |  +--rw read-only?        boolean
        |  |  |  +--rw hidden?           boolean
        |  |  +--rw user-defined-script?   string
        |  +--rw initial-config-primitive* [seq]
        |  |  +--rw seq                          uint64
        |  |  +--rw (primitive-type)?
        |  |     +--:(primitive-definition)
        |  |        +--rw name?                  string
        |  |        +--rw parameter* [name]
        |  |        |  +--rw name         string
        |  |        |  +--rw data-type?   manotypes:parameter-data-type
        |  |        |  +--rw value?       string
        |  |        +--rw user-defined-script?   string
        |  +--rw terminate-config-primitive* [seq]
        |  |  +--rw seq                    uint64
        |  |  +--rw name?                  string
        |  |  +--rw parameter* [name]
        |  |  |  +--rw name         string
        |  |  |  +--rw data-type?   manotypes:parameter-data-type
        |  |  |  +--rw value?       string
        |  |  +--rw user-defined-script?   string
        |  +--rw metrics* [name]
        |  |  +--rw name    string
        |  +--rw config-access
        |     +--rw ssh-access
        |        +--rw required?       boolean
        |        +--rw default-user?   string
        +--rw operational-status?         vnf-operational-status
        +--rw mgmt-interface
        |  +--rw (endpoint-type)?
        |  |  +--:(ip)
        |  |  |  +--rw ip-address?   inet:ip-address
        |  |  +--:(vdu-id)
        |  |  |  +--rw vdu-id?       -> ../../vdu/id
        |  |  +--:(cp)
        |  |     +--rw cp?           -> ../../connection-point/name
        |  +--rw port?               inet:port-number
        |  +--rw dashboard-params
        |     +--rw path?    string
        |     +--rw https?   boolean
        |     +--rw port?    inet:port-number
        +--rw internal-vld* [id]
        |  +--rw id                           string
        |  +--rw name?                        string
        |  +--rw short-name?                  string
        |  +--rw description?                 string
        |  +--rw type?                        manotypes:virtual-link-type
        |  +--rw root-bandwidth?              uint64
        |  +--rw leaf-bandwidth?              uint64
        |  +--rw internal-connection-point* [id-ref]
        |  |  +--rw id-ref        -> ../../../vdu/internal-connection-point/id
        |  |  +--rw ip-address?   inet:ip-address
        |  +--rw provider-network
        |  |  +--rw physical-network?   string
        |  |  +--rw segmentation_id?    uint32
        |  +--rw (init-params)?
        |     +--:(vim-network-ref)
        |     |  +--rw vim-network-name?      string
        |     +--:(vim-network-profile)
        |        +--rw ip-profile-ref?        string
        +--rw ip-profiles* [name]
        |  +--rw name                 string
        |  +--rw description?         string
        |  +--rw ip-profile-params
        |     +--rw ip-version?           inet:ip-version
        |     +--rw subnet-address?       inet:ip-prefix
        |     +--rw gateway-address?      inet:ip-address
        |     +--rw security-group?       string
        |     +--rw dns-server* [address]
        |     |  +--rw address    inet:ip-address
        |     +--rw dhcp-params
        |     |  +--rw enabled?         boolean
        |     |  +--rw start-address?   inet:ip-address
        |     |  +--rw count?           uint32
        |     +--rw subnet-prefix-pool?   string
        +--rw connection-point* [name]
        |  +--rw name                     string
        |  +--rw id?                      string
        |  +--rw short-name?              string
        |  +--rw type?                    manotypes:connection-point-type
        |  +--rw port-security-enabled?   boolean
        |  +--rw internal-vld-ref?        -> ../../internal-vld/id
        +--rw vdu* [id]
        |  +--rw id                           string
        |  +--rw name?                        string
        |  +--rw description?                 string
        |  +--rw pdu-type?                    string
        |  +--rw count?                       uint64
        |  +--rw mgmt-vpci?                   string
        |  +--rw vm-flavor
        |  |  +--rw vcpu-count?   uint16
        |  |  +--rw memory-mb?    uint64
        |  |  +--rw storage-gb?   uint64
        |  +--rw guest-epa
        |  |  +--rw trusted-execution?                 boolean
        |  |  +--rw mempage-size?                      enumeration
        |  |  +--rw (cpu-policy)?
        |  |  |  +--:(cpu-pinning)
        |  |  |  |  +--rw cpu-pinning-policy?          enumeration
        |  |  |  |  +--rw cpu-thread-pinning-policy?   enumeration
        |  |  |  +--:(cpu-quota)
        |  |  |     +--rw cpu-quota
        |  |  |        +--rw limit?     uint64
        |  |  |        +--rw reserve?   uint64
        |  |  |        +--rw shares?    uint64
        |  |  +--rw mem-quota
        |  |  |  +--rw limit?     uint64
        |  |  |  +--rw reserve?   uint64
        |  |  |  +--rw shares?    uint64
        |  |  +--rw disk-io-quota
        |  |  |  +--rw limit?     uint64
        |  |  |  +--rw reserve?   uint64
        |  |  |  +--rw shares?    uint64
        |  |  +--rw vif-quota
        |  |  |  +--rw limit?     uint64
        |  |  |  +--rw reserve?   uint64
        |  |  |  +--rw shares?    uint64
        |  |  +--rw pcie-device* [device-id]
        |  |  |  +--rw device-id    string
        |  |  |  +--rw count?       uint64
        |  |  +--rw (numa-policy)?
        |  |     +--:(numa-unaware)
        |  |     |  +--rw numa-unaware?                empty
        |  |     +--:(numa-aware)
        |  |        +--rw numa-node-policy
        |  |           +--rw node-cnt?     uint16
        |  |           +--rw mem-policy?   enumeration
        |  |           +--rw node* [id]
        |  |              +--rw id                      uint64
        |  |              +--rw vcpu* [id]
        |  |              |  +--rw id    uint64
        |  |              +--rw memory-mb?              uint64
        |  |              +--rw (om-numa-type)?
        |  |                 +--:(cores)
        |  |                 |  +--rw num-cores?        uint8
        |  |                 +--:(paired-threads)
        |  |                 |  +--rw paired-threads
        |  |                 |     +--rw num-paired-threads?   uint8
        |  |                 |     +--rw paired-thread-ids* [thread-a]
        |  |                 |        +--rw thread-a    uint8
        |  |                 |        +--rw thread-b?   uint8
        |  |                 +--:(threads)
        |  |                    +--rw num-threads?      uint8
        |  +--rw vswitch-epa
        |  |  +--rw ovs-acceleration?   enumeration
        |  |  +--rw ovs-offload?        enumeration
        |  +--rw hypervisor-epa
        |  |  +--rw type?      enumeration
        |  |  +--rw version?   string
        |  +--rw host-epa
        |  |  +--rw cpu-model?               enumeration
        |  |  +--rw cpu-arch?                enumeration
        |  |  +--rw cpu-vendor?              enumeration
        |  |  +--rw cpu-socket-count?        uint64
        |  |  +--rw cpu-core-count?          uint64
        |  |  +--rw cpu-core-thread-count?   uint64
        |  |  +--rw cpu-feature* [feature]
        |  |  |  +--rw feature    cpu-feature-type
        |  |  +--rw om-cpu-model-string?     string
        |  |  +--rw om-cpu-feature* [feature]
        |  |     +--rw feature    string
        |  +--rw alarm* [alarm-id]
        |  |  +--rw alarm-id                    string
        |  |  +--rw vnf-monitoring-param-ref?   -> ../../monitoring-param/id
        |  |  +--rw name?                       string
        |  |  +--rw description?                string
        |  |  +--rw vdur-id?                    string
        |  |  +--rw actions
        |  |  |  +--rw ok* [url]
        |  |  |  |  +--rw url    string
        |  |  |  +--rw insufficient-data* [url]
        |  |  |  |  +--rw url    string
        |  |  |  +--rw alarm* [url]
        |  |  |     +--rw url    string
        |  |  +--rw repeat?                     boolean
        |  |  +--rw enabled?                    boolean
        |  |  +--rw severity?                   alarm-severity-type
        |  |  +--rw statistic?                  alarm-statistic-type
        |  |  +--rw operation?                  relational-operation-type
        |  |  +--rw value?                      decimal64
        |  |  +--rw period?                     uint32
        |  |  +--rw evaluations?                uint32
        |  +--rw image?                       string
        |  +--rw image-checksum?              string
        |  +--rw alternative-images* [vim-type]
        |  |  +--rw vim-type          string
        |  |  +--rw image?            string
        |  |  +--rw image-checksum?   string
        |  +--rw vdu-configuration
        |  |  +--rw (config-method)?
        |  |  |  +--:(script)
        |  |  |  |  +--rw script
        |  |  |  |     +--rw script-type?   enumeration
        |  |  |  +--:(juju)
        |  |  |     +--rw juju
        |  |  |        +--rw charm?               string
        |  |  |        +--rw proxy?               boolean
        |  |  |        +--rw vca-relationships
        |  |  |           +--rw relation* [requires provides]
        |  |  |              +--rw requires    string
        |  |  |              +--rw provides    string
        |  |  +--rw config-primitive* [name]
        |  |  |  +--rw name                   string
        |  |  |  +--rw parameter* [name]
        |  |  |  |  +--rw name              string
        |  |  |  |  +--rw data-type?        manotypes:parameter-data-type
        |  |  |  |  +--rw mandatory?        boolean
        |  |  |  |  +--rw default-value?    string
        |  |  |  |  +--rw parameter-pool?   string
        |  |  |  |  +--rw read-only?        boolean
        |  |  |  |  +--rw hidden?           boolean
        |  |  |  +--rw user-defined-script?   string
        |  |  +--rw initial-config-primitive* [seq]
        |  |  |  +--rw seq                          uint64
        |  |  |  +--rw (primitive-type)?
        |  |  |     +--:(primitive-definition)
        |  |  |        +--rw name?                  string
        |  |  |        +--rw parameter* [name]
        |  |  |        |  +--rw name         string
        |  |  |        |  +--rw data-type?   manotypes:parameter-data-type
        |  |  |        |  +--rw value?       string
        |  |  |        +--rw user-defined-script?   string
        |  |  +--rw terminate-config-primitive* [seq]
        |  |  |  +--rw seq                    uint64
        |  |  |  +--rw name?                  string
        |  |  |  +--rw parameter* [name]
        |  |  |  |  +--rw name         string
        |  |  |  |  +--rw data-type?   manotypes:parameter-data-type
        |  |  |  |  +--rw value?       string
        |  |  |  +--rw user-defined-script?   string
        |  |  +--rw metrics* [name]
        |  |  |  +--rw name    string
        |  |  +--rw config-access
        |  |     +--rw ssh-access
        |  |        +--rw required?       boolean
        |  |        +--rw default-user?   string
        |  +--rw monitoring-param* [id]
        |  |  +--rw id                    string
        |  |  +--rw nfvi-metric?          manotypes:nfvi-metric-type
        |  |  +--rw interface-name-ref?   -> ../../interface/name
        |  +--rw (cloud-init-input)?
        |  |  +--:(inline)
        |  |  |  +--rw cloud-init?            string
        |  |  +--:(filename)
        |  |     +--rw cloud-init-file?       string
        |  +--rw supplemental-boot-data
        |  |  +--rw boot-data-drive?   boolean
        |  +--rw internal-connection-point* [id]
        |  |  +--rw name?                    string
        |  |  +--rw id                       string
        |  |  +--rw short-name?              string
        |  |  +--rw type?                    manotypes:connection-point-type
        |  |  +--rw port-security-enabled?   boolean
        |  |  +--rw internal-vld-ref?        -> ../../../internal-vld/id
        |  +--rw interface* [name]
        |  |  +--rw name                                   string
        |  |  +--rw position?                              uint32
        |  |  +--rw mgmt-interface?                        boolean
        |  |  +--rw type?                                  interface-type
        |  |  +--rw mac-address?                           string
        |  |  +--rw (connection-point-type)?
        |  |  |  +--:(internal)
        |  |  |  |  +--rw internal-connection-point-ref?   -> ../../internal-connection-point/id
        |  |  |  +--:(external)
        |  |  |     +--rw external-connection-point-ref?   -> ../../../connection-point/name
        |  |  +--rw virtual-interface
        |  |     +--rw type?        enumeration
        |  |     +--rw vpci?        string
        |  |     +--rw bandwidth?   uint64
        |  +--rw volumes* [name]
        |     +--rw name                    string
        |     +--rw description?            string
        |     +--rw size?                   uint64
        |     +--rw (volume-source)?
        |     |  +--:(ephemeral)
        |     |  |  +--rw ephemeral?        empty
        |     |  +--:(image)
        |     |     +--rw image?            string
        |     |     +--rw image-checksum?   string
        |     +--rw device-bus?             enumeration
        |     +--rw device-type?            enumeration
        +--rw vdu-dependency* [vdu-source-ref]
        |  +--rw vdu-source-ref        -> ../../vdu/id
        |  +--rw vdu-depends-on-ref?   -> ../../vdu/id
        +--rw service-function-chain?     enumeration
        +--rw service-function-type?      string
        +--rw http-endpoint* [path]
        |  +--rw path                     string
        |  +--rw https?                   boolean
        |  +--rw port?                    inet:port-number
        |  +--rw username?                string
        |  +--rw password?                string
        |  +--rw polling-interval-secs?   uint8
        |  +--rw method?                  manotypes:http-method
        |  +--rw headers* [key]
        |     +--rw key      string
        |     +--rw value?   string
        +--rw scaling-group-descriptor* [name]
        |  +--rw name                     string
        |  +--rw scaling-policy* [name]
        |  |  +--rw name                        string
        |  |  +--rw scaling-type?               manotypes:scaling-policy-type
        |  |  +--rw enabled?                    boolean
        |  |  +--rw scale-in-operation-type?    manotypes:scaling-criteria-operation
        |  |  +--rw scale-out-operation-type?   manotypes:scaling-criteria-operation
        |  |  +--rw threshold-time              uint32
        |  |  +--rw cooldown-time               uint32
        |  |  +--rw scaling-criteria* [name]
        |  |     +--rw name                              string
        |  |     +--rw scale-in-threshold?               decimal64
        |  |     +--rw scale-in-relational-operation?    manotypes:relational-operation-type
        |  |     +--rw scale-out-threshold?              decimal64
        |  |     +--rw scale-out-relational-operation?   manotypes:relational-operation-type
        |  |     +--rw vnf-monitoring-param-ref?         -> ../../../../monitoring-param/id
        |  +--rw vdu* [vdu-id-ref]
        |  |  +--rw vdu-id-ref    -> ../../../vdu/id
        |  |  +--rw count?        uint32
        |  +--rw min-instance-count?      uint32
        |  +--rw max-instance-count?      uint32
        |  +--rw scaling-config-action* [trigger]
        |     +--rw trigger                          manotypes:scaling-trigger
        |     +--rw vnf-config-primitive-name-ref?   -> ../../../vnf-configuration/config-primitive/name
        +--rw monitoring-param* [id]
        |  +--rw id                            string
        |  +--rw name?                         string
        |  +--rw aggregation-type?             aggregation-type
        |  +--rw (monitoring-type)?
        |  |  +--:(vdu-monitoring-param)
        |  |  |  +--rw vdu-monitoring-param
        |  |  |     +--rw vdu-ref?                    -> ../../../vdu/id
        |  |  |     +--rw vdu-monitoring-param-ref?   -> ../../../vdu[id = current()/../vdu-ref]/monitoring-param/id
        |  |  +--:(vnf-metric)
        |  |  |  +--rw vnf-metric
        |  |  |     +--rw vnf-metric-name-ref?   -> ../../../vnf-configuration/metrics/name
        |  |  +--:(vdu-metric)
        |  |     +--rw vdu-metric
        |  |        +--rw vdu-ref?               -> ../../../vdu/id
        |  |        +--rw vdu-metric-name-ref?   -> ../../../vdu[id = current()/../vdu-ref]/vdu-configuration/metrics/name
        |  +--rw http-endpoint-ref?            -> ../../http-endpoint/path
        |  +--rw json-query-method?            manotypes:json-query-method
        |  +--rw json-query-params
        |  |  +--rw json-path?     string
        |  |  +--rw object-path?   string
        |  +--rw description?                  string
        |  +--rw group-tag?                    string
        |  +--rw widget-type?                  manotypes:widget-type
        |  +--rw units?                        string
        |  +--rw value-type?                   param-value-type
        |  +--rw numeric-constraints
        |  |  +--rw min-value?   uint64
        |  |  +--rw max-value?   uint64
        |  +--rw text-constraints
        |  |  +--rw min-length?   uint8
        |  |  +--rw max-length?   uint8
        |  +--rw value-integer?                int64
        |  +--rw value-decimal?                decimal64
        |  +--rw value-string?                 string
        +--rw placement-groups* [name]
           +--rw name           string
           +--rw requirement?   string
           +--rw strategy?      enumeration
           +--rw member-vdus* [member-vdu-ref]
              +--rw member-vdu-ref    -> ../../../vdu/id
```

### NSD tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/nsd.html>**

**Plain text version:**

```text
module: nsd
  +--rw nsd-catalog
     +--rw schema-version?   string
     +--rw nsd* [id]
        +--rw id                          string
        +--rw name                        string
        +--rw short-name?                 string
        +--rw vendor?                     string
        +--rw logo?                       string
        +--rw description?                string
        +--rw version?                    string
        +--rw connection-point* [name]
        |  +--rw name                               string
        |  +--rw floating-ip-required?              boolean
        |  +--rw type?                              manotypes:connection-point-type
        |  +--rw (connection)?
        |     +--:(vld-ref)
        |     |  +--rw vld-id-ref?                  -> ../../vld/id
        |     +--:(vnfd-connection-point-ref)
        |        +--rw member-vnf-index-ref?        -> ../../constituent-vnfd/member-vnf-index
        |        +--rw vnfd-id-ref?                 -> ../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
        |        +--rw vnfd-connection-point-ref?   -> /vnfd:vnfd-catalog/vnfd[vnfd:id = current()/../vnfd-id-ref]/connection-point/name
        +--rw scaling-group-descriptor* [name]
        |  +--rw name                     string
        |  +--rw scaling-policy* [name]
        |  |  +--rw name                        string
        |  |  +--rw scaling-type?               manotypes:scaling-policy-type
        |  |  +--rw enabled?                    boolean
        |  |  +--rw scale-in-operation-type?    manotypes:scaling-criteria-operation
        |  |  +--rw scale-out-operation-type?   manotypes:scaling-criteria-operation
        |  |  +--rw threshold-time              uint32
        |  |  +--rw cooldown-time               uint32
        |  |  +--rw scaling-criteria* [name]
        |  |     +--rw name                              string
        |  |     +--rw scale-in-threshold?               uint64
        |  |     +--rw scale-in-relational-operation?    manotypes:relational-operation-type
        |  |     +--rw scale-out-threshold?              uint64
        |  |     +--rw scale-out-relational-operation?   manotypes:relational-operation-type
        |  |     +--rw ns-monitoring-param-ref?          -> ../../../../monitoring-param/id
        |  +--rw vnfd-member* [member-vnf-index-ref]
        |  |  +--rw member-vnf-index-ref    -> ../../../constituent-vnfd/member-vnf-index
        |  |  +--rw count?                  uint32
        |  +--rw min-instance-count?      uint32
        |  +--rw max-instance-count?      uint32
        |  +--rw scaling-config-action* [trigger]
        |     +--rw trigger                         manotypes:scaling-trigger
        |     +--rw ns-config-primitive-name-ref?   -> ../../../ns-configuration/config-primitive/name
        +--rw vnffgd* [id]
        |  +--rw id             string
        |  +--rw name?          string
        |  +--rw short-name?    string
        |  +--rw vendor?        string
        |  +--rw description?   string
        |  +--rw version?       string
        |  +--rw rsp* [id]
        |  |  +--rw id                           string
        |  |  +--rw name?                        string
        |  |  +--rw vnfd-connection-point-ref* [member-vnf-index-ref]
        |  |     +--rw member-vnf-index-ref                 -> ../../../../constituent-vnfd/member-vnf-index
        |  |     +--rw order?                               uint8
        |  |     +--rw vnfd-id-ref?                         -> ../../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
        |  |     +--rw vnfd-ingress-connection-point-ref?   string
        |  |     +--rw vnfd-egress-connection-point-ref?    string
        |  +--rw classifier* [id]
        |     +--rw id                           string
        |     +--rw name?                        string
        |     +--rw rsp-id-ref?                  -> ../../rsp/id
        |     +--rw match-attributes* [id]
        |     |  +--rw id                        string
        |     |  +--rw ip-proto?                 uint8
        |     |  +--rw source-ip-address?        inet:ip-address
        |     |  +--rw destination-ip-address?   inet:ip-address
        |     |  +--rw source-port?              inet:port-number
        |     |  +--rw destination-port?         inet:port-number
        |     +--rw member-vnf-index-ref?        -> ../../../constituent-vnfd/member-vnf-index
        |     +--rw vnfd-id-ref?                 -> ../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
        |     +--rw vnfd-connection-point-ref?   string
        +--rw ip-profiles* [name]
        |  +--rw name                 string
        |  +--rw description?         string
        |  +--rw ip-profile-params
        |     +--rw ip-version?           inet:ip-version
        |     +--rw subnet-address?       inet:ip-prefix
        |     +--rw gateway-address?      inet:ip-address
        |     +--rw security-group?       string
        |     +--rw dns-server* [address]
        |     |  +--rw address    inet:ip-address
        |     +--rw dhcp-params
        |     |  +--rw enabled?         boolean
        |     |  +--rw start-address?   inet:ip-address
        |     |  +--rw count?           uint32
        |     +--rw subnet-prefix-pool?   string
        +--rw ns-configuration
        |  +--rw (config-method)?
        |  |  +--:(script)
        |  |  |  +--rw script
        |  |  |     +--rw script-type?   enumeration
        |  |  +--:(juju)
        |  |     +--rw juju
        |  |        +--rw charm?               string
        |  |        +--rw proxy?               boolean
        |  |        +--rw vca-relationships
        |  |           +--rw relation* [requires provides]
        |  |              +--rw requires    string
        |  |              +--rw provides    string
        |  +--rw config-primitive* [name]
        |  |  +--rw name                   string
        |  |  +--rw parameter* [name]
        |  |  |  +--rw name              string
        |  |  |  +--rw data-type?        manotypes:parameter-data-type
        |  |  |  +--rw mandatory?        boolean
        |  |  |  +--rw default-value?    string
        |  |  |  +--rw parameter-pool?   string
        |  |  |  +--rw read-only?        boolean
        |  |  |  +--rw hidden?           boolean
        |  |  +--rw user-defined-script?   string
        |  +--rw initial-config-primitive* [seq]
        |  |  +--rw seq                          uint64
        |  |  +--rw (primitive-type)?
        |  |     +--:(primitive-definition)
        |  |        +--rw name?                  string
        |  |        +--rw parameter* [name]
        |  |        |  +--rw name         string
        |  |        |  +--rw data-type?   manotypes:parameter-data-type
        |  |        |  +--rw value?       string
        |  |        +--rw user-defined-script?   string
        |  +--rw terminate-config-primitive* [seq]
        |  |  +--rw seq                    uint64
        |  |  +--rw name?                  string
        |  |  +--rw parameter* [name]
        |  |  |  +--rw name         string
        |  |  |  +--rw data-type?   manotypes:parameter-data-type
        |  |  |  +--rw value?       string
        |  |  +--rw user-defined-script?   string
        |  +--rw metrics* [name]
        |     +--rw name    string
        +--rw input-parameter-xpath* [xpath]
        |  +--rw xpath            string
        |  +--rw label?           string
        |  +--rw default-value?   string
        +--rw parameter-pool* [name]
        |  +--rw name     string
        |  +--rw range
        |     +--rw start-value    uint32
        |     +--rw end-value      uint32
        +--rw key-pair* [name]
        |  +--rw name    string
        |  +--rw key?    string
        +--rw user* [name]
        |  +--rw name         string
        |  +--rw user-info?   string
        |  +--rw key-pair* [name]
        |     +--rw name    string
        |     +--rw key?    string
        +--rw vld* [id]
        |  +--rw id                           string
        |  +--rw name?                        string
        |  +--rw short-name?                  string
        |  +--rw vendor?                      string
        |  +--rw description?                 string
        |  +--rw version?                     string
        |  +--rw type?                        manotypes:virtual-link-type
        |  +--rw root-bandwidth?              uint64
        |  +--rw leaf-bandwidth?              uint64
        |  +--rw provider-network
        |  |  +--rw physical-network?   string
        |  |  +--rw segmentation_id?    uint32
        |  +--rw mgmt-network?                boolean
        |  +--rw (init-params)?
        |  |  +--:(vim-network-ref)
        |  |  |  +--rw vim-network-name?      string
        |  |  +--:(vim-network-profile)
        |  |     +--rw ip-profile-ref?        -> ../../ip-profiles/name
        |  +--rw vnfd-connection-point-ref* [member-vnf-index-ref vnfd-connection-point-ref]
        |     +--rw member-vnf-index-ref         -> ../../../constituent-vnfd/member-vnf-index
        |     +--rw vnfd-connection-point-ref    -> /vnfd:vnfd-catalog/vnfd[vnfd:id = current()/../vnfd-id-ref]/connection-point/name
        |     +--rw vnfd-id-ref?                 -> ../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
        |     +--rw ip-address?                  inet:ip-address
        +--rw constituent-vnfd* [member-vnf-index]
        |  +--rw member-vnf-index    string
        |  +--rw vnfd-id-ref?        -> /vnfd:vnfd-catalog/vnfd/id
        |  +--rw start-by-default?   boolean
        +--rw placement-groups* [name]
        |  +--rw name           string
        |  +--rw requirement?   string
        |  +--rw strategy?      enumeration
        |  +--rw member-vnfd* [member-vnf-index-ref]
        |     +--rw member-vnf-index-ref    -> ../../../constituent-vnfd/member-vnf-index
        |     +--rw vnfd-id-ref?            -> ../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
        +--rw vnf-dependency* [vnf-source-ref]
        |  +--rw vnf-source-ref        -> /vnfd:vnfd-catalog/vnfd/id
        |  +--rw vnf-depends-on-ref?   -> /vnfd:vnfd-catalog/vnfd/id
        +--rw monitoring-param* [id]
           +--rw id                       string
           +--rw name?                    string
           +--rw value-type?              param-value-type
           +--rw numeric-constraints
           |  +--rw min-value?   uint64
           |  +--rw max-value?   uint64
           +--rw text-constraints
           |  +--rw min-length?   uint8
           |  +--rw max-length?   uint8
           +--rw value-integer?           int64
           +--rw value-decimal?           decimal64
           +--rw value-string?            string
           +--rw description?             string
           +--rw group-tag?               string
           +--rw widget-type?             manotypes:widget-type
           +--rw units?                   string
           +--rw aggregation-type?        aggregation-type
           +--rw vnfd-monitoring-param* [member-vnf-index-ref vnfd-monitoring-param-ref]
              +--rw vnfd-id-ref?                 -> ../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
              +--rw vnfd-monitoring-param-ref    -> /vnfd:vnfd-catalog/vnfd[vnfd:id = current()/../vnfd-id-ref]/monitoring-param/id
              +--rw member-vnf-index-ref         -> ../../../constituent-vnfd/member-vnf-index
```

### NST tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/nst.html>**

**Plain text version:**

```text
module: nst
  +--rw nst* [id]
     +--rw id                           string
     +--rw name                         string
     +--rw SNSSAI-identifier
     |  +--rw slice-service-type      network-slice-type
     |  +--rw slice-differentiator?   string
     +--rw quality-of-service
     |  +--rw id                        uint16
     |  +--rw resource-type?            resource-type
     |  +--rw priority-level?           uint16
     |  +--rw packet-delay-budget?      uint16
     |  +--rw packet-error-rate?        uint16
     |  +--rw default-max-data-burst?   uint16
     +--rw netslice-subnet* [id]
     |  +--rw id                          string
     |  +--rw description?                string
     |  +--rw is-shared-nss?              boolean
     |  +--rw nsd-ref                     -> /nsd:nsd-catalog/nsd/id
     |  +--rw instantiation-parameters
     |     +--rw vimAccountId    string
     |     +--rw ssh_keys?       string
     |     +--rw vnf* [member-vnf-index]
     |     |  +--rw member-vnf-index    string
     |     |  +--rw vimAccountId?       string
     |     |  +--rw vdu* [id]
     |     |  |  +--rw id           string
     |     |  |  +--rw volume* [name]
     |     |  |  |  +--rw name             string
     |     |  |  |  +--rw vim-volume-id    string
     |     |  |  +--rw interface* [name]
     |     |  |     +--rw name                    string
     |     |  |     +--rw ip-address?             inet:ip-address
     |     |  |     +--rw mac-address?            ietf-yang:mac-address
     |     |  |     +--rw floating-ip-required?   boolean
     |     |  +--rw internal-vld* [name]
     |     |     +--rw name                         string
     |     |     +--rw vim-network-name?            string
     |     |     +--rw ip-profile
     |     |     |  +--rw ip-version?        inet:ip-version
     |     |     |  +--rw subnet-address?    inet:ip-prefix
     |     |     |  +--rw gateway-address?   inet:ip-prefix
     |     |     |  +--rw dns-server* [address]
     |     |     |  |  +--rw address    inet:ip-address
     |     |     |  +--rw dhcp-params
     |     |     |     +--rw enabled?         boolean
     |     |     |     +--rw count?           uint8
     |     |     |     +--rw start-address?   inet:ip-address
     |     |     +--rw internal-connection-point* [id-ref]
     |     |        +--rw id-ref        string
     |     |        +--rw ip-address?   inet:ip-address
     |     +--rw vld* [name]
     |        +--rw name                         string
     |        +--rw vim-network-name?            string
     |        +--rw ip-profile
     |        |  +--rw ip-version?        inet:ip-version
     |        |  +--rw subnet-address?    inet:ip-prefix
     |        |  +--rw gateway-address?   inet:ip-prefix
     |        |  +--rw dns-server* [address]
     |        |  |  +--rw address    inet:ip-address
     |        |  +--rw dhcp-params
     |        |     +--rw enabled?         boolean
     |        |     +--rw count?           uint8
     |        |     +--rw start-address?   inet:ip-address
     |        +--rw vnfd-connection-point-ref* [member-vnf-index-ref vnfd-connection-point-ref]
     |           +--rw member-vnf-index-ref         -> /nsd:nsd-catalog/nsd/constituent-vnfd/member-vnf-index
     |           +--rw vnfd-connection-point-ref    -> /vnfd:vnfd-catalog/vnfd/connection-point/name
     |           +--rw ip-address?                  inet:ip-address
     +--rw netslice-connection-point* [name]
     |  +--rw name                              string
     |  +--rw floating-ip-required?             boolean
     |  +--rw (connection)?
     |     +--:(netslice-vld-ref)
     |     |  +--rw netslice-vld-id-ref?        -> ../../netslice-vld/id
     |     +--:(nsd-connection-point-ref)
     |        +--rw nsd-id-ref?                 -> /nsd:nsd-catalog/nsd/id
     |        +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
     +--rw netslice-vld* [id]
     |  +--rw id                          string
     |  +--rw name?                       string
     |  +--rw short-name?                 string
     |  +--rw vendor?                     string
     |  +--rw description?                string
     |  +--rw version?                    string
     |  +--rw type?                       manotypes:virtual-link-type
     |  +--rw root-bandwidth?             uint64
     |  +--rw leaf-bandwidth?             uint64
     |  +--rw provider-network
     |  |  +--rw physical-network?   string
     |  |  +--rw segmentation_id?    uint32
     |  +--rw mgmt-network?               boolean
     |  +--rw nss-connection-point-ref* [nss-ref nsd-connection-point-ref]
     |     +--rw nss-ref                     -> /nst/netslice-subnet/id
     |     +--rw nsd-connection-point-ref    -> /nsd:nsd-catalog/nsd/connection-point/name
     |     +--rw ip-address?                 inet:ip-address
     +--rw netslicefgd* [id]
        +--rw id             string
        +--rw name?          string
        +--rw short-name?    string
        +--rw vendor?        string
        +--rw description?   string
        +--rw version?       string
        +--rw rsp* [id]
        |  +--rw id                          string
        |  +--rw name?                       string
        |  +--rw nsd-connection-point-ref* [nsd-ref]
        |     +--rw nsd-ref                     -> /nsd:nsd-catalog/nsd/id
        |     +--rw order?                      uint8
        |     +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
        +--rw classifier* [id]
           +--rw id                          string
           +--rw name?                       string
           +--rw rsp-id-ref?                 -> ../../rsp/id
           +--rw match-attributes* [id]
           |  +--rw id                        string
           |  +--rw ip-proto?                 uint8
           |  +--rw source-ip-address?        inet:ip-address
           |  +--rw destination-ip-address?   inet:ip-address
           |  +--rw source-port?              inet:port-number
           |  +--rw destination-port?         inet:port-number
           +--rw nsd-ref?                    -> /nsd:nsd-catalog/nsd/id
           +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
```

### VNFR tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/vnfr.html>**

**Plain text version:**

```text
module: vnfr
  augment /osm-project:project:
    +--ro vnfr-catalog
       +--ro schema-version?   string
       +--ro vnfr* [id]
          +--ro id                       yang:uuid
          +--ro nsr-id-ref?              yang:uuid
          +--ro member-vnf-index-ref?    -> ../../../project-nsd:nsd-catalog/nsd/constituent-vnfd/member-vnf-index
          +--ro dashboard-url?           inet:uri
          +--ro name?                    string
          +--ro short-name?              string
          +--ro vendor?                  string
          +--ro description?             string
          +--ro version?                 string
          +--ro create-time?             uint32
          +--ro uptime?                  uint32
          +--ro vnfd
          |  +--ro id?                         string
          |  +--ro name                        string
          |  +--ro short-name?                 string
          |  +--ro vendor?                     string
          |  +--ro logo?                       string
          |  +--ro description?                string
          |  +--ro version?                    string
          |  +--ro vnf-configuration
          |  |  +--ro (config-method)?
          |  |  |  +--:(script)
          |  |  |  |  +--ro script
          |  |  |  |     +--ro script-type?   enumeration
          |  |  |  +--:(juju)
          |  |  |     +--ro juju
          |  |  |        +--ro charm?               string
          |  |  |        +--ro proxy?               boolean
          |  |  |        +--ro vca-relationships
          |  |  |           +--ro relation* [requires provides]
          |  |  |              +--ro requires    string
          |  |  |              +--ro provides    string
          |  |  +--ro config-primitive* [name]
          |  |  |  +--ro name                   string
          |  |  |  +--ro parameter* [name]
          |  |  |  |  +--ro name              string
          |  |  |  |  +--ro data-type?        manotypes:parameter-data-type
          |  |  |  |  +--ro mandatory?        boolean
          |  |  |  |  +--ro default-value?    string
          |  |  |  |  +--ro parameter-pool?   string
          |  |  |  |  +--ro read-only?        boolean
          |  |  |  |  +--ro hidden?           boolean
          |  |  |  +--ro user-defined-script?   string
          |  |  +--ro initial-config-primitive* [seq]
          |  |  |  +--ro seq                          uint64
          |  |  |  +--ro (primitive-type)?
          |  |  |     +--:(primitive-definition)
          |  |  |        +--ro name?                  string
          |  |  |        +--ro parameter* [name]
          |  |  |        |  +--ro name         string
          |  |  |        |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |        |  +--ro value?       string
          |  |  |        +--ro user-defined-script?   string
          |  |  +--ro terminate-config-primitive* [seq]
          |  |  |  +--ro seq                    uint64
          |  |  |  +--ro name?                  string
          |  |  |  +--ro parameter* [name]
          |  |  |  |  +--ro name         string
          |  |  |  |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  |  +--ro value?       string
          |  |  |  +--ro user-defined-script?   string
          |  |  +--ro metrics* [name]
          |  |  |  +--ro name    string
          |  |  +--ro config-access
          |  |     +--ro ssh-access
          |  |        +--ro required?       boolean
          |  |        +--ro default-user?   string
          |  +--ro operational-status?         vnf-operational-status
          |  +--ro mgmt-interface
          |  |  +--ro (endpoint-type)?
          |  |  |  +--:(ip)
          |  |  |  |  +--ro ip-address?   inet:ip-address
          |  |  |  +--:(vdu-id)
          |  |  |  |  +--ro vdu-id?       -> ../../vdu/id
          |  |  |  +--:(cp)
          |  |  |     +--ro cp?           -> ../../connection-point/name
          |  |  +--ro port?               inet:port-number
          |  |  +--ro dashboard-params
          |  |     +--ro path?    string
          |  |     +--ro https?   boolean
          |  |     +--ro port?    inet:port-number
          |  +--ro internal-vld* [id]
          |  |  +--ro id                           string
          |  |  +--ro name?                        string
          |  |  +--ro short-name?                  string
          |  |  +--ro description?                 string
          |  |  +--ro type?                        manotypes:virtual-link-type
          |  |  +--ro root-bandwidth?              uint64
          |  |  +--ro leaf-bandwidth?              uint64
          |  |  +--ro internal-connection-point* [id-ref]
          |  |  |  +--ro id-ref        -> ../../../vdu/internal-connection-point/id
          |  |  |  +--ro ip-address?   inet:ip-address
          |  |  +--ro provider-network
          |  |  |  +--ro physical-network?   string
          |  |  |  +--ro segmentation_id?    uint32
          |  |  +--ro (init-params)?
          |  |     +--:(vim-network-ref)
          |  |     |  +--ro vim-network-name?      string
          |  |     +--:(vim-network-profile)
          |  |        +--ro ip-profile-ref?        string
          |  +--ro ip-profiles* [name]
          |  |  +--ro name                 string
          |  |  +--ro description?         string
          |  |  +--ro ip-profile-params
          |  |     +--ro ip-version?           inet:ip-version
          |  |     +--ro subnet-address?       inet:ip-prefix
          |  |     +--ro gateway-address?      inet:ip-address
          |  |     +--ro security-group?       string
          |  |     +--ro dns-server* [address]
          |  |     |  +--ro address    inet:ip-address
          |  |     +--ro dhcp-params
          |  |     |  +--ro enabled?         boolean
          |  |     |  +--ro start-address?   inet:ip-address
          |  |     |  +--ro count?           uint32
          |  |     +--ro subnet-prefix-pool?   string
          |  +--ro connection-point* [name]
          |  |  +--ro name                     string
          |  |  +--ro id?                      string
          |  |  +--ro short-name?              string
          |  |  +--ro type?                    manotypes:connection-point-type
          |  |  +--ro port-security-enabled?   boolean
          |  |  +--ro internal-vld-ref?        -> ../../internal-vld/id
          |  +--ro vdu* [id]
          |  |  +--ro id                           string
          |  |  +--ro name?                        string
          |  |  +--ro description?                 string
          |  |  +--ro pdu-type?                    string
          |  |  +--ro count?                       uint64
          |  |  +--ro mgmt-vpci?                   string
          |  |  +--ro vm-flavor
          |  |  |  +--ro vcpu-count?   uint16
          |  |  |  +--ro memory-mb?    uint64
          |  |  |  +--ro storage-gb?   uint64
          |  |  +--ro guest-epa
          |  |  |  +--ro trusted-execution?                 boolean
          |  |  |  +--ro mempage-size?                      enumeration
          |  |  |  +--ro (cpu-policy)?
          |  |  |  |  +--:(cpu-pinning)
          |  |  |  |  |  +--ro cpu-pinning-policy?          enumeration
          |  |  |  |  |  +--ro cpu-thread-pinning-policy?   enumeration
          |  |  |  |  +--:(cpu-quota)
          |  |  |  |     +--ro cpu-quota
          |  |  |  |        +--ro limit?     uint64
          |  |  |  |        +--ro reserve?   uint64
          |  |  |  |        +--ro shares?    uint64
          |  |  |  +--ro mem-quota
          |  |  |  |  +--ro limit?     uint64
          |  |  |  |  +--ro reserve?   uint64
          |  |  |  |  +--ro shares?    uint64
          |  |  |  +--ro disk-io-quota
          |  |  |  |  +--ro limit?     uint64
          |  |  |  |  +--ro reserve?   uint64
          |  |  |  |  +--ro shares?    uint64
          |  |  |  +--ro vif-quota
          |  |  |  |  +--ro limit?     uint64
          |  |  |  |  +--ro reserve?   uint64
          |  |  |  |  +--ro shares?    uint64
          |  |  |  +--ro pcie-device* [device-id]
          |  |  |  |  +--ro device-id    string
          |  |  |  |  +--ro count?       uint64
          |  |  |  +--ro (numa-policy)?
          |  |  |     +--:(numa-unaware)
          |  |  |     |  +--ro numa-unaware?                empty
          |  |  |     +--:(numa-aware)
          |  |  |        +--ro numa-node-policy
          |  |  |           +--ro node-cnt?     uint16
          |  |  |           +--ro mem-policy?   enumeration
          |  |  |           +--ro node* [id]
          |  |  |              +--ro id                      uint64
          |  |  |              +--ro vcpu* [id]
          |  |  |              |  +--ro id    uint64
          |  |  |              +--ro memory-mb?              uint64
          |  |  |              +--ro (om-numa-type)?
          |  |  |                 +--:(cores)
          |  |  |                 |  +--ro num-cores?        uint8
          |  |  |                 +--:(paired-threads)
          |  |  |                 |  +--ro paired-threads
          |  |  |                 |     +--ro num-paired-threads?   uint8
          |  |  |                 |     +--ro paired-thread-ids* [thread-a]
          |  |  |                 |        +--ro thread-a    uint8
          |  |  |                 |        +--ro thread-b?   uint8
          |  |  |                 +--:(threads)
          |  |  |                    +--ro num-threads?      uint8
          |  |  +--ro vswitch-epa
          |  |  |  +--ro ovs-acceleration?   enumeration
          |  |  |  +--ro ovs-offload?        enumeration
          |  |  +--ro hypervisor-epa
          |  |  |  +--ro type?      enumeration
          |  |  |  +--ro version?   string
          |  |  +--ro host-epa
          |  |  |  +--ro cpu-model?               enumeration
          |  |  |  +--ro cpu-arch?                enumeration
          |  |  |  +--ro cpu-vendor?              enumeration
          |  |  |  +--ro cpu-socket-count?        uint64
          |  |  |  +--ro cpu-core-count?          uint64
          |  |  |  +--ro cpu-core-thread-count?   uint64
          |  |  |  +--ro cpu-feature* [feature]
          |  |  |  |  +--ro feature    cpu-feature-type
          |  |  |  +--ro om-cpu-model-string?     string
          |  |  |  +--ro om-cpu-feature* [feature]
          |  |  |     +--ro feature    string
          |  |  +--ro alarm* [alarm-id]
          |  |  |  +--ro alarm-id                    string
          |  |  |  +--ro vnf-monitoring-param-ref?   -> ../../monitoring-param/id
          |  |  |  +--ro name?                       string
          |  |  |  +--ro description?                string
          |  |  |  +--ro vdur-id?                    string
          |  |  |  +--ro actions
          |  |  |  |  +--ro ok* [url]
          |  |  |  |  |  +--ro url    string
          |  |  |  |  +--ro insufficient-data* [url]
          |  |  |  |  |  +--ro url    string
          |  |  |  |  +--ro alarm* [url]
          |  |  |  |     +--ro url    string
          |  |  |  +--ro repeat?                     boolean
          |  |  |  +--ro enabled?                    boolean
          |  |  |  +--ro severity?                   alarm-severity-type
          |  |  |  +--ro statistic?                  alarm-statistic-type
          |  |  |  +--ro operation?                  relational-operation-type
          |  |  |  +--ro value?                      decimal64
          |  |  |  +--ro period?                     uint32
          |  |  |  +--ro evaluations?                uint32
          |  |  +--ro image?                       string
          |  |  +--ro image-checksum?              string
          |  |  +--ro alternative-images* [vim-type]
          |  |  |  +--ro vim-type          string
          |  |  |  +--ro image?            string
          |  |  |  +--ro image-checksum?   string
          |  |  +--ro vdu-configuration
          |  |  |  +--ro (config-method)?
          |  |  |  |  +--:(script)
          |  |  |  |  |  +--ro script
          |  |  |  |  |     +--ro script-type?   enumeration
          |  |  |  |  +--:(juju)
          |  |  |  |     +--ro juju
          |  |  |  |        +--ro charm?               string
          |  |  |  |        +--ro proxy?               boolean
          |  |  |  |        +--ro vca-relationships
          |  |  |  |           +--ro relation* [requires provides]
          |  |  |  |              +--ro requires    string
          |  |  |  |              +--ro provides    string
          |  |  |  +--ro config-primitive* [name]
          |  |  |  |  +--ro name                   string
          |  |  |  |  +--ro parameter* [name]
          |  |  |  |  |  +--ro name              string
          |  |  |  |  |  +--ro data-type?        manotypes:parameter-data-type
          |  |  |  |  |  +--ro mandatory?        boolean
          |  |  |  |  |  +--ro default-value?    string
          |  |  |  |  |  +--ro parameter-pool?   string
          |  |  |  |  |  +--ro read-only?        boolean
          |  |  |  |  |  +--ro hidden?           boolean
          |  |  |  |  +--ro user-defined-script?   string
          |  |  |  +--ro initial-config-primitive* [seq]
          |  |  |  |  +--ro seq                          uint64
          |  |  |  |  +--ro (primitive-type)?
          |  |  |  |     +--:(primitive-definition)
          |  |  |  |        +--ro name?                  string
          |  |  |  |        +--ro parameter* [name]
          |  |  |  |        |  +--ro name         string
          |  |  |  |        |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  |        |  +--ro value?       string
          |  |  |  |        +--ro user-defined-script?   string
          |  |  |  +--ro terminate-config-primitive* [seq]
          |  |  |  |  +--ro seq                    uint64
          |  |  |  |  +--ro name?                  string
          |  |  |  |  +--ro parameter* [name]
          |  |  |  |  |  +--ro name         string
          |  |  |  |  |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  |  |  +--ro value?       string
          |  |  |  |  +--ro user-defined-script?   string
          |  |  |  +--ro metrics* [name]
          |  |  |  |  +--ro name    string
          |  |  |  +--ro config-access
          |  |  |     +--ro ssh-access
          |  |  |        +--ro required?       boolean
          |  |  |        +--ro default-user?   string
          |  |  +--ro monitoring-param* [id]
          |  |  |  +--ro id                    string
          |  |  |  +--ro nfvi-metric?          manotypes:nfvi-metric-type
          |  |  |  +--ro interface-name-ref?   -> ../../interface/name
          |  |  +--ro (cloud-init-input)?
          |  |  |  +--:(inline)
          |  |  |  |  +--ro cloud-init?            string
          |  |  |  +--:(filename)
          |  |  |     +--ro cloud-init-file?       string
          |  |  +--ro supplemental-boot-data
          |  |  |  +--ro boot-data-drive?   boolean
          |  |  +--ro internal-connection-point* [id]
          |  |  |  +--ro name?                    string
          |  |  |  +--ro id                       string
          |  |  |  +--ro short-name?              string
          |  |  |  +--ro type?                    manotypes:connection-point-type
          |  |  |  +--ro port-security-enabled?   boolean
          |  |  |  +--ro internal-vld-ref?        -> ../../../internal-vld/id
          |  |  +--ro interface* [name]
          |  |  |  +--ro name                                   string
          |  |  |  +--ro position?                              uint32
          |  |  |  +--ro mgmt-interface?                        boolean
          |  |  |  +--ro type?                                  interface-type
          |  |  |  +--ro mac-address?                           string
          |  |  |  +--ro (connection-point-type)?
          |  |  |  |  +--:(internal)
          |  |  |  |  |  +--ro internal-connection-point-ref?   -> ../../internal-connection-point/id
          |  |  |  |  +--:(external)
          |  |  |  |     +--ro external-connection-point-ref?   -> ../../../connection-point/name
          |  |  |  +--ro virtual-interface
          |  |  |     +--ro type?        enumeration
          |  |  |     +--ro vpci?        string
          |  |  |     +--ro bandwidth?   uint64
          |  |  +--ro volumes* [name]
          |  |     +--ro name                    string
          |  |     +--ro description?            string
          |  |     +--ro size?                   uint64
          |  |     +--ro (volume-source)?
          |  |     |  +--:(ephemeral)
          |  |     |  |  +--ro ephemeral?        empty
          |  |     |  +--:(image)
          |  |     |     +--ro image?            string
          |  |     |     +--ro image-checksum?   string
          |  |     +--ro device-bus?             enumeration
          |  |     +--ro device-type?            enumeration
          |  +--ro vdu-dependency* [vdu-source-ref]
          |  |  +--ro vdu-source-ref        -> ../../vdu/id
          |  |  +--ro vdu-depends-on-ref?   -> ../../vdu/id
          |  +--ro service-function-chain?     enumeration
          |  +--ro service-function-type?      string
          |  +--ro http-endpoint* [path]
          |  |  +--ro path                     string
          |  |  +--ro https?                   boolean
          |  |  +--ro port?                    inet:port-number
          |  |  +--ro username?                string
          |  |  +--ro password?                string
          |  |  +--ro polling-interval-secs?   uint8
          |  |  +--ro method?                  manotypes:http-method
          |  |  +--ro headers* [key]
          |  |     +--ro key      string
          |  |     +--ro value?   string
          |  +--ro scaling-group-descriptor* [name]
          |  |  +--ro name                     string
          |  |  +--ro scaling-policy* [name]
          |  |  |  +--ro name                        string
          |  |  |  +--ro scaling-type?               manotypes:scaling-policy-type
          |  |  |  +--ro enabled?                    boolean
          |  |  |  +--ro scale-in-operation-type?    manotypes:scaling-criteria-operation
          |  |  |  +--ro scale-out-operation-type?   manotypes:scaling-criteria-operation
          |  |  |  +--ro threshold-time              uint32
          |  |  |  +--ro cooldown-time               uint32
          |  |  |  +--ro scaling-criteria* [name]
          |  |  |     +--ro name                              string
          |  |  |     +--ro scale-in-threshold?               decimal64
          |  |  |     +--ro scale-in-relational-operation?    manotypes:relational-operation-type
          |  |  |     +--ro scale-out-threshold?              decimal64
          |  |  |     +--ro scale-out-relational-operation?   manotypes:relational-operation-type
          |  |  |     +--ro vnf-monitoring-param-ref?         -> ../../../../monitoring-param/id
          |  |  +--ro vdu* [vdu-id-ref]
          |  |  |  +--ro vdu-id-ref    -> ../../../vdu/id
          |  |  |  +--ro count?        uint32
          |  |  +--ro min-instance-count?      uint32
          |  |  +--ro max-instance-count?      uint32
          |  |  +--ro scaling-config-action* [trigger]
          |  |     +--ro trigger                          manotypes:scaling-trigger
          |  |     +--ro vnf-config-primitive-name-ref?   -> ../../../vnf-configuration/config-primitive/name
          |  +--ro monitoring-param* [id]
          |  |  +--ro id                            string
          |  |  +--ro name?                         string
          |  |  +--ro aggregation-type?             aggregation-type
          |  |  +--ro (monitoring-type)?
          |  |  |  +--:(vdu-monitoring-param)
          |  |  |  |  +--ro vdu-monitoring-param
          |  |  |  |     +--ro vdu-ref?                    -> ../../../vdu/id
          |  |  |  |     +--ro vdu-monitoring-param-ref?   -> ../../../vdu[id = current()/../vdu-ref]/monitoring-param/id
          |  |  |  +--:(vnf-metric)
          |  |  |  |  +--ro vnf-metric
          |  |  |  |     +--ro vnf-metric-name-ref?   -> ../../../vnf-configuration/metrics/name
          |  |  |  +--:(vdu-metric)
          |  |  |     +--ro vdu-metric
          |  |  |        +--ro vdu-ref?               -> ../../../vdu/id
          |  |  |        +--ro vdu-metric-name-ref?   -> ../../../vdu[id = current()/../vdu-ref]/vdu-configuration/metrics/name
          |  |  +--ro http-endpoint-ref?            -> ../../http-endpoint/path
          |  |  +--ro json-query-method?            manotypes:json-query-method
          |  |  +--ro json-query-params
          |  |  |  +--ro json-path?     string
          |  |  |  +--ro object-path?   string
          |  |  +--ro description?                  string
          |  |  +--ro group-tag?                    string
          |  |  +--ro widget-type?                  manotypes:widget-type
          |  |  +--ro units?                        string
          |  |  +--ro value-type?                   param-value-type
          |  |  +--ro numeric-constraints
          |  |  |  +--ro min-value?   uint64
          |  |  |  +--ro max-value?   uint64
          |  |  +--ro text-constraints
          |  |  |  +--ro min-length?   uint8
          |  |  |  +--ro max-length?   uint8
          |  |  +--ro value-integer?                int64
          |  |  +--ro value-decimal?                decimal64
          |  |  +--ro value-string?                 string
          |  +--ro placement-groups* [name]
          |     +--ro name           string
          |     +--ro requirement?   string
          |     +--ro strategy?      enumeration
          |     +--ro member-vdus* [member-vdu-ref]
          |        +--ro member-vdu-ref    -> ../../../vdu/id
          +--ro vnfd-ref?                -> ../../../project-vnfd:vnfd-catalog/vnfd/id
          +--ro vnf-configuration
          |  +--ro (config-method)?
          |  |  +--:(script)
          |  |  |  +--ro script
          |  |  |     +--ro script-type?   enumeration
          |  |  +--:(juju)
          |  |     +--ro juju
          |  |        +--ro charm?               string
          |  |        +--ro proxy?               boolean
          |  |        +--ro vca-relationships
          |  |           +--ro relation* [requires provides]
          |  |              +--ro requires    string
          |  |              +--ro provides    string
          |  +--ro config-primitive* [name]
          |  |  +--ro name                   string
          |  |  +--ro parameter* [name]
          |  |  |  +--ro name              string
          |  |  |  +--ro data-type?        manotypes:parameter-data-type
          |  |  |  +--ro mandatory?        boolean
          |  |  |  +--ro default-value?    string
          |  |  |  +--ro parameter-pool?   string
          |  |  |  +--ro read-only?        boolean
          |  |  |  +--ro hidden?           boolean
          |  |  +--ro user-defined-script?   string
          |  +--ro initial-config-primitive* [seq]
          |  |  +--ro seq                          uint64
          |  |  +--ro (primitive-type)?
          |  |     +--:(primitive-definition)
          |  |        +--ro name?                  string
          |  |        +--ro parameter* [name]
          |  |        |  +--ro name         string
          |  |        |  +--ro data-type?   manotypes:parameter-data-type
          |  |        |  +--ro value?       string
          |  |        +--ro user-defined-script?   string
          |  +--ro terminate-config-primitive* [seq]
          |  |  +--ro seq                    uint64
          |  |  +--ro name?                  string
          |  |  +--ro parameter* [name]
          |  |  |  +--ro name         string
          |  |  |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  +--ro value?       string
          |  |  +--ro user-defined-script?   string
          |  +--ro metrics* [name]
          |     +--ro name    string
          +--ro mgmt-interface
          |  +--ro ip-address?   inet:ip-address
          |  +--ro port?         inet:port-number
          |  +--ro ssh-key
          |     +--ro public-key?         string
          |     +--ro private-key-file?   string
          +--ro internal-vlr* [vlr-ref]
          |  +--ro vlr-ref                          -> ../../../../vlr:vlr-catalog/vlr/id
          |  +--ro internal-connection-point-ref*   -> ../../vdur/internal-connection-point/id
          +--ro connection-point* [name]
          |  +--ro name                     string
          |  +--ro id?                      string
          |  +--ro short-name?              string
          |  +--ro type?                    manotypes:connection-point-type
          |  +--ro port-security-enabled?   boolean
          |  +--ro vlr-ref?                 -> ../../../../vlr:vlr-catalog/vlr/id
          |  +--ro ip-address?              inet:ip-address
          |  +--ro mac-address?             string
          |  +--ro connection-point-id?     string
          |  +--ro virtual-cps* [name]
          |     +--ro name                     string
          |     +--ro id?                      string
          |     +--ro short-name?              string
          |     +--ro type?                    manotypes:connection-point-type
          |     +--ro port-security-enabled?   boolean
          |     +--ro ip-address?              inet:ip-address
          |     +--ro mac-address?             string
          |     +--ro connection-point-id?     string
          +--ro vdur* [id]
          |  +--ro id                           yang:uuid
          |  +--ro name?                        string
          |  +--ro unique-short-name?           string
          |  +--ro vdu-id-ref?                  -> ../../vnfd/vdu/id
          |  +--ro vim-id?                      string
          |  +--ro flavor-id?                   string
          |  +--ro image-id?                    string
          |  +--ro management-ip?               inet:ip-address
          |  +--ro vm-management-ip?            inet:ip-address
          |  +--ro console-url?                 inet:uri
          |  +--ro vm-flavor
          |  |  +--ro vcpu-count?   uint16
          |  |  +--ro memory-mb?    uint64
          |  |  +--ro storage-gb?   uint64
          |  +--ro guest-epa
          |  |  +--ro trusted-execution?                 boolean
          |  |  +--ro mempage-size?                      enumeration
          |  |  +--ro (cpu-policy)?
          |  |  |  +--:(cpu-pinning)
          |  |  |  |  +--ro cpu-pinning-policy?          enumeration
          |  |  |  |  +--ro cpu-thread-pinning-policy?   enumeration
          |  |  |  +--:(cpu-quota)
          |  |  |     +--ro cpu-quota
          |  |  |        +--ro limit?     uint64
          |  |  |        +--ro reserve?   uint64
          |  |  |        +--ro shares?    uint64
          |  |  +--ro mem-quota
          |  |  |  +--ro limit?     uint64
          |  |  |  +--ro reserve?   uint64
          |  |  |  +--ro shares?    uint64
          |  |  +--ro disk-io-quota
          |  |  |  +--ro limit?     uint64
          |  |  |  +--ro reserve?   uint64
          |  |  |  +--ro shares?    uint64
          |  |  +--ro vif-quota
          |  |  |  +--ro limit?     uint64
          |  |  |  +--ro reserve?   uint64
          |  |  |  +--ro shares?    uint64
          |  |  +--ro pcie-device* [device-id]
          |  |  |  +--ro device-id    string
          |  |  |  +--ro count?       uint64
          |  |  +--ro (numa-policy)?
          |  |     +--:(numa-unaware)
          |  |     |  +--ro numa-unaware?                empty
          |  |     +--:(numa-aware)
          |  |        +--ro numa-node-policy
          |  |           +--ro node-cnt?     uint16
          |  |           +--ro mem-policy?   enumeration
          |  |           +--ro node* [id]
          |  |              +--ro id                      uint64
          |  |              +--ro vcpu* [id]
          |  |              |  +--ro id    uint64
          |  |              +--ro memory-mb?              uint64
          |  |              +--ro (om-numa-type)?
          |  |                 +--:(cores)
          |  |                 |  +--ro num-cores?        uint8
          |  |                 +--:(paired-threads)
          |  |                 |  +--ro paired-threads
          |  |                 |     +--ro num-paired-threads?   uint8
          |  |                 |     +--ro paired-thread-ids* [thread-a]
          |  |                 |        +--ro thread-a    uint8
          |  |                 |        +--ro thread-b?   uint8
          |  |                 +--:(threads)
          |  |                    +--ro num-threads?      uint8
          |  +--ro vswitch-epa
          |  |  +--ro ovs-acceleration?   enumeration
          |  |  +--ro ovs-offload?        enumeration
          |  +--ro hypervisor-epa
          |  |  +--ro type?      enumeration
          |  |  +--ro version?   string
          |  +--ro host-epa
          |  |  +--ro cpu-model?               enumeration
          |  |  +--ro cpu-arch?                enumeration
          |  |  +--ro cpu-vendor?              enumeration
          |  |  +--ro cpu-socket-count?        uint64
          |  |  +--ro cpu-core-count?          uint64
          |  |  +--ro cpu-core-thread-count?   uint64
          |  |  +--ro cpu-feature* [feature]
          |  |  |  +--ro feature    cpu-feature-type
          |  |  +--ro om-cpu-model-string?     string
          |  |  +--ro om-cpu-feature* [feature]
          |  |     +--ro feature    string
          |  +--ro supplemental-boot-data
          |  |  +--ro boot-data-drive?   boolean
          |  +--ro vdu-configuration
          |  |  +--ro (config-method)?
          |  |  |  +--:(script)
          |  |  |  |  +--ro script
          |  |  |  |     +--ro script-type?   enumeration
          |  |  |  +--:(juju)
          |  |  |     +--ro juju
          |  |  |        +--ro charm?               string
          |  |  |        +--ro proxy?               boolean
          |  |  |        +--ro vca-relationships
          |  |  |           +--ro relation* [requires provides]
          |  |  |              +--ro requires    string
          |  |  |              +--ro provides    string
          |  |  +--ro config-primitive* [name]
          |  |  |  +--ro name                   string
          |  |  |  +--ro parameter* [name]
          |  |  |  |  +--ro name              string
          |  |  |  |  +--ro data-type?        manotypes:parameter-data-type
          |  |  |  |  +--ro mandatory?        boolean
          |  |  |  |  +--ro default-value?    string
          |  |  |  |  +--ro parameter-pool?   string
          |  |  |  |  +--ro read-only?        boolean
          |  |  |  |  +--ro hidden?           boolean
          |  |  |  +--ro user-defined-script?   string
          |  |  +--ro initial-config-primitive* [seq]
          |  |  |  +--ro seq                          uint64
          |  |  |  +--ro (primitive-type)?
          |  |  |     +--:(primitive-definition)
          |  |  |        +--ro name?                  string
          |  |  |        +--ro parameter* [name]
          |  |  |        |  +--ro name         string
          |  |  |        |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |        |  +--ro value?       string
          |  |  |        +--ro user-defined-script?   string
          |  |  +--ro terminate-config-primitive* [seq]
          |  |  |  +--ro seq                    uint64
          |  |  |  +--ro name?                  string
          |  |  |  +--ro parameter* [name]
          |  |  |  |  +--ro name         string
          |  |  |  |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  |  +--ro value?       string
          |  |  |  +--ro user-defined-script?   string
          |  |  +--ro metrics* [name]
          |  |     +--ro name    string
          |  +--ro monitoring-param* [id]
          |  |  +--ro id                    string
          |  |  +--ro nfvi-metric?          manotypes:nfvi-metric-type
          |  |  +--ro interface-name-ref?   -> ../../interface/name
          |  +--ro volumes* [name]
          |  |  +--ro name                    string
          |  |  +--ro volume-id?              string
          |  |  +--ro description?            string
          |  |  +--ro size?                   uint64
          |  |  +--ro (volume-source)?
          |  |  |  +--:(ephemeral)
          |  |  |  |  +--ro ephemeral?        empty
          |  |  |  +--:(image)
          |  |  |     +--ro image?            string
          |  |  |     +--ro image-checksum?   string
          |  |  +--ro device-bus?             enumeration
          |  |  +--ro device-type?            enumeration
          |  +--ro internal-connection-point* [id]
          |  |  +--ro name?                    string
          |  |  +--ro id                       string
          |  |  +--ro short-name?              string
          |  |  +--ro type?                    manotypes:connection-point-type
          |  |  +--ro port-security-enabled?   boolean
          |  |  +--ro ip-address?              inet:ip-address
          |  |  +--ro mac-address?             string
          |  |  +--ro connection-point-id?     string
          |  |  +--ro virtual-cps* [name]
          |  |     +--ro name                     string
          |  |     +--ro id?                      string
          |  |     +--ro short-name?              string
          |  |     +--ro type?                    manotypes:connection-point-type
          |  |     +--ro port-security-enabled?   boolean
          |  |     +--ro ip-address?              inet:ip-address
          |  |     +--ro mac-address?             string
          |  |     +--ro connection-point-id?     string
          |  +--ro interface* [name]
          |  |  +--ro name                                   string
          |  |  +--ro position?                              uint32
          |  |  +--ro type?                                  vnfd-base:interface-type
          |  |  +--ro (connection-point-type)?
          |  |  |  +--:(internal)
          |  |  |  |  +--ro internal-connection-point-ref?   -> ../../internal-connection-point/id
          |  |  |  +--:(external)
          |  |  |     +--ro external-connection-point-ref?   -> ../../../connection-point/name
          |  |  +--ro virtual-interface
          |  |     +--ro type?                    enumeration
          |  |     +--ro bandwidth?               uint64
          |  |     +--ro ovs-offload?             enumeration
          |  |     +--ro vendor-id?               string
          |  |     +--ro datapath-library?        string
          |  |     +--ro provider-network-name?   string
          |  +--ro operational-status?          vdu-operational-status
          |  +--ro placement-groups-info* [name]
          |     +--ro name                        string
          |     +--ro requirement?                string
          |     +--ro strategy?                   enumeration
          |     +--ro cloud-type?                 manotypes:cloud-account-type
          |     +--ro (cloud-provider)?
          |        +--:(openstack)
          |        |  +--ro availability-zone
          |        |  |  +--ro name?   string
          |        |  +--ro server-group
          |        |  |  +--ro name?   string
          |        |  +--ro host-aggregate* [metadata-key]
          |        |     +--ro metadata-key      string
          |        |     +--ro metadata-value?   string
          |        +--:(aws)
          |        |  +--ro aws-construct?        empty
          |        +--:(openmano)
          |        |  +--ro openmano-construct?   empty
          |        +--:(vsphere)
          |        |  +--ro vsphere-construct?    empty
          |        +--:(mock)
          |        |  +--ro mock-construct?       empty
          |        +--:(cloudsim)
          |           +--ro cloudsim-construct?   empty
          +--ro monitoring-param* [id]
          |  +--ro id                            string
          |  +--ro name?                         string
          |  +--ro aggregation-type?             aggregation-type
          |  +--ro (monitoring-type)?
          |     +--:(vdu-monitoring-param)
          |     |  +--ro vdu-monitoring-param
          |     |     +--ro vdu-ref?                    -> ../../../vdur/id
          |     |     +--ro vdu-monitoring-param-ref?   -> ../../../vdur[id = current()/../vdu-ref]/monitoring-param/id
          |     +--:(vnf-metric)
          |     |  +--ro vnf-metric
          |     |     +--ro vnf-metric-name-ref?   -> ../../../vnf-configuration/metrics/name
          |     +--:(vdu-metric)
          |        +--ro vdu-metric
          |           +--ro vdu-ref?               -> ../../../vdur/id
          |           +--ro vdu-metric-name-ref?   -> ../../../vdur[id = current()/../vdu-ref]/vdu-configuration/metrics/name
          +--ro operational-status?      vnf-operational-status
          +--ro config-status?           enumeration
          +--ro placement-groups-info* [name]
          |  +--ro name                        string
          |  +--ro requirement?                string
          |  +--ro strategy?                   enumeration
          |  +--ro cloud-type?                 manotypes:cloud-account-type
          |  +--ro (cloud-provider)?
          |     +--:(openstack)
          |     |  +--ro availability-zone
          |     |  |  +--ro name?   string
          |     |  +--ro server-group
          |     |  |  +--ro name?   string
          |     |  +--ro host-aggregate* [metadata-key]
          |     |     +--ro metadata-key      string
          |     |     +--ro metadata-value?   string
          |     +--:(aws)
          |     |  +--ro aws-construct?        empty
          |     +--:(openmano)
          |     |  +--ro openmano-construct?   empty
          |     +--:(vsphere)
          |     |  +--ro vsphere-construct?    empty
          |     +--:(mock)
          |     |  +--ro mock-construct?       empty
          |     +--:(cloudsim)
          |        +--ro cloudsim-construct?   empty
          +--ro cloud-config
             +--ro key-pair* [name]
             |  +--ro name    string
             |  +--ro key?    string
             +--ro user* [name]
                +--ro name         string
                +--ro user-info?   string
                +--ro key-pair* [name]
                   +--ro name    string
                   +--ro key?    string
```

### NSR tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/nsr.html>**

**Plain text version:**

```text
module: nsr
  augment /osm-project:project:
    +--rw key-pair* [name]
       +--rw name    string
       +--rw key?    string
  augment /osm-project:project:
    +--rw ns-instance-config
       +--rw nsr* [id]
          +--rw schema-version?              string
          +--rw id                           yang:uuid
          +--rw name?                        string
          +--rw short-name?                  string
          +--rw description?                 string
          +--rw admin-status?                enumeration
          +--rw nsd
          |  +--rw id?                         string
          |  +--rw name                        string
          |  +--rw short-name?                 string
          |  +--rw vendor?                     string
          |  +--rw logo?                       string
          |  +--rw description?                string
          |  +--rw version?                    string
          |  +--rw connection-point* [name]
          |  |  +--rw name                               string
          |  |  +--rw floating-ip-required?              boolean
          |  |  +--rw type?                              manotypes:connection-point-type
          |  |  +--rw (connection)?
          |  |     +--:(vld-ref)
          |  |     |  +--rw vld-id-ref?                  -> ../../vld/id
          |  |     +--:(vnfd-connection-point-ref)
          |  |        +--rw member-vnf-index-ref?        -> ../../constituent-vnfd/member-vnf-index
          |  |        +--rw vnfd-id-ref?                 -> ../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
          |  |        +--rw vnfd-connection-point-ref?   -> /vnfd:vnfd-catalog/vnfd[vnfd:id = current()/../vnfd-id-ref]/connection-point/name
          |  +--rw scaling-group-descriptor* [name]
          |  |  +--rw name                     string
          |  |  +--rw scaling-policy* [name]
          |  |  |  +--rw name                        string
          |  |  |  +--rw scaling-type?               manotypes:scaling-policy-type
          |  |  |  +--rw enabled?                    boolean
          |  |  |  +--rw scale-in-operation-type?    manotypes:scaling-criteria-operation
          |  |  |  +--rw scale-out-operation-type?   manotypes:scaling-criteria-operation
          |  |  |  +--rw threshold-time              uint32
          |  |  |  +--rw cooldown-time               uint32
          |  |  |  +--rw scaling-criteria* [name]
          |  |  |     +--rw name                              string
          |  |  |     +--rw scale-in-threshold?               uint64
          |  |  |     +--rw scale-in-relational-operation?    manotypes:relational-operation-type
          |  |  |     +--rw scale-out-threshold?              uint64
          |  |  |     +--rw scale-out-relational-operation?   manotypes:relational-operation-type
          |  |  |     +--rw ns-monitoring-param-ref?          -> ../../../../monitoring-param/id
          |  |  +--rw vnfd-member* [member-vnf-index-ref]
          |  |  |  +--rw member-vnf-index-ref    -> ../../../constituent-vnfd/member-vnf-index
          |  |  |  +--rw count?                  uint32
          |  |  +--rw min-instance-count?      uint32
          |  |  +--rw max-instance-count?      uint32
          |  |  +--rw scaling-config-action* [trigger]
          |  |     +--rw trigger                         manotypes:scaling-trigger
          |  |     +--rw ns-config-primitive-name-ref?   -> ../../../ns-configuration/config-primitive/name
          |  +--rw vnffgd* [id]
          |  |  +--rw id             string
          |  |  +--rw name?          string
          |  |  +--rw short-name?    string
          |  |  +--rw vendor?        string
          |  |  +--rw description?   string
          |  |  +--rw version?       string
          |  |  +--rw rsp* [id]
          |  |  |  +--rw id                           string
          |  |  |  +--rw name?                        string
          |  |  |  +--rw vnfd-connection-point-ref* [member-vnf-index-ref]
          |  |  |     +--rw member-vnf-index-ref                 -> ../../../../constituent-vnfd/member-vnf-index
          |  |  |     +--rw order?                               uint8
          |  |  |     +--rw vnfd-id-ref?                         -> ../../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
          |  |  |     +--rw vnfd-ingress-connection-point-ref?   string
          |  |  |     +--rw vnfd-egress-connection-point-ref?    string
          |  |  +--rw classifier* [id]
          |  |     +--rw id                           string
          |  |     +--rw name?                        string
          |  |     +--rw rsp-id-ref?                  -> ../../rsp/id
          |  |     +--rw match-attributes* [id]
          |  |     |  +--rw id                        string
          |  |     |  +--rw ip-proto?                 uint8
          |  |     |  +--rw source-ip-address?        inet:ip-address
          |  |     |  +--rw destination-ip-address?   inet:ip-address
          |  |     |  +--rw source-port?              inet:port-number
          |  |     |  +--rw destination-port?         inet:port-number
          |  |     +--rw member-vnf-index-ref?        -> ../../../constituent-vnfd/member-vnf-index
          |  |     +--rw vnfd-id-ref?                 -> ../../../constituent-vnfd[member-vnf-index = current()/../member-vnf-index-ref]/vnfd-id-ref
          |  |     +--rw vnfd-connection-point-ref?   string
          |  +--rw ip-profiles* [name]
          |  |  +--rw name                 string
          |  |  +--rw description?         string
          |  |  +--rw ip-profile-params
          |  |     +--rw ip-version?           inet:ip-version
          |  |     +--rw subnet-address?       inet:ip-prefix
          |  |     +--rw gateway-address?      inet:ip-address
          |  |     +--rw security-group?       string
          |  |     +--rw dns-server* [address]
          |  |     |  +--rw address    inet:ip-address
          |  |     +--rw dhcp-params
          |  |     |  +--rw enabled?         boolean
          |  |     |  +--rw start-address?   inet:ip-address
          |  |     |  +--rw count?           uint32
          |  |     +--rw subnet-prefix-pool?   string
          |  +--rw ns-configuration
          |  |  +--rw (config-method)?
          |  |  |  +--:(script)
          |  |  |  |  +--rw script
          |  |  |  |     +--rw script-type?   enumeration
          |  |  |  +--:(juju)
          |  |  |     +--rw juju
          |  |  |        +--rw charm?               string
          |  |  |        +--rw proxy?               boolean
          |  |  |        +--rw vca-relationships
          |  |  |           +--rw relation* [requires provides]
          |  |  |              +--rw requires    string
          |  |  |              +--rw provides    string
          |  |  +--rw config-primitive* [name]
          |  |  |  +--rw name                   string
          |  |  |  +--rw parameter* [name]
          |  |  |  |  +--rw name              string
          |  |  |  |  +--rw data-type?        manotypes:parameter-data-type
          |  |  |  |  +--rw mandatory?        boolean
          |  |  |  |  +--rw default-value?    string
          |  |  |  |  +--rw parameter-pool?   string
          |  |  |  |  +--rw read-only?        boolean
          |  |  |  |  +--rw hidden?           boolean
          |  |  |  +--rw user-defined-script?   string
          |  |  +--rw initial-config-primitive* [seq]
          |  |  |  +--rw seq                          uint64
          |  |  |  +--rw (primitive-type)?
          |  |  |     +--:(primitive-definition)
          |  |  |        +--rw name?                  string
          |  |  |        +--rw parameter* [name]
          |  |  |        |  +--rw name         string
          |  |  |        |  +--rw data-type?   manotypes:parameter-data-type
          |  |  |        |  +--rw value?       string
          |  |  |        +--rw user-defined-script?   string
          |  |  +--rw terminate-config-primitive* [seq]
          |  |  |  +--rw seq                    uint64
          |  |  |  +--rw name?                  string
          |  |  |  +--rw parameter* [name]
          |  |  |  |  +--rw name         string
          |  |  |  |  +--rw data-type?   manotypes:parameter-data-type
          |  |  |  |  +--rw value?       string
          |  |  |  +--rw user-defined-script?   string
          |  |  +--rw metrics* [name]
          |  |     +--rw name    string
          |  +--rw input-parameter-xpath* [xpath]
          |  |  +--rw xpath            string
          |  |  +--rw label?           string
          |  |  +--rw default-value?   string
          |  +--rw parameter-pool* [name]
          |  |  +--rw name     string
          |  |  +--rw range
          |  |     +--rw start-value    uint32
          |  |     +--rw end-value      uint32
          |  +--rw key-pair* [name]
          |  |  +--rw name    string
          |  |  +--rw key?    string
          |  +--rw user* [name]
          |  |  +--rw name         string
          |  |  +--rw user-info?   string
          |  |  +--rw key-pair* [name]
          |  |     +--rw name    string
          |  |     +--rw key?    string
          |  +--rw vld* [id]
          |  |  +--rw id                           string
          |  |  +--rw name?                        string
          |  |  +--rw short-name?                  string
          |  |  +--rw vendor?                      string
          |  |  +--rw description?                 string
          |  |  +--rw version?                     string
          |  |  +--rw type?                        manotypes:virtual-link-type
          |  |  +--rw root-bandwidth?              uint64
          |  |  +--rw leaf-bandwidth?              uint64
          |  |  +--rw provider-network
          |  |  |  +--rw physical-network?   string
          |  |  |  +--rw segmentation_id?    uint32
          |  |  +--rw mgmt-network?                boolean
          |  |  +--rw (init-params)?
          |  |  |  +--:(vim-network-ref)
          |  |  |  |  +--rw vim-network-name?      string
          |  |  |  +--:(vim-network-profile)
          |  |  |     +--rw ip-profile-ref?        -> ../../ip-profiles/name
          |  |  +--rw vnfd-connection-point-ref* [member-vnf-index-ref vnfd-connection-point-ref]
          |  |     +--rw member-vnf-index-ref         -> ../../../constituent-vnfd/member-vnf-index
          |  |     +--rw vnfd-id-ref?                 string
          |  |     +--rw vnfd-connection-point-ref    -> ../../../../../../project-vnfd:vnfd-catalog/vnfd[project-vnfd:id = current()/../vnfd-id-ref]/connection-point/name
          |  +--rw constituent-vnfd* [member-vnf-index]
          |  |  +--rw member-vnf-index    string
          |  |  +--rw vnfd-id-ref?        -> /osm-project:project[osm-project:name = current()/../../../../../name]/project-vnfd:vnfd-catalog/vnfd/id
          |  |  +--rw start-by-default?   boolean
          |  +--rw placement-groups* [name]
          |  |  +--rw name           string
          |  |  +--rw requirement?   string
          |  |  +--rw strategy?      enumeration
          |  |  +--rw member-vnfd* [member-vnf-index-ref]
          |  |     +--rw member-vnf-index-ref    -> ../../../constituent-vnfd/member-vnf-index
          |  |     +--rw vnfd-id-ref?            -> ../../../../../../project-vnfd:vnfd-catalog/vnfd/id
          |  +--rw vnf-dependency* [vnf-source-ref]
          |  |  +--rw vnf-source-ref        -> ../../../../../project-vnfd:vnfd-catalog/vnfd/id
          |  |  +--rw vnf-depends-on-ref?   -> ../../../../../project-vnfd:vnfd-catalog/vnfd/id
          |  +--rw monitoring-param* [id]
          |     +--rw id                       string
          |     +--rw name?                    string
          |     +--rw value-type?              param-value-type
          |     +--rw numeric-constraints
          |     |  +--rw min-value?   uint64
          |     |  +--rw max-value?   uint64
          |     +--rw text-constraints
          |     |  +--rw min-length?   uint8
          |     |  +--rw max-length?   uint8
          |     +--rw value-integer?           int64
          |     +--rw value-decimal?           decimal64
          |     +--rw value-string?            string
          |     +--rw description?             string
          |     +--rw group-tag?               string
          |     +--rw widget-type?             manotypes:widget-type
          |     +--rw units?                   string
          |     +--rw aggregation-type?        aggregation-type
          |     +--rw vnfd-monitoring-param* [member-vnf-index-ref vnfd-monitoring-param-ref]
          |        +--rw vnfd-id-ref?                 string
          |        +--rw vnfd-monitoring-param-ref    -> ../../../../../../project-vnfd:vnfd-catalog/vnfd[project-vnfd:id = current()/../vnfd-id-ref]/monitoring-param/id
          |        +--rw member-vnf-index-ref         -> ../../../constituent-vnfd/member-vnf-index
          +--rw input-parameter* [xpath]
          |  +--rw xpath    string
          |  +--rw value?   string
          +--rw scaling-group* [scaling-group-name-ref]
          |  +--rw scaling-group-name-ref    string
          |  +--rw instance* [id]
          |     +--rw id    uint16
          +--rw nsd-placement-group-maps* [placement-group-ref]
          |  +--rw placement-group-ref         string
          |  +--rw cloud-type?                 manotypes:cloud-account-type
          |  +--rw (cloud-provider)?
          |     +--:(openstack)
          |     |  +--rw availability-zone
          |     |  |  +--rw name?   string
          |     |  +--rw server-group
          |     |  |  +--rw name?   string
          |     |  +--rw host-aggregate* [metadata-key]
          |     |     +--rw metadata-key      string
          |     |     +--rw metadata-value?   string
          |     +--:(aws)
          |     |  +--rw aws-construct?        empty
          |     +--:(openmano)
          |     |  +--rw openmano-construct?   empty
          |     +--:(vsphere)
          |     |  +--rw vsphere-construct?    empty
          |     +--:(mock)
          |     |  +--rw mock-construct?       empty
          |     +--:(cloudsim)
          |        +--rw cloudsim-construct?   empty
          +--rw vnfd-placement-group-maps* [placement-group-ref vnfd-id-ref]
          |  +--rw vnfd-id-ref                 yang:uuid
          |  +--rw placement-group-ref         -> ../../../../project-vnfd:vnfd-catalog/vnfd[project-vnfd:id = current()/../vnfd-id-ref]/placement-groups/name
          |  +--rw cloud-type?                 manotypes:cloud-account-type
          |  +--rw (cloud-provider)?
          |     +--:(openstack)
          |     |  +--rw availability-zone
          |     |  |  +--rw name?   string
          |     |  +--rw server-group
          |     |  |  +--rw name?   string
          |     |  +--rw host-aggregate* [metadata-key]
          |     |     +--rw metadata-key      string
          |     |     +--rw metadata-value?   string
          |     +--:(aws)
          |     |  +--rw aws-construct?        empty
          |     +--:(openmano)
          |     |  +--rw openmano-construct?   empty
          |     +--:(vsphere)
          |     |  +--rw vsphere-construct?    empty
          |     +--:(mock)
          |     |  +--rw mock-construct?       empty
          |     +--:(cloudsim)
          |        +--rw cloudsim-construct?   empty
          +--rw ssh-authorized-key* [key-pair-ref]
          |  +--rw key-pair-ref    -> ../../../../key-pair/name
          +--rw user* [name]
             +--rw name                  string
             +--rw user-info?            string
             +--rw ssh-authorized-key* [key-pair-ref]
                +--rw key-pair-ref    -> ../../../../../key-pair/name
  augment /osm-project:project:
    +--ro ns-instance-opdata
       +--ro nsr* [ns-instance-config-ref]
          +--ro ns-instance-config-ref    -> ../../../ns-instance-config/nsr/id
          +--ro name-ref?                 -> ../../../ns-instance-config/nsr[id=current()/../ns-instance-config-ref]/name
          +--ro nsd-ref?                  -> ../../../ns-instance-config/nsr[id=current()/../ns-instance-config-ref]/nsd/id
          +--ro nsd-name-ref?             -> ../../../ns-instance-config/nsr[id=current()/../ns-instance-config-ref]/nsd/name
          +--ro create-time?              uint32
          +--ro uptime?                   uint32
          +--ro connection-point* [name]
          |  +--ro name    string
          |  +--ro type?   manotypes:connection-point-type
          +--ro vlr* [vlr-ref]
          |  +--ro vlr-ref                      -> ../../../../vlr:vlr-catalog/vlr/id
          |  +--ro vnfr-connection-point-ref* [vnfr-id]
          |     +--ro vnfr-id             -> ../../../../../vnfr:vnfr-catalog/vnfr/id
          |     +--ro connection-point?   -> ../../../../../vnfr:vnfr-catalog/vnfr[vnfr:id = current()/../vnfr-id]/connection-point/name
          +--ro constituent-vnfr-ref* [vnfr-id]
          |  +--ro vnfr-id    string
          +--ro scaling-group-record* [scaling-group-name-ref]
          |  +--ro scaling-group-name-ref    -> ../../../../ns-instance-config/nsr[id=current()/../../ns-instance-config-ref]/nsd/scaling-group-descriptor/name
          |  +--ro instance* [instance-id]
          |     +--ro instance-id      uint16
          |     +--ro is-default?      boolean
          |     +--ro op-status?       enumeration
          |     +--ro config-status?   config-states
          |     +--ro error-msg?       string
          |     +--ro create-time?     uint32
          |     +--ro vnfrs*           -> ../../../constituent-vnfr-ref/vnfr-id
          +--ro vnffgr* [id]
          |  +--ro id                    yang:uuid
          |  +--ro vnffgd-id-ref?        -> ../../../../ns-instance-config/nsr[id=current()/../../ns-instance-config-ref]/nsd/vnffgd/id
          |  +--ro vnffgd-name-ref?      -> ../../../../ns-instance-config/nsr[id=current()/../../ns-instance-config-ref]/nsd/vnffgd[id=current()/../vnffgd-id-ref]/name
          |  +--ro sdn-account?          string
          |  +--ro cloud-account?        string
          |  +--ro operational-status?   vnffgr-operational-status
          |  +--ro rsp* [id]
          |  |  +--ro id                           yang:uuid
          |  |  +--ro name?                        string
          |  |  +--ro rsp-id?                      yang:uuid
          |  |  +--ro vnffgd-rsp-id-ref?           -> ../../../../../ns-instance-config/nsr[id=current()/../../../ns-instance-config-ref]/nsd/vnffgd[id=current()/../../vnffgd-id-ref]/rsp/id
          |  |  +--ro vnffgd-rsp-name-ref?         -> ../../../../../ns-instance-config/nsr[id=current()/../../../ns-instance-config-ref]/nsd/vnffgd[id=current()/../../vnffgd-id-ref]/rsp[id=current()/../vnffgd-rsp-id-ref]/name
          |  |  +--ro classifier-name?             string
          |  |  +--ro path-id?                     uint32
          |  |  +--ro vnfr-connection-point-ref* [hop-number]
          |  |     +--ro hop-number                           uint8
          |  |     +--ro service-function-type?               string
          |  |     +--ro member-vnf-index-ref?                string
          |  |     +--ro vnfd-id-ref?                         string
          |  |     +--ro vnfr-id-ref?                         -> ../../../../../../vnfr:vnfr-catalog/vnfr/id
          |  |     +--ro vnfr-name-ref?                       -> ../../../../../../vnfr:vnfr-catalog/vnfr/name
          |  |     +--ro vnfr-ingress-connection-point-ref?   -> ../../../../../../vnfr:vnfr-catalog/vnfr[vnfr:id = current()/../vnfr-id-ref]/connection-point/name
          |  |     +--ro vnfr-egress-connection-point-ref?    -> ../../../../../../vnfr:vnfr-catalog/vnfr[vnfr:id = current()/../vnfr-id-ref]/connection-point/name
          |  |     +--ro service-index?                       uint8
          |  |     +--ro connection-point-params
          |  |     |  +--ro mgmt-address?   inet:ip-address
          |  |     |  +--ro name?           string
          |  |     |  +--ro port-id?        string
          |  |     |  +--ro vm-id?          string
          |  |     |  +--ro address?        inet:ip-address
          |  |     |  +--ro port?           inet:port-number
          |  |     +--ro service-function-forwarder
          |  |        +--ro name?         string
          |  |        +--ro ip-address?   inet:ip-address
          |  |        +--ro port?         inet:port-number
          |  +--ro classifier* [id]
          |     +--ro id                           yang:uuid
          |     +--ro name?                        string
          |     +--ro classifier-id*               yang:uuid
          |     +--ro rsp-id-ref?                  -> ../../rsp/id
          |     +--ro rsp-name?                    string
          |     +--ro vnfr-id-ref?                 -> ../../../../../vnfr:vnfr-catalog/vnfr/id
          |     +--ro vnfr-name-ref?               -> ../../../../../vnfr:vnfr-catalog/vnfr/name
          |     +--ro vnfr-connection-point-ref?   -> ../../../../../vnfr:vnfr-catalog/vnfr[vnfr:id = current()/../vnfr-id-ref]/connection-point/name
          |     +--ro port-id?                     string
          |     +--ro vm-id?                       string
          |     +--ro ip-address?                  string
          |     +--ro sff-name?                    string
          +--ro operational-status?       ns-operational-status
          +--ro ns-configuration
          |  +--ro (config-method)?
          |  |  +--:(script)
          |  |  |  +--ro script
          |  |  |     +--ro script-type?   enumeration
          |  |  +--:(juju)
          |  |     +--ro juju
          |  |        +--ro charm?               string
          |  |        +--ro proxy?               boolean
          |  |        +--ro vca-relationships
          |  |           +--ro relation* [requires provides]
          |  |              +--ro requires    string
          |  |              +--ro provides    string
          |  +--ro config-primitive* [name]
          |  |  +--ro name                   string
          |  |  +--ro parameter* [name]
          |  |  |  +--ro name              string
          |  |  |  +--ro data-type?        manotypes:parameter-data-type
          |  |  |  +--ro mandatory?        boolean
          |  |  |  +--ro default-value?    string
          |  |  |  +--ro parameter-pool?   string
          |  |  |  +--ro read-only?        boolean
          |  |  |  +--ro hidden?           boolean
          |  |  +--ro user-defined-script?   string
          |  +--ro initial-config-primitive* [seq]
          |  |  +--ro seq                          uint64
          |  |  +--ro (primitive-type)?
          |  |     +--:(primitive-definition)
          |  |        +--ro name?                  string
          |  |        +--ro parameter* [name]
          |  |        |  +--ro name         string
          |  |        |  +--ro data-type?   manotypes:parameter-data-type
          |  |        |  +--ro value?       string
          |  |        +--ro user-defined-script?   string
          |  +--ro terminate-config-primitive* [seq]
          |  |  +--ro seq                    uint64
          |  |  +--ro name?                  string
          |  |  +--ro parameter* [name]
          |  |  |  +--ro name         string
          |  |  |  +--ro data-type?   manotypes:parameter-data-type
          |  |  |  +--ro value?       string
          |  |  +--ro user-defined-script?   string
          |  +--ro metrics* [name]
          |     +--ro name    string
          +--ro config-status?            config-states
          +--ro monitoring-param* [id]
          |  +--ro value-type?            param-value-type
          |  +--ro numeric-constraints
          |  |  +--ro min-value?   uint64
          |  |  +--ro max-value?   uint64
          |  +--ro text-constraints
          |  |  +--ro min-length?   uint8
          |  |  +--ro max-length?   uint8
          |  +--ro value-integer?         int64
          |  +--ro value-decimal?         decimal64
          |  +--ro value-string?          string
          |  +--ro description?           string
          |  +--ro group-tag?             string
          |  +--ro widget-type?           manotypes:widget-type
          |  +--ro units?                 string
          |  +--ro aggregation-type?      aggregation-type
          |  +--ro id                     string
          |  +--ro name?                  string
          |  +--ro nsd-mon-param-ref?     -> ../../../../project-nsd:nsd-catalog/nsd[project-nsd:id = current()/../../nsd-ref]/monitoring-param/id
          |  +--ro vnfr-mon-param-ref* [vnfr-id-ref vnfr-mon-param-ref]
          |     +--ro vnfr-id-ref           yang:uuid
          |     +--ro vnfr-mon-param-ref    -> ../../../../../vnfr:vnfr-catalog/vnfr[vnfr:id = current()/../vnfr-id-ref]/monitoring-param/id
          +--ro config-agent-job* [job-id]
             +--ro job-id                uint64
             +--ro job-name?             string
             +--ro job-status?           enumeration
             +--ro triggered-by?         trigger-type
             +--ro create-time?          uint32
             +--ro job-status-details?   string
             +--ro parameter* [name]
             |  +--ro name         string
             |  +--ro data-type?   manotypes:parameter-data-type
             |  +--ro value?       string
             +--ro parameter-group* [name]
             |  +--ro name         string
             |  +--ro parameter* [name]
             |     +--ro name         string
             |     +--ro data-type?   manotypes:parameter-data-type
             |     +--ro value?       string
             +--ro vnfr* [id]
                +--ro id                yang:uuid
                +--ro vnf-job-status?   enumeration
                +--ro primitive* [name]
                   +--ro name                       string
                   +--ro parameter* [name]
                   |  +--ro name         string
                   |  +--ro data-type?   manotypes:parameter-data-type
                   |  +--ro value?       string
                   +--ro execution-id?              string
                   +--ro execution-status?          enumeration
                   +--ro execution-error-details?   string

  rpcs:
    +---x get-ns-config-primitive-values
    |  +---w input
    |  |  +---w name            string
    |  |  +---w project-name?   -> /osm-project:project/name
    |  |  +---w nsr_id_ref      -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr/id
    |  +--ro output
    |     +--ro ns-parameter* [name]
    |     |  +--ro name     string
    |     |  +--ro value?   string
    |     +--ro ns-parameter-group* [name]
    |     |  +--ro name         string
    |     |  +--ro parameter* [name]
    |     |     +--ro name     string
    |     |     +--ro value?   string
    |     +--ro vnf-primitive-group* [member-vnf-index-ref]
    |        +--ro member-vnf-index-ref    string
    |        +--ro vnfd-id-ref?            string
    |        +--ro primitive* [index]
    |           +--ro index        uint32
    |           +--ro name?        string
    |           +--ro parameter* [name]
    |              +--ro name     string
    |              +--ro value?   string
    +---x exec-ns-config-primitive
    |  +---w input
    |  |  +---w name?                  string
    |  |  +---w project-name?          -> /osm-project:project/name
    |  |  +---w nsr_id_ref             -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr/id
    |  |  +---w triggered-by?          trigger-type
    |  |  +---w parameter* [name]
    |  |  |  +---w name         string
    |  |  |  +---w data-type?   manotypes:parameter-data-type
    |  |  |  +---w value?       string
    |  |  +---w parameter-group* [name]
    |  |  |  +---w name         string
    |  |  |  +---w parameter* [name]
    |  |  |     +---w name         string
    |  |  |     +---w data-type?   manotypes:parameter-data-type
    |  |  |     +---w value?       string
    |  |  +---w vnf-list* [member_vnf_index_ref]
    |  |  |  +---w member_vnf_index_ref    uint64
    |  |  |  +---w vnfr-id-ref?            yang:uuid
    |  |  |  +---w vnf-primitive* [index]
    |  |  |     +---w index        uint32
    |  |  |     +---w name?        string
    |  |  |     +---w parameter* [name]
    |  |  |        +---w name         string
    |  |  |        +---w data-type?   manotypes:parameter-data-type
    |  |  |        +---w value?       string
    |  |  +---w user-defined-script?   string
    |  +--ro output
    |     +--ro job-id?               uint64
    |     +--ro name?                 string
    |     +--ro project-name?         -> /osm-project:project/name
    |     +--ro nsr_id_ref            -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr/id
    |     +--ro triggered-by?         trigger-type
    |     +--ro create-time?          uint32
    |     +--ro job-status-details?   string
    |     +--ro parameter* [name]
    |     |  +--ro name         string
    |     |  +--ro data-type?   manotypes:parameter-data-type
    |     |  +--ro value?       string
    |     +--ro parameter-group* [name]
    |     |  +--ro name         string
    |     |  +--ro parameter* [name]
    |     |     +--ro name         string
    |     |     +--ro data-type?   manotypes:parameter-data-type
    |     |     +--ro value?       string
    |     +--ro vnf-out-list* [member_vnf_index_ref]
    |        +--ro member_vnf_index_ref    uint64
    |        +--ro vnfr-id-ref?            yang:uuid
    |        +--ro vnf-out-primitive* [index]
    |           +--ro index                      uint32
    |           +--ro name?                      string
    |           +--ro parameter* [name]
    |           |  +--ro name         string
    |           |  +--ro data-type?   manotypes:parameter-data-type
    |           |  +--ro value?       string
    |           +--ro execution-id?              string
    |           +--ro execution-status?          string
    |           +--ro execution-error-details?   string
    +---x exec-scale-in
    |  +---w input
    |  |  +---w project-name?             -> /osm-project:project/name
    |  |  +---w nsr_id_ref                -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr/id
    |  |  +---w scaling-group-name-ref    -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr[nsr:id=current()/../nsr_id_ref]/nsd/scaling-group-descriptor/name
    |  |  +---w instance-id               -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr[nsr:id=current()/../nsr_id_ref]/scaling-group[nsr:scaling-group-name-ref=current()/../scaling-group-name-ref]/instance/id
    |  +--ro output
    |     +--ro instance-id?   uint64
    +---x exec-scale-out
    |  +---w input
    |  |  +---w project-name?             -> /osm-project:project/name
    |  |  +---w nsr_id_ref                -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr/id
    |  |  +---w scaling-group-name-ref    -> /osm-project:project[osm-project:name=current()/../nsr:project-name]/ns-instance-config/nsr[nsr:id=current()/../nsr_id_ref]/nsd/scaling-group-descriptor/name
    |  |  +---w instance-id?              uint64
    |  +--ro output
    |     +--ro instance-id?   uint64
    +---x start-network-service
       +---w input
       |  +---w name                         string
       |  +---w project-name?                -> /osm-project:project/name
       |  +---w nsd_id_ref?                  -> /osm-project:project[osm-project:name=current()/../project-name]/project-nsd:nsd-catalog/nsd/id
       |  +---w input-parameter* [xpath]
       |  |  +---w xpath    string
       |  |  +---w value?   string
       |  +---w scaling-group* [scaling-group-name-ref]
       |  |  +---w scaling-group-name-ref    string
       |  |  +---w instance* [id]
       |  |     +---w id    uint16
       |  +---w nsd-placement-group-maps* [placement-group-ref]
       |  |  +---w placement-group-ref         string
       |  |  +---w cloud-type?                 manotypes:cloud-account-type
       |  |  +---w (cloud-provider)?
       |  |     +--:(openstack)
       |  |     |  +---w availability-zone
       |  |     |  |  +---w name?   string
       |  |     |  +---w server-group
       |  |     |  |  +---w name?   string
       |  |     |  +---w host-aggregate* [metadata-key]
       |  |     |     +---w metadata-key      string
       |  |     |     +---w metadata-value?   string
       |  |     +--:(aws)
       |  |     |  +---w aws-construct?        empty
       |  |     +--:(openmano)
       |  |     |  +---w openmano-construct?   empty
       |  |     +--:(vsphere)
       |  |     |  +---w vsphere-construct?    empty
       |  |     +--:(mock)
       |  |     |  +---w mock-construct?       empty
       |  |     +--:(cloudsim)
       |  |        +---w cloudsim-construct?   empty
       |  +---w vnfd-placement-group-maps* [placement-group-ref vnfd-id-ref]
       |     +---w vnfd-id-ref                 yang:uuid
       |     +---w placement-group-ref         -> /osm-project:project[osm-project:name=current()/../../project-name]/project-vnfd:vnfd-catalog/vnfd[project-vnfd:id = current()/../vnfd-id-ref]/placement-groups/name
       |     +---w cloud-type?                 manotypes:cloud-account-type
       |     +---w (cloud-provider)?
       |     |  +--:(openstack)
       |     |  |  +---w availability-zone
       |     |  |  |  +---w name?   string
       |     |  |  +---w server-group
       |     |  |  |  +---w name?   string
       |     |  |  +---w host-aggregate* [metadata-key]
       |     |  |     +---w metadata-key      string
       |     |  |     +---w metadata-value?   string
       |     |  +--:(aws)
       |     |  |  +---w aws-construct?        empty
       |     |  +--:(openmano)
       |     |  |  +---w openmano-construct?   empty
       |     |  +--:(vsphere)
       |     |  |  +---w vsphere-construct?    empty
       |     |  +--:(mock)
       |     |  |  +---w mock-construct?       empty
       |     |  +--:(cloudsim)
       |     |     +---w cloudsim-construct?   empty
       |     +---w ssh-authorized-key* [key-pair-ref]
       |     |  +---w key-pair-ref    -> /osm-project:project[osm-project:name=current()/../../../project-name]/key-pair/name
       |     +---w user* [name]
       |        +---w name                  string
       |        +---w user-info?            string
       |        +---w ssh-authorized-key* [key-pair-ref]
       |           +---w key-pair-ref    -> /osm-project:project[osm-project:name=current()/../../../../project-name]/key-pair/name
       +--ro output
          +--ro nsr-id?   yang:uuid
```

### NSI tree

**Navigable version:**

**<http://osm-download.etsi.org/repository/osm/debian/ReleaseSIX/docs/osm-im/osm_im_trees/nsi.html>**

**Plain text version:**

```text
module: nsi
  +--rw nsi* [id]
     +--rw id                          yang:uuid
     +--rw name                        string
     +--rw short-name?                 string
     +--rw description?                string
     +--rw nst-ref                     -> /nst:nst/id
     +--rw instantiation-parameters
     |  +--rw vimAccountId       string
     |  +--rw ssh_keys?          string
     |  +--rw netslice-subnet* [id]
     |  |  +--rw id              string
     |  |  +--rw vimAccountId    string
     |  |  +--rw ssh_keys?       string
     |  |  +--rw vnf* [member-vnf-index]
     |  |  |  +--rw member-vnf-index    string
     |  |  |  +--rw vimAccountId?       string
     |  |  |  +--rw vdu* [id]
     |  |  |  |  +--rw id           string
     |  |  |  |  +--rw volume* [name]
     |  |  |  |  |  +--rw name             string
     |  |  |  |  |  +--rw vim-volume-id    string
     |  |  |  |  +--rw interface* [name]
     |  |  |  |     +--rw name                    string
     |  |  |  |     +--rw ip-address?             inet:ip-address
     |  |  |  |     +--rw mac-address?            ietf-yang:mac-address
     |  |  |  |     +--rw floating-ip-required?   boolean
     |  |  |  +--rw internal-vld* [name]
     |  |  |     +--rw name                         string
     |  |  |     +--rw vim-network-name?            string
     |  |  |     +--rw ip-profile
     |  |  |     |  +--rw ip-version?        inet:ip-version
     |  |  |     |  +--rw subnet-address?    inet:ip-prefix
     |  |  |     |  +--rw gateway-address?   inet:ip-prefix
     |  |  |     |  +--rw dns-server* [address]
     |  |  |     |  |  +--rw address    inet:ip-address
     |  |  |     |  +--rw dhcp-params
     |  |  |     |     +--rw enabled?         boolean
     |  |  |     |     +--rw count?           uint8
     |  |  |     |     +--rw start-address?   inet:ip-address
     |  |  |     +--rw internal-connection-point* [id-ref]
     |  |  |        +--rw id-ref        string
     |  |  |        +--rw ip-address?   inet:ip-address
     |  |  +--rw vld* [name]
     |  |     +--rw name                         string
     |  |     +--rw vim-network-name?            string
     |  |     +--rw ip-profile
     |  |     |  +--rw ip-version?        inet:ip-version
     |  |     |  +--rw subnet-address?    inet:ip-prefix
     |  |     |  +--rw gateway-address?   inet:ip-prefix
     |  |     |  +--rw dns-server* [address]
     |  |     |  |  +--rw address    inet:ip-address
     |  |     |  +--rw dhcp-params
     |  |     |     +--rw enabled?         boolean
     |  |     |     +--rw count?           uint8
     |  |     |     +--rw start-address?   inet:ip-address
     |  |     +--rw vnfd-connection-point-ref* [member-vnf-index-ref vnfd-connection-point-ref]
     |  |        +--rw member-vnf-index-ref         -> /nsd:nsd-catalog/nsd/constituent-vnfd/member-vnf-index
     |  |        +--rw vnfd-connection-point-ref    -> /vnfd:vnfd-catalog/vnfd/connection-point/name
     |  |        +--rw ip-address?                  inet:ip-address
     |  +--rw netslice-vld* [name]
     |     +--rw name                        string
     |     +--rw vim-network-name?           string
     |     +--rw ip-profile
     |     |  +--rw ip-version?        inet:ip-version
     |     |  +--rw subnet-address?    inet:ip-prefix
     |     |  +--rw gateway-address?   inet:ip-prefix
     |     |  +--rw dns-server* [address]
     |     |  |  +--rw address    inet:ip-address
     |     |  +--rw dhcp-params
     |     |     +--rw enabled?         boolean
     |     |     +--rw count?           uint8
     |     |     +--rw start-address?   inet:ip-address
     |     +--rw nss-connection-point-ref* [nss-ref nsd-connection-point-ref]
     |        +--rw nss-ref                     -> /nst:nst/netslice-subnet/id
     |        +--rw nsd-connection-point-ref    -> /nsd:nsd-catalog/nsd/connection-point/name
     |        +--rw ip-address?                 inet:ip-address
     +--rw network-slice-template
     |  +--rw id                           string
     |  +--rw name                         string
     |  +--rw SNSSAI-identifier
     |  |  +--rw slice-service-type      network-slice-type
     |  |  +--rw slice-differentiator?   string
     |  +--rw quality-of-service
     |  |  +--rw id                        uint16
     |  |  +--rw resource-type?            resource-type
     |  |  +--rw priority-level?           uint16
     |  |  +--rw packet-delay-budget?      uint16
     |  |  +--rw packet-error-rate?        uint16
     |  |  +--rw default-max-data-burst?   uint16
     |  +--rw netslice-subnet* [id]
     |  |  +--rw id                          string
     |  |  +--rw description?                string
     |  |  +--rw is-shared-nss?              boolean
     |  |  +--rw nsd-ref                     -> /nsd:nsd-catalog/nsd/id
     |  |  +--rw instantiation-parameters
     |  |     +--rw vimAccountId    string
     |  |     +--rw ssh_keys?       string
     |  |     +--rw vnf* [member-vnf-index]
     |  |     |  +--rw member-vnf-index    string
     |  |     |  +--rw vimAccountId?       string
     |  |     |  +--rw vdu* [id]
     |  |     |  |  +--rw id           string
     |  |     |  |  +--rw volume* [name]
     |  |     |  |  |  +--rw name             string
     |  |     |  |  |  +--rw vim-volume-id    string
     |  |     |  |  +--rw interface* [name]
     |  |     |  |     +--rw name                    string
     |  |     |  |     +--rw ip-address?             inet:ip-address
     |  |     |  |     +--rw mac-address?            ietf-yang:mac-address
     |  |     |  |     +--rw floating-ip-required?   boolean
     |  |     |  +--rw internal-vld* [name]
     |  |     |     +--rw name                         string
     |  |     |     +--rw vim-network-name?            string
     |  |     |     +--rw ip-profile
     |  |     |     |  +--rw ip-version?        inet:ip-version
     |  |     |     |  +--rw subnet-address?    inet:ip-prefix
     |  |     |     |  +--rw gateway-address?   inet:ip-prefix
     |  |     |     |  +--rw dns-server* [address]
     |  |     |     |  |  +--rw address    inet:ip-address
     |  |     |     |  +--rw dhcp-params
     |  |     |     |     +--rw enabled?         boolean
     |  |     |     |     +--rw count?           uint8
     |  |     |     |     +--rw start-address?   inet:ip-address
     |  |     |     +--rw internal-connection-point* [id-ref]
     |  |     |        +--rw id-ref        string
     |  |     |        +--rw ip-address?   inet:ip-address
     |  |     +--rw vld* [name]
     |  |        +--rw name                         string
     |  |        +--rw vim-network-name?            string
     |  |        +--rw ip-profile
     |  |        |  +--rw ip-version?        inet:ip-version
     |  |        |  +--rw subnet-address?    inet:ip-prefix
     |  |        |  +--rw gateway-address?   inet:ip-prefix
     |  |        |  +--rw dns-server* [address]
     |  |        |  |  +--rw address    inet:ip-address
     |  |        |  +--rw dhcp-params
     |  |        |     +--rw enabled?         boolean
     |  |        |     +--rw count?           uint8
     |  |        |     +--rw start-address?   inet:ip-address
     |  |        +--rw vnfd-connection-point-ref* [member-vnf-index-ref vnfd-connection-point-ref]
     |  |           +--rw member-vnf-index-ref         -> /nsd:nsd-catalog/nsd/constituent-vnfd/member-vnf-index
     |  |           +--rw vnfd-connection-point-ref    -> /vnfd:vnfd-catalog/vnfd/connection-point/name
     |  |           +--rw ip-address?                  inet:ip-address
     |  +--rw netslice-connection-point* [name]
     |  |  +--rw name                              string
     |  |  +--rw floating-ip-required?             boolean
     |  |  +--rw (connection)?
     |  |     +--:(netslice-vld-ref)
     |  |     |  +--rw netslice-vld-id-ref?        -> ../../netslice-vld/id
     |  |     +--:(nsd-connection-point-ref)
     |  |        +--rw nsd-id-ref?                 -> /nsd:nsd-catalog/nsd/id
     |  |        +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
     |  +--rw netslice-vld* [id]
     |  |  +--rw id                          string
     |  |  +--rw name?                       string
     |  |  +--rw short-name?                 string
     |  |  +--rw vendor?                     string
     |  |  +--rw description?                string
     |  |  +--rw version?                    string
     |  |  +--rw type?                       manotypes:virtual-link-type
     |  |  +--rw root-bandwidth?             uint64
     |  |  +--rw leaf-bandwidth?             uint64
     |  |  +--rw provider-network
     |  |  |  +--rw physical-network?   string
     |  |  |  +--rw segmentation_id?    uint32
     |  |  +--rw mgmt-network?               boolean
     |  |  +--rw nss-connection-point-ref* [nss-ref nsd-connection-point-ref]
     |  |     +--rw nss-ref                     -> /nst:nst/netslice-subnet/id
     |  |     +--rw nsd-connection-point-ref    -> /nsd:nsd-catalog/nsd/connection-point/name
     |  |     +--rw ip-address?                 inet:ip-address
     |  +--rw netslicefgd* [id]
     |     +--rw id             string
     |     +--rw name?          string
     |     +--rw short-name?    string
     |     +--rw vendor?        string
     |     +--rw description?   string
     |     +--rw version?       string
     |     +--rw rsp* [id]
     |     |  +--rw id                          string
     |     |  +--rw name?                       string
     |     |  +--rw nsd-connection-point-ref* [nsd-ref]
     |     |     +--rw nsd-ref                     -> /nsd:nsd-catalog/nsd/id
     |     |     +--rw order?                      uint8
     |     |     +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
     |     +--rw classifier* [id]
     |        +--rw id                          string
     |        +--rw name?                       string
     |        +--rw rsp-id-ref?                 -> ../../rsp/id
     |        +--rw match-attributes* [id]
     |        |  +--rw id                        string
     |        |  +--rw ip-proto?                 uint8
     |        |  +--rw source-ip-address?        inet:ip-address
     |        |  +--rw destination-ip-address?   inet:ip-address
     |        |  +--rw source-port?              inet:port-number
     |        |  +--rw destination-port?         inet:port-number
     |        +--rw nsd-ref?                    -> /nsd:nsd-catalog/nsd/id
     |        +--rw nsd-connection-point-ref?   -> /nsd:nsd-catalog/nsd/connection-point/name
     +--ro nsr-ref-list* [nsr-ref]
     |  +--ro nsr-ref    -> /osm-project:project/nsr:ns-instance-opdata/nsr/ns-instance-config-ref
     +--ro vlr-list* [id]
        +--ro id    yang:uuid
```

## OSM URN Namespace

### Introduction

OSM is maintaining a namespace registry as a sub tree of the ETSI root `urn:etsi` namespace. A description of the top level ETSI URN namespace can be found on the [ETSI PNNS page](https://portal.etsi.org/PNNS/GenericAllocation/ETSIURNNamespace.aspx)

The OSM URN namespace has the following structure:

```text
urn:etsi:osm:<OSM sub-tree>
```

The following sections describe the basic structure of the sub-tree and how a entry in the registry can be requested.

### OSM sub-tree

| OSM sub-tree |    Full Namespace    |  Type  |                         Description                          |
| :----------: | :------------------: | :----: | :----------------------------------------------------------: |
|     yang     | `urn:etsi:osm:yang ` | string | Namespace for YANG modules specified in OSM.[OSM/IM.git](https://osm.etsi.org/gitweb/?p=osm/IM.git;a=tree;f=models/yang) |

#### Type definitions

```python
string = (ALPHA)0*(ALPHANUMERIC/-/_)
## a string starts with an upper- or lower-case letter followed by zero or more upper- or lower-case letters, integer numbers, hyphens or underscores

ALPHA = {a-zA-Z}
ALPHANUMERIC = {a-zA-Z0-9}
```

### Requesting an entry

The procedure to request an entry is described as follows.

- **Step #1:** Send an e-mail to the <OSM_TSC@list.etsi.org> mailing list indicating the name of the sub-tree, the contact person and the purpose of that subtree.
- **Step #2:** The TSC will review the proposal.
  - If the application is accepted, a new entry in the "OSM URN Namespace" will be enabled.
  - If the application cannot be accepted, it will be communicated to the contact person together with any additional information to be considered for resolving the "non-acceptance".

## Release TWO Descriptor Documentation (OLD)

The document below contains a detailed description of the OSM Release TWO Models. Although a bit outdated, it can still be used as a reference to understand some of the fields in the VNFD and NSD.

[OSM Release TWO Information Model](https://osm.etsi.org/wikipub/images/2/26/OSM_R2_Information_Model.pdf)
