# OSM platform configuration

## User management

TODO: Page in elaboration.

## Project management

TODO: Page in elaboration.

## RBAC

TODO: Page in elaboration.

## VIM management

TODO: Page in elaboration.

```text
Some planned contents:
- Uses of availability zones
- Host aggregates
```

## Physical Deployment Units

TODO: Page in elaboration.

```text
Some planned contents:
- Description of what is a PDU in OSM
- How to register attached PDUs
```

## Intra-VIM SDN management (for SDN Assist)

TODO: Page in elaboration.

## WIM (Inter-VIM SDN) management

### Introduction to the use of a WIM in OSM

WIM is the acronym for _WAN Infrastructure Manager_, which is a specialized system that allows to establish connectivity between different network endpoints at different NFVI-PoPs in the context of a multi-site service Wide Area Network (WAN).

For the establishment of the network connectivity, the WIM may rely on network controllers that handle the fulfilment of the connectivity at a lower level, potentially making use of different network technologies and protocols. The WIM offers to the consumers an abstraction of such network connectivity to ease the provisioning and monitoring of it.

### WIM setup through OSM client

The following is the command needed to perform to setup the WIM in OSM. It must be filled with the appropriate parameters (e.g. site name: `wim-demo`, IP address: `10.10.10.10:8080`, user: `username`, password: `userpwd`, wim_type: `type` port mapping: `sample_port_mapping.yml`)

```bash
osm wim-create --name wim-demo --url http://10.10.10.10:8080 --user username --password userpwd --wim_type type --description "Demo WIM"   --wim_port_mapping sample_port_mapping.yml
```

#### WIM port mapping

The port mapping file indicated above should be adapted to the desired WIM configuration. It should be a `.yml` file that contains the information of the OpenStack where the WIM is going to be configured, following one of these schemas [\[1\]](https://osm.etsi.org/gitweb/?p=osm/RO.git;a=blob;f=osm_ro/wim/schemas.py)

#### WIM types

- `ietfl2vpn`: this type allows to manage L2VPN services from OSM using a WIM that exposes a Restconf Interface with the Yang L2SM model defined in [RFC 8466](https://tools.ietf.org/html/rfc8466).
- `DynPaC`: the DynPaC (Dynamic Path Computation Framework) WIM connector allows the creation (and deletion) of layer two services between two VNFs with given bandwidth requirements.

### Network Service creation

In order to create a NS utilizing a WIM, the `osm ns-create` command is executed the following way:

```bash
osm ns-create --ns_name <ns_name> --nsd_name <nsd_name> --vim_account <vim-1-name> --config ' { vnf: [ {member-vnf-index: "1", vim_account: <vim-1-name>}, {member-vnf-index: "2", vim_account: <vim-2-name>} ] }'
```

Then, an available WIM capable of connecting those two datacenters will be used.

### L2SM Plugin

The L2SM WIM Plugin is included in the RO component of the OSM version six that allows the management of WIM Services. Those WIMs should be created to support connectivity between VNFs running in different VIMs.

The L2SM WIM plugin allows connecting the OSM to handle the lifecycle of a layer 2 VPN service, request creation, modification and deletion, by utilizing the service delivery model defined in [RFC 8466](https://tools.ietf.org/html/rfc8466).

#### L2SM Plugin port mapping

As it was indicated, the port mapping should be adapted to the WIM configuration. In this case, to configure the WIM, the port mapping file `.yml` should be created following the wim_port_mapping_desc schema, as in the following example:

```yaml
- datacenter_name:  "name1"
  pop_wan_mappings:
    - pop_switch_dpid: "openflow:1"
      pop_switch_port: 1
      wan_service_endpoint_id: "1"
      wan_service_mapping_info:
          mapping_type: direct-connect1
          site-id: '1'
          bearer:
               bearer-reference:'1a'
```

For each port of each site wanted to be added to the Network Service, it's needed a port mapping like previous one. The parameters needed for each port mapping are:

- `datacenter_name`: name of the desired site.
- `wan_service_endpoint_id`: UUID of the desired WAN endpoint.
- `site-id`: UUID of the desried site.
- `bearer-reference`: UUID of the desired port of the site to be added to the Network Service.

### DynPaC

DynPaC needs to first be installed as an application in the ONOS controller managing the WIM infraestructure. The `--url` parameter of wim-create will then be typically `http://<onos-ip>:8181/controller/wim`.

When adding OpenStack VIMs to be used with the DynPaC OSM WIM, the following needs to be passed to the `--config` parameter of the `osm vim-create` command:

```yaml
--config '{"user_domain_name": "<Openstack domain>", "project_domain_name": "<Openstack project>", "dataplane_physical_net": "<physical net>", "external_connections": [{"condition": {"provider:physical_network": "<physical net>", "provider:network_type": "vlan"}, "vim_external_port": {"switch": "<datacenter switch dpid>", "port": "<datacenter switch port>"}}]}'
```

`<datacenter switch dpid>` and `<datacenter switch port>` here are the same ones as `pop_switch_dpid` and `pop_switch_port` as will be seen later in the WIM port mapping example.

In order to add a DynPaC WIM to OSM that connects two datacenters (VIMs) with the wim-create command, the file passed to the `--wim_port_mapping` parameter should have the following structure. For example:

```yaml
- datacenter_name: "VIM 1"
  pop_wan_mappings:
  - pop_switch_dpid: "DC 1"
    pop_switch_port: "P1A"
    wan_service_mapping_info:
     mapping_type: 'dpid-port'
     wan_switch_dpid: "WAN 1"
     wan_switch_port: "P1B"
- datacenter_name: "VIM 2"
  pop_wan_mappings:
  - pop_switch_dpid: "DC 2"
    pop_switch_port: "P2B"
    wan_service_mapping_info:
     mapping_type: 'dpid-port'
     wan_switch_dpid: "WAN 2"
     wan_switch_port: "P2A"
```

![Wim schema.png](https://osm.etsi.org/wikipub/images/thumb/8/8a/Wim_schema.png/750px-Wim_schema.png)

Where:

- `datacenter_name` are the names of the two VIMs (as displayed by osm vim-list)
- `pop_switch_dpid` is the datapath ID of the datacenter switch that provides the VIM connectivity
- `pop_switch_port` is the port of the datacenter switch that connects to the immediate WAN switch
- `wan_switch_dpid` is the datapath ID of the immediate WAN switch
- `wan_switch_port` is the port of the immediate WAN switch that connects to the datacenter switch

DPIDs are in `of:xxxxxxxxxxxxxxxx` format.

## Kubernetes

TODO: Page in elaboration.

```text
Some planned contents:
- K8s clusters
- Management of Helm repos
```

## Monitoring the OSM platform

TODO: Page in elaboration.

### Docker swarm build

### Kubernetes build
