# Installing OSM

## Pre-requirements

In order to install OSM, you will need, at least, a single server or VM with the following requirements:

- MINIMUM: 2 CPUs, 4 GB RAM, 20GB disk and a single interface with Internet access
- RECOMMENDED: 2 CPUs, 8 GB RAM, 40GB disk and a single interface with Internet access
- Base image: Ubuntu18.04 (64-bit variant required) (http://releases.ubuntu.com/18.04/)

In addition, you will need a Virtual Infrastructure Manager available so that OSM can orchestrate workloads on it. The following figure illustrates OSM interaction with VIMs and the VNFs to be deployed there:

- OSM communicates with the VIM for the deployment of VNFs.
- OSM communicates with the VNFs deployed in a VIM to run day-0, day-1 and day-2 configuration primitives.

![OSM topology](assets/600px-Osmtopology.png)

Hence, it is assumed that:

- Each VIM has an API endpoint reachable from OSM.
- Each VIM has a so-called management network, which provides IP addresses to VNFs.
- That management network is reachable from OSM.

## Installation options

### Installation based on docker swarm

Once you have one host available with the characteristics above, you just need to trigger the OSM installation by:

```bash
wget https://osm-download.etsi.org/ftp/osm-7.0-seven/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh
```

**TIP:** In order to facilitate potential trobleshooting later, it is recommended to save the full log of your installation process:

```bash
wget https://osm-download.etsi.org/ftp/osm-7.0-seven/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh 2>&1 | tee osm_install_log.txt
```

You will be asked if you want to proceed with the installation and configuration of LXD, juju, docker CE and the initialization of a local docker swarm, as pre-requirements. Please answer `y`.

If you want to run docker commands, you will also need to either reload the shell or run the following command to add your user to the 'docker' group:

```bash
newgrp docker
```

### Installation based on Kubernetes

From Release SEVEN, OSM can be deployed on a single host running a Kubernetes cluster. Although the default option is to use docker swarm, you can now tell the installer to use K8s as the container framework. The installer will install the required packages to run a single-node K8s cluster and will deploy the different K8s objects on it.

```bash
wget https://osm-download.etsi.org/ftp/osm-7.0-seven/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh -c k8s
```

In addition, you can use the option `--k8s\_monitor` to install an add-on to monitor the K8s cluster and OSM running on top of it.

 ```bash
./install_osm.sh -c k8s --k8s_monitor
 ```

### Other installer options

You can include optional components in your installation by adding the following flags:

- **VIM Emulator:** `--vimemu` (more information [here](04-vim-setup.md#vim-emulator)
- **Fault Management features with ELK:** `--elk_stack` (more information [here](05-osm-usage.md#fault-management)

Example:

```bash
./install_osm.sh --elk_stack --pm_stack
```

OSM installer includes a larger number of install options. The general usage is the following:

```bash
./install_osm.sh [OPTIONS]
```

With no options, it will install OSM from binaries.

**Options:**

```text
    --uninstall:    uninstall OSM: remove the containers and delete NAT rules
    -r <repo>:      use specified repository name for osm packages
    -R <release>:   use specified release for osm binaries (deb packages, lxd images, ...)
    -u <repo base>: use specified repository url for osm packages
    -k <repo key>:  use specified repository public key url
    -c <orchestrator> deploy osm services using container <orchestrator>. Valid values are <k8s> or <swarm>.  If -c is not used then osm will be deployed using default orchestrator. When used with --uninstall, osm services deployed by the orchestrator will be uninstalled
    -s <stack name> or <namespace>  user defined stack name when installed using swarm or namespace when installed using k8s, default is osm
    --vimemu:       additionally deploy the VIM emulator as a docker container
    --elk_stack:    additionally deploy an ELK docker stack for event logging
    -m <MODULE>:    install OSM but only rebuild the specified docker images (LW-UI, NBI, LCM, RO, MON, POL, KAFKA, MONGO, PROMETHEUS, PROMETHEUS-CADVISOR, KEYSTONE-DB, NONE)
    -o <ADDON>:     do not install OSM, but ONLY one of the addons (vimemu, elk_stack) (assumes OSM is already installed)
    --showopts:     print chosen options and exit (only for debugging)
    -y:             do not prompt for confirmation, assumes yes
    -D <devops path> use local devops installation path
    -h / --help:    prints help
```

### Vagrant installation

Pre-built OSM vagrant images are available here: <https://app.vagrantup.com/osm>

The pre-built image requires 4GB of memory and 2 vCPUs.

#### 1) Install Vagrant and VirtualBox

Follow the instructions to install them in their respective sites:

- [Vagrant](https://www.vagrantup.com/)
- [VirtualBox](https://www.virtualbox.org/)

#### 2) Create the initial Vagrantfile in a predefined directory of your choice

```bash
vagrant init osm/releaseseven
```

- NOTE: to ensure the latest version is downloaded, destroy any previous existing OSM boxes (i.e. using `vagrant box list` and, if needed, `vagrant box remove`)

#### 3) Edit the generated `Vagrantfile`

Editing the `Vagrantfile` is required if you need to customize the image for opened ports, assigned memory, etc.

For instance, if you want to access the OSM Web client externally from the VirtualBox VM, you can open up port 80 (mapped to 8080 at your host) by uncommenting this line:

```ruby
config.vm.network "forwarded_port", guest: 80, host: 8080
```

#### 4) Start OSM

```bash
vagrant up
```

- NOTE: warnings related to `Vagrant unable to mount VirtualBox shared folders` can be safely ignored.

#### 5) ssh to OSM

```bash
vagrant ssh
```

#### Additional notes

If at any time you need to change something from the `Vagrantfile`, you can apply the changes by reloading the VM:

```bash
vagrant reload
```

If you need to copy a file to your vagrant machine, just run `vagrant ssh-config` and copy the private key path, then:

```bash
scp -P 2222 -i /path/to/private_key someFileName.txt vagrant@127.0.0.1:
```

To use an image downloaded manually, add the box to Vagrant and create a matching `Vagrantfile`:

```bash
vagrant box add osm/releaseseven /path/to/vagrant.box
vagrant init osm/releaseseven
```

If at any point you need to add the optional components (`elk_stack`, `vimemu`, ...) you can do so by downloading the installer from inside your VM and executing it with the `-o` option, for example:

```bash
wget https://osm-download.etsi.org/ftp/osm-7.0-seven/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh -o elk_stack
```

Please note that you may need to add more forwarded ports, for example, to access Kibana after adding the `elk_stack`, you would need to add a line like this one to your `Vagrantfile`, then run `vagrant reload`:

```ruby
config.vm.network "forwarded_port", guest: 5601, host: 5601
```

#### Including VIM Emulator in a Vagrant installation of OSM

```bash
vagrant init osm/releaseseven
vagrant up
vagrant ssh
# startup VIM-EMU
# new version of installer will have the vim-emu start by default
sudo docker run --name vim-emu -t -d --restart always --privileged --pid='host' --network=netOSM -v /var/run/docker.sock:/var/run/docker.sock vim-emu-img python examples/osm_default_daemon_topology_2_pop.py
export OSM_HOSTNAME=127.0.0.1
export OSM_SOL005=True
export VIMEMU_HOSTNAME=$(sudo docker inspect -f '{{range .NetworkSettings.Networks}}{{.IPAddress}}{{end}}' vim-emu)
osm vim-create --name emu-vim1 --user username --password password --auth_url http://$VIMEMU_HOSTNAME:6001/v2.0 --tenant tenantName --account_type openstack
git clone https://osm.etsi.org/gerrit/osm/vim-emu.git
osm vnfd-create vim-emu/examples/vnfs/ping.tar.gz
osm vnfd-create vim-emu/examples/vnfs/pong.tar.gz
osm nsd-create vim-emu/examples/services/pingpong_nsd.tar.gz
osm ns-create --nsd_name pingpong --ns_name test --vim_account emu-vim1
vagrant@vagrant:~$ osm ns-list
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
| ns instance name | id                                   | operational status | config status | detailed status                                                                             |
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
| test             | 05a363b0-4ac1-49a1-a4b1-9680e39b1ade | init               | init          | Waiting ns ready at RO. RO_id=2c569b2a-b21f-495b-9837-6a469f565044; VMs: 0/2, networks: 0/1 |
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
vagrant@vagrant:~$ osm ns-list
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
| ns instance name | id                                   | operational status | config status | detailed status                                                                             |
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
| test             | 05a363b0-4ac1-49a1-a4b1-9680e39b1ade | init               | init          | Waiting ns ready at RO. RO_id=2c569b2a-b21f-495b-9837-6a469f565044; VMs: 0/2, networks: 0/1 |
+------------------+--------------------------------------+--------------------+---------------+---------------------------------------------------------------------------------------------+
```

### Installation from source

TODO: Under elaboration.

## PM and FM dashboards (optional)

TODO: Under elaboration.

## Checking your installation

After some time of downloading and processing, you will get a fresh OSM installation with its latest pre-built docker images. You can access to the UI in the following URL (user:`admin`, password: `admin`): [http://1.2.3.4](http://1.2.3.4/), replacing 1.2.3.4 by the IP address of your host.

![OSM home](assets/600px-Osm_lwb_ui_login.png)

![OSM installation result](assets/600px-Osm_lwb_ui.png)

As a result of the installation, 13 docker containers are created in the host (without considering optional stacks). You can check they are running by issuing the following commands:

```bash
docker stack ps osm |grep -i running
docker service ls
```

![OSM Docker containers](assets/600px-Osm_containers_rel5.png)

At any time, you can quickly relaunch your deployment by using the pre-built docker images, like this:

```bash
docker stack rm osm && sleep 60 # The sleep is for making sure the stack removal finishes before redeploying
docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

To check the logs of any container:

```bash
docker service logs osm_lcm     # shows the logs of all containers (included dead containers) associated with LCM component.
docker logs $(docker ps -aqf "name=osm_lcm" -n 1)  # shows the logs of the last existant LCM container
```

## Installing standalone OSM Client

The **OSM Client** is a client library and a command-line tool (based on Python) to operate OSM, which accesses OSM's Northbound Interface (NBI) and lets you manage descriptors, VIMs, Network Services, Slices, etc. along with their whole lifecycle. In other words, the OSM Client is a sort of Swiss knife that provides a convenient access to all the functionality that OSM's NBI offers.

Although the OSM Client is always available in the host machine after installation, it is sometimes convenient installing an OSM Client in another location, different from the OSM host, so that the access to the OSM services does not require OS-level/SSH credentials. Thus, in those cases where you have an OSM already installed in a remote server and you can still operate it from your local computer using the OSM Client.

In order to install the OSM Client in your local Linux machine, you should follow this procedure:

```bash
# Clean the previous repos that might exist
sudo sed -i "/osm-download.etsi.org/d" /etc/apt/sources.list
wget -qO - https://osm-download.etsi.org/repository/osm/debian/ReleaseSEVEN/OSM%20ETSI%20Release%20Key.gpg | sudo apt-key add –
sudo add-apt-repository -y "deb [arch=amd64] https://osm-download.etsi.org/repository/osm/debian/ReleaseSEVEN stable devops osmclient"
sudo apt-get update
sudo -H pip3 install python-magic pyangbind
sudo apt-get install python3-osmclient
```

Once installed, you can type `osm` to see a list of commands.

Since we are installing the OSM Client in a host different from OSM's at a minimum you will need to specify the OSM host, either via an environment variable or via the osm command line. For instance, you can set your client to access an OSM host running at `10.80.80.5` by using:

```bash
export OSM_HOSTNAME="10.80.80.5"
```

For additional remote access options, see `osm --help` for more info.

## How to upgrade OSM

### Upgrading the complete OSM platform

Due to the new architecture and dockerized components introduced in OSM since Release FOUR, OSM platform upgrade is quite easy. Upgrading to the latest minor version is as simple as running again the installer:

```bash
wget https://osm-download.etsi.org/ftp/osm-7.0-seven/install_osm.sh
chmod +x install_osm.sh
./install_osm.sh
```

You will be asked if you want to proceed with the installation and configuration of LXD, juju, docker CE and the initialization of a local docker swarm, as pre-requirements. Please answer `y`.

Then, some dialog messages related to LXD configuration will be shown. This is what you have to answer:

- `Do you want to configure the LXD bridge?` **Yes**
- `Do you want to setup an IPv4 subnet?` **Yes**
- _<< **Default values** apply for next questions >>_
- `Do you want to setup an IPv6 subnet?` **No**

That's all. You will have the newest OSM version installed.

### Upgrading the OSM platform from docker images (advanced users)

**Upgrading to the latest daily docker image might lead to potential issues.** Moreover, every new re-deployment of the stack will involve a download of a new docker daily image if it exists. Unless you are really sure about what you are doing, please use this procedure with caution.

The commonest reason for this procedure is using the latest daily testing docker image or a specific tag.

You can use option `-t` in the installer to specify a specific docker tag to be used by the installer.

To install the latest daily images:

```bash
./install_osm.sh -t releaseseven-daily
```

To install a previous version e.g. v6.0.3:

```bash
./install_osm.sh -t v6.0.3
```

The previous commands will do the installation and deployment of the stack, but will not make it persistent after re-deployments of the stack (or reboots). In order to make it persistent, you will have to update the file `docker-compose.yaml`. Below an example to update it to use `releaseseven-daily` tag:

```bash
sudo sed -i "s/ro\:\${TAG\:-latest}/ro\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/lcm\:\${TAG\:-latest}/lcm\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/mon\:\${TAG\:-latest}/mon\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/pol\:\${TAG\:-latest}/pol\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/nbi\:\${TAG\:-latest}/nbi\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/light-ui\:\${TAG\:-latest}/light-ui\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
sudo sed -i "s/keystone\:\${TAG\:-latest}/keystone\:\${TAG\:-releaseseven-daily}/" /etc/osm/docker/docker-compose.yaml
docker stack rm osm
docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

The OSM Client will have to be updated independently. In order to use the latest "testing" OSM Client, you will have to update the debian repo to use the testing repo, remove the previous debian package and install the one from the new repo as follows:

```bash
sudo apt-get remove python-osmclient
sudo apt-get remove pytho3-osmclient
# Clean the previous repos that might exist
sudo sed -i "/osm-download.etsi.org/d" /etc/apt/sources.list
sudo add-apt-repository -y "deb [arch=amd64] https://osm-download.etsi.org/repository/osm/debian/ReleaseSEVEN-daily testing osmclient"
sudo apt-get update
sudo apt-get install python3-osmclient
dpkg -l |grep python3-osmclient   #to check the installed version
```

### Upgrading only a specific component (advanced users)

**Upgrading a specific OSM component without upgrading the others accordingly may lead to potential inconsistencies.** Unless you are really sure about what you are doing, please use this procedure with caution.

One of the commonest reasons for this type of upgrade is using your own cloned repo of a module for development purposes.

The procedure below involves building manually some docker images. The developer environment might require updating manually the MTU of the docker default "bridge" network following the procedure in this link: https://docs.docker.com/network/bridge/

#### Upgrading RO

This involves upgrading (`ro` and `ro-db`):

```bash
docker pull mysql:5
git clone https://osm.etsi.org/gerrit/osm/RO
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build RO -f RO/Dockerfile-local -t opensourcemano/ro:develop --no-cache
docker service update osm_ro --force --image opensourcemano/ro:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/ro\:\${TAG\:-latest}/ro\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

#### Upgrading LCM

```bash
git clone https://osm.etsi.org/gerrit/osm/LCM
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build LCM -f LCM/Dockerfile.local -t opensourcemano/lcm:develop --no-cache
docker service update osm_lcm --force --image opensourcemano/lcm:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/lcm\:\${TAG\:-latest}/lcm\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

#### Upgrading MON

```bash
git clone https://osm.etsi.org/gerrit/osm/MON
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build MON -f MON/docker/Dockerfile -t opensourcemano/mon:develop --no-cache
docker service update osm_mon --force --image opensourcemano/mon:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/mon\:\${TAG\:-latest}/mon\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

#### Upgrading POL

```bash
git clone https://osm.etsi.org/gerrit/osm/POL
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build POL -f POL/docker/Dockerfile -t opensourcemano/pol:develop --no-cache
docker service update osm_pol --force --image opensourcemano/pol:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/pol\:\${TAG\:-latest}/pol\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

#### Upgrading NBI

```bash
git clone https://osm.etsi.org/gerrit/osm/NBI
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build NBI -f NBI/Dockerfile.local -t opensourcemano/nbi:develop --no-cache
docker service update osm_nbi --force --image opensourcemano/nbi:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/nbi\:\${TAG\:-latest}/nbi\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

#### Upgrading light UI

```bash
git clone https://osm.etsi.org/gerrit/osm/LW-UI
#you can then work in the cloned repo, apply patches with git pull, etc.
docker build LW-UI -f LW-UI/docker/Dockerfile -t opensourcemano/light-ui:develop --no-cache
docker service update osm_light-ui --force --image opensourcemano/light-ui:develop
# In order to make this change persistent after reboots or restart of the docker stack
# you will have to update the file /etc/osm/docker/docker-compose.yaml to reflect the change
# in the docker image, for instance:
# sudo sed -i "s/light-ui\:\${TAG\:-latest}/light-ui\:\${TAG\:-develop}/" /etc/osm/docker/docker-compose.yaml
# docker stack rm osm
# docker stack deploy -c /etc/osm/docker/docker-compose.yaml osm
```

### Upgrading only a specific component from source code (advanced users)

**FIXME:** The procedure described here needs revision, as it may work differently in the latest OSM release.

**Upgrading a specific OSM component without upgrading the others accordingly may lead to potential inconsistencies.** Unless you are really sure about what you are doing, please use this procedure with caution.

This procedure is useful to use the master branch or an old version for development purposes.

For this purpose, you can use options `-b` and `-m` in the installer:

```bash
./install_osm.sh --help
usage: ./install_osm.sh [OPTIONS]
Install OSM from binaries or source code (by default, from binaries)
 OPTIONS
...
    -b <refspec>:   install OSM from source code using a specific branch (master, v2.0, ...) or tag
                    -b master          (main dev branch)
                    -b v2.0            (v2.0 branch)
                    -b tags/v1.1.0     (a specific tag)
                    ...
    -m <MODULE>:    install OSM but only rebuild the specified docker images (LW-UI, NBI, LCM, RO, MON, POL, KAFKA, MONGO, PROMETHEUS, PROMETHEUS-CADVISOR, KEYSTONE-DB, NONE)
```

Or to use master branch in LCM:

```bash
./install_osm.sh -m LCM -b master
```

Or to use an old version of MON:

```bash
./install_osm.sh -m MON -b tags/v6.0.3
```

